var orderWarn = (function(){
	var layout = $('#orderWarn'),
		modelPath = layout.attr('modelpath'),
		info = modelPath + '/config.pur5',
		lastId = {
			success: 0,
			failed: 0
		},
		lastPayTime;
		Data = [];
	
	return {
		init: function(){
			lastPayTime = toJson(new Date());
			this.start();
		},
		start: function(){
			var self = this;
			window.setInterval(function(){
				if(Fso.read('controls/pop.pur5') != '1') return false;
				self.get();
				self.pop();
			}, 500);
		},
		get: function(){
			var thisAction = arguments.callee;
			if(isActionRunning(thisAction, 1000*60*15)) return false;
			
			var returnCount = 0,
				error = function(text, flag){
					var data;
					try{
						data = new Function('return ' + decodeURIComponent(text))();
					}catch(e){}
					deal(data, flag);
				},
				deal = function(data, flag){
					try{
						$.each(data.data[0].lists, function(index, item){
							item.paytime = item.paytime.replace(/\b(\d)\b/g,'0$1');
							if(lastPayTime > item.paytime) return true;
							Data.push({
								flag: flag,
								city: item.city,
								id: item.id,
								paytime: item.paytime,
								cztel: item.cztel,
								czst: item.czst
							});
						})
					}catch(e){}
				},
				complete = function(){
					returnCount++;
					if(returnCount == 2){
						thisAction.ing = false;
					}
				}

			$.ajax({
				url: Pur5.makeFullPath('payGetData.asp'),
				type: 'post',
				dataType: 'json',
				data: {
					GetdataType: 0,
					token: Pur5.getToken()
				},
				success: function(data){
					this.deal(data, 'success');
				},
				error: function(jqXhr, textStatus){
					try{
						error(jqXhr.responseText, 'success');
					}catch(e){}
				},
				complete: complete
			});
			$.ajax({
				url: Pur5.makeFullPath('payGetData.asp'),
				type: 'post',
				dataType: 'json',
				data: {
					GetdataType: 2,
					token: Pur5.getToken()
				},
				success: function(data){
					this.deal(data, 'success');
				},
				error: function(jqXhr, textStatus){
					try{
						error(jqXhr.responseText, 'failed');
					}catch(e){}
				},
				complete: complete
			});
		},
		pop: function(){
			var thisAction = arguments.callee;
			if(isActionRunning(thisAction, 1000*2)) return false;
			
			Data.sort(function(a, b){
				return a.id>b.id?1:-1;
			});
			var item = Data.shift();
			if(item){
				if(item.id <= lastId[item.flag]) return false;
				if(item.flag == 'success'){
					UI.pop(str_replace(item.czst + '：{1}\r\n{2}', item.cztel, item.city));
				}else{
					UI.pop(str_replace(item.czst + '：{1}\r\n{2}', item.cztel, item.czst));
				}
				lastId[item.flag] = item.id;
				//Fso.write(info, $.stringify(lastId));
			}
			thisAction.ing = false;
		},
		getLastData: function(callback){
			$.ajax({
				url: info,
				dataType: "json",
				success: function(lastData){
					lastId = lastData;
				},
				error: function(jqXhr, textStatus){},
				complete: function(){
					callback();
				}
			});
		}
	}
})();

$(function(){
	$.include('scripts/', [
		'inc/jquery.stringify.js',
		'inc/function.js',
		'inc/fso.js',
		'inc/pur5.js'
	], function(){
		window.setTimeout(function(){
			orderWarn.init();
		}, 1000);
	});
});