Pur5.Deal = (function(){
	var userId = pur5.Cfg.pur5Uid,
		token = pur5.Cfg.token;
		
	var orderIdHash = {
		paipai: 'dealCode',
		taobao: 'tid'
	}
		
	return {
		saveTrade: function(source, order, callback){
			$.ajax({
				url: Pur5.makeFullPath('offline/' + source + 'trading.asp'),
				type: 'post',
				dataType: 'json',
				timeout: 30000,
				data: {
					source: source,
					token: token,
					userId: userId,
					order: encodeURIComponent($.stringify($.extend(order, {
						source: source,
						tborder: order[orderIdHash[source]],
						userId: userId
					})))
				},
				success: function(result, textStatus, jqXhr){
					if(result && result.code){
						if(result.code == '0000' && result.value == order[orderIdHash[source]] || result.code == '1100'){
							callback(true);
						}else{
							callback(false, result.message, result.code);
						}
					}else{
						try{
							callback(false, jqXhr.responseText);
						}catch(e){
							callback(false);
						}						
					}
				},
				error: function(jqXhr, textStatus){
					try{
						callback(false, jqXhr.responseText?jqXhr.responseText:textStatus);
					}catch(e){
						callback(false, textStatus);
					}
				}
			});
		},
		deliver: function(source, order, callback){
			$.ajax({
				url: Pur5.makeFullPath('offline/' + source + 'trade.asp'),
				type: 'post',
				dataType: 'json',
				timeout: 30000,
				data: {
					source: source,
					token: token,
					userId: userId,
					order: encodeURIComponent($.stringify($.extend(order, {
						source: source,
						tborder: order[orderIdHash[source]],
						userId: userId
					})))
				},
				success: function(result, textStatus, jqXhr){
					if(result && (result.code == '0000' && result.value == order[orderIdHash[source]] || result.code == '1100')){
						callback(true);
					}else{
						try{
							callback(false, result.message);
						}catch(e){
							callback(false, jqXhr.responseText);
						}
					}
				},
				error: function(jqXhr, textStatus){
					try{
						callback(false, jqXhr.responseText?jqXhr.responseText:textStatus);
					}catch(e){
						callback(false, textStatus);
					}
				}
			});
		},
		t3: function(source, callback){
			$.ajax({
				url: Pur5.makeFullPath('offline/GetTradingList.asp'),
				type: 'post',
				dataType: 'json',
				data: {
					source: source,
					token: token,
					userId: userId
				},
				success: function(result){
					if(result && result.code == '0000' && js_type(result.value) == 'Array' && result.value.length){
						callback(result.value);
					}else{
						callback(false, result.message);
					}
				},
				error: function(jqXhr){
					callback(false);
				}
			});
		}
	}
})();