var Snap = (function(){
	var template = '<div class="gridview" header="1" footer="0" actived="1">\
        <table>\
          <thead>\
            <tr>\
			  <th width="30"><input type="checkbox" class="noborder" /></th>\
              <th>截图</th>\
			  <th width="70">操作</th>\
            </tr>\
          </thead>\
          <tbody>\
            <tr>\
			  <td align="center" class="checker"><input type="checkbox" class="noborder" /></td>\
              <td><div class="snapItem" style="background-image:url($pic);"></div></td>\
			  <td align="center"><span class="button2 delBtn">删除</span></td>\
            </tr>\
          </tbody>\
        </table>\
      </div>';
	  
	var Data = [],
		basePath = '../snap/',
		Ax,
		Callback = {
			afterSnap: function(){}
		};
		
	try{
		Ax = $('<object id="snapAx" style="display: none;"\
				classid="clsid:40EA84D1-04AE-40ED-B145-618E5CC673D4"></object>').appendTo(document.body)[0];			
		
		Ax.attachEvent('onstart', function(){
			if(SnapConfig.isHideUIWhenSnap()){
				UI.showTray();
				UI.hide();
			}
		});
		
		Ax.attachEvent('oncancel', function(){
			UI.show();
			UI.hideTray();
		});
		
		Ax.attachEvent('onendcap', function(base64Pic){
			UI.show();
			UI.hideTray();

			var filePath = basePath + new Date().getTime() + '.jpg'
			Data.push({
				filePath: filePath,
				base64Pic: base64Pic
			});
			Fso.saveBase64Pic(filePath, base64Pic);
			SnapConfig.refresh();
			Callback.afterSnap();
		});		
		
		Ax.mode = 2;
		Ax.picLevel = 80;
	}catch(e){
		alert('截图功能错误' + (e.description? (':' + e.description):''));
	}
	
	return {
		get: function(cb){
			if(js_type(cb) == 'Function'){
				Callback.afterSnap = cb;
			}
			Ax.start();
		},
		getData: function(){
			return Data;
		},
		del: function(i){//删除指定位置的图片
			Fso.del(Data[i].filePath);
			Data.splice(i,1);
		},
		clear: function(){
			var self = this;
			$.each(Data, function(index, snap){
				self.del(0);
			});
		},
		select: function(selectedIndexs, cb, closeCallback, width, height){//列表选择
			Dialog.alert({
				title: '截图选择',
				content: template,
				style: {
					width: width || 750,
					height: height || 410
				},
				closeCallback: closeCallback,
				button: {
					'确 定': function($content){
						var ids = $content.find('.gridview').triggerHandler('getRow', [false, true]),
							base64Pics = [],
							selectedIndexs = [];
						$.each(ids, function(index, i){
							base64Pics.push(Data[i].base64Pic);
							selectedIndexs.push(i);
						});
						cb && cb({
							base64Pics: base64Pics,
							selectedIndexs: selectedIndexs
						});
					}
				},
				action: function($content){
					$content.find('.gridview').gridview().trigger('refresh', [{
						noResize: true,
						list: Data,
						filter: {
							pic: function(){
								return this.filePath
							}
						}
					}]).trigger('active', [selectedIndexs || []])
					.pur5UI().find('div.snapItem').css({
						height: 200,
						'background-repeat': 'no-repeat',
						border: '5px solid #ccc'
					}).end().find('span.delBtn').click(function(){
						var $row = $(this).parent().parent();
						Snap.del($row.index());
						$row.remove();
					});
				}
			});
		}
	}
})();

pur5.Pages.snap = function(){
	Snap.get();
}

$(window).bind('unload', function(){
	Snap.clear();
});