PP.App = (function(){
	var App = false;
	
	return {
		get: function(){
			return App;
		},
		getList: function(callback){
			var url = 'http://fuwu.paipai.com/my/app/appListPage.xhtml';
			$.ajax({
				url: url,
				cache: false,
				dataType: 'text',
				success: function(content){
					var content = content.replace(/(>)\s*(\S*)\s*(<)/g, '$1$2$3'),
						reg = /<p class="name" id="Name(\d+)"><a href="appDetail.xhtml\?appId=\1">([^<]+)<\/a><\/p/g,
						list = [],
						listFlag = '创建应用';
						
						content.replace(reg, function(){
							var arg = arguments;
							list.push({
								id: arg[1],
								name: arg[2]
							});
						})
						callback && callback(list);
				},
				error: function(){
					alert('获取应用列表出错');
				}
			});
		},
		create: function(appName, callback){
			var url = 'http://fuwu.paipai.com/my/app/saveAppPage.xhtml';
			
			var self = this;
			$.ajax({
				url: url,
				cache: false,
				dataType: 'text',
				data: {
					appName: encodeURIComponent(appName),
					appTag: 0,
					appType: 0
				},
				success: function(content){
					var content = content.replace(/(>)\s*(\S*)\s*(<)/g, '$1$2$3'),
						successTag = /应用创建成功/;
					
					var appId;
					try{
						appId = getFields({
							id: /<p><a href="\/my\/app\/appDetail.xhtml\?appId=(\d+)">查看应用详情<\/a>/
						}, content).id;
					}catch(e){}
						
					if(!successTag.test(content) || !appId){
						alert('创建应用失败');
						return false;
					}
					
					self.getById(appId, callback);
					
					
					/*App = getFields({
						spid: /spid：(\w+)/,
						token: /token：(\w+)/,
						seckey: /seckey：(\w+)/
					}, content);if(!App.token) App = false;

					callback && callback(App);
*/				},
				error: function(){
					alert('创建应用出错');
				}
			});
		},
		del: function(appId, callback){
			$.get('http://fuwu.paipai.com/my/app/modifyAppStatus.xhtml?appId='+appId+'&operate=del');
		},
		getById: function(appId, callback){
			var self = this,
				url = 'http://fuwu.paipai.com/my/app/appDetail.xhtml?appId=' + appId;
			
			$.ajax({
				url: url,
				cache: false,
				dataType: 'text',
				success: function(content){
					var content = content.replace(/(>)\s*(\S*)\s*(<)/g, '$1$2$3');
					App = getFields({
						spid: /spid：(\w+)/,
						token: /token：(\w+)/,
						seckey: /seckey：(\w+)/,
						
						appOAuthID: /appOAuthID：(\w+)/,
						secretOAuthKey: /secretOAuthKey：(\w+)/,
						oAuthId: /appOAuthID：(\d+)/,
						accessTokenUrl: /getAppTempToken.xhtml\?appOAuthID=(\d+)"><span>获取AccessToken<\/span>/
					}, content);
					
					if(App.spid && App.seckey && App.token){
						callback && callback(App);
						return false;
					}
					
					if(App.oAuthId != App.accessTokenUrl){
						callback && callback(false);
						return false;
					}
					
					App.spid = App.appOAuthID;
					App.seckey = App.secretOAuthKey;
					App.token = App.appOAuthID;
					
					self.getAccessToken(App.oAuthId, function(accessToken){
						if(!accessToken){
							callback && callback(false);
							return false;
						}
						App.accessToken = accessToken;
						callback && callback(App);
					});					
				},
				error: function(){
					alert('获取应用出错');
				}
			});
		},
		getByName: function(appName, callback){
			var self = this;
			self.getList(function(list){
				var thisApp = false;
				$.each(list, function(index, app){
					if(appName != app.name) return true;
					
					if(!thisApp){
						thisApp = app;
					}else{
						self.del(app.id);
					}
				});
				if(!thisApp){
					callback(false);
				}else{
					self.getById(thisApp.id, callback);
				}
			});
		},
		getAccessToken: function(id, callback){
			var self = this,
				url = 'http://fuwu.paipai.com/my/app/getAppTempToken.xhtml?appOAuthID=' + id;
				
			$.ajax({
				url: url,
				cache: false,
				dataType: 'text',
				success: function(content){
					var content = content.replace(/(>)\s*(\S*)\s*(<)/g, '$1$2$3'),
						accessToken;
					try{
						accessToken = getFields({
							token: /<span class="code">(\w+)<\/span>该授权码/
						}, content).token;
					}catch(e){}
					
					if(accessToken){
						callback && callback(accessToken);
					}else{
						callback && callback(false);
					}
				},
				error: function(){
					callback && callback(false);
				}
			});
		},
		getPur5App: function(callback){
			PP.Sp.register(function(isSuccess){
				if(!isSuccess){
					alert('不能成功注册为服务商');
					return false;
				}
				var appName = 'orderSeek';
				PP.App.getByName(appName, function(app){
					if(!app){
						PP.App.create(appName, function(app){
							if(!app){
								alert('应用创建失败');
							}else{
								callback(app);
							}
						});
					}else{
						callback(app);
					}
				});
			});
		}
	}
})();