local function Hook(inst, owner, x, y)	
	inst.DynamicShadow:SetSize(x, y)
	--owner:AddChild(inst)
	
	local function UpdatePosition()
		local x, y, z = owner.Transform:GetWorldPosition()
		inst.Transform:SetPosition(x, 0, z)
	end
	
	UpdatePosition()
	inst:DoPeriodicTask(FRAMES, UpdatePosition)
	
	return inst	
end

local function fn()
    local inst = CreateEntity()
	
	inst.entity:AddTransform()
    inst.entity:AddDynamicShadow()
    inst.entity:AddNetwork()
	
	inst:AddTag("FX")
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false
	
	inst.Hook = Hook
	
	return inst
end

return Prefab("dynamicshadow", fn)