name = "Basements"
description =
[[Build your own basements, hide inside to avoid danger, store food to preserve it for longer, and never forget to take a light source to find a way out in the endless darkness.

More features and configuration options coming soon.]]

author = "Tykvesh"
version = "1.2"
forumthread = ""
server_filter_tags = { "Basements", "Tykvesh" }

standalone = false
restart_required = false
dst_compatible = true
api_version_dst = 10
--priority = 1
all_clients_require_mod = true
client_only_mod = false

icon_atlas = "modicon.xml"
icon = "modicon.tex"

local sections = 0

local function divide(label, tip)
	sections = sections + 1
	return
	{	
		name = "menu_divider" .. sections,
		label = label,
		options =
		{	
			{ description = "", data = false },
		},
		default = false,
	}
end

local function recipe_ingredients(description, steelwool, cutstone, gunpowder)
	return
	{
		description = description,
		data = "" .. steelwool .. "/" .. cutstone .. "/" .. gunpowder,
		hover = "Steel Wool x" .. steelwool .. ", Cut Stone x" .. cutstone .. ", Gunpowder x" .. gunpowder .. ".",
	}
end

local function recipe_tab(tab)
	return
	{
		description = tab,
		data = tab:upper(),
		hover = "Crafting Tab: " .. tab,
	}
end

local function sanity(value)
	return
	{
		description = value ~= 0 and ("" .. value .. "/min") or "Disabled",
		data = value,
		hover = "",
	}
end

local function temperature(value)
	return
	{
		description = value ~= 0 and ("" .. value) or "Disabled",
		data = value,
		hover = "",
	}
end

configuration_options = 
{
	divide("Craft Recipe", "Recipe configuration options."),
	
	{	
		name = "recipe_ingredients",
		label = "Difficulty",
		hover = "Amount of ingredients required for basement.",
		options =
		{	
			recipe_ingredients("Free", 1, 1, 1),
			recipe_ingredients("Very Easy", 4, 30, 8),
			recipe_ingredients("Easy", 6, 42, 12),
			recipe_ingredients("Medium", 8, 50, 20),
			recipe_ingredients("Hard", 12, 68, 20),
			recipe_ingredients("Very Hard", 20, 68, 20),
			recipe_ingredients("Ewecus Grinder", 40, 68, 20),
		},
		default = "12/68/20",
	},
	
	{	
		name = "recipe_tab",
		label = "Tab",
		hover = "Basement crafting recipe tab.",
		options =
		{	
			recipe_tab("Survival"),
			recipe_tab("Farm"),
			recipe_tab("Science"),
			recipe_tab("Town"),
		},
		default = "SCIENCE",
	},
			
	divide("Basement Environment", "Set up basement environment options."),
	
	{	
		name = "sanity",
		label = "Dapperness",
		hover = "Amount of insanity pressure.",
		options =
		{
			sanity(0),
			sanity(-3),
			sanity(-5),
			sanity(-10),
		},
		default = -5,
	},
	
	{	
		name = "temperature",
		label = "Coolness",
		hover = "Amount of coldness felt by characters. Doesn't affect spoil rate.",
		options =
		{
			temperature(0),
			temperature(-5),
			temperature(-10),
			temperature(-15),
			temperature(-20),
		},
		default = -10,
	},
	
	divide("Miscellaneous", ""),
	
	{	
		name = "language",
		label = "Language",
		options =
		{	
			{ description = "English", data = false, hover = "English" },
			{ description = "Russian", data = "ru", hover = "Russian (Русский)" },
		},
		default = false,
	},
}