modimport("scripts/tools/waffles")

-- Подвалы --

table.insert(PrefabFiles, "basement")
table.insert(PrefabFiles, "sparkle_fx")

table.insert(Assets, Asset("ATLAS", "images/inventoryimages/basement.xml"))
AddMinimapAtlas("images/inventoryimages/basement.xml")

AddPrefabPostInit("world", function(inst)
	local Map = getmetatable(inst.Map).__index
	
	Waffles.SequenceFn(Map, "IsPassableAtPoint", function(passable, x, y, z)
		if passable then
			return true
		end
		return #TheSim:FindEntities(x, y, z, 18, { "alt_tile" }) > 0
	end)
	
	Waffles.SequenceFn(Map, "GetTileCenterPoint", function(pos)
		if pos ~= nil then
			return unpack(pos)
		end
		return 0, 0, 0
	end)
end)

Waffles.GetPath(_G, "STRINGS/ACTIONS/JUMPIN").USE = Waffles.ReturnChild(STRINGS, "ACTIONS/USEITEM") or "Use"

Waffles.GetPath(_G, "ACTIONS/JUMPIN").strfn = function(act)
    return act.doer ~= nil and act.doer:HasTag("playerghost") and "HAUNT"
		or act.target ~= nil and act.target:HasTag("stairs") and "USE"
		or nil
end

Waffles.AddCharacterQuotes("DESCRIBE", "BASEMENT_ENTRANCE",
{
	GENERIC =
	{
		GENERIC = "The chemicals are bubbling below.",
		OPEN = "To the Secret Lab!",
	},
	WILLOW =
	{
		GENERIC = "I could trap the smoke in here.",
		OPEN = "Is this a fire pit?",
	},
	WOLFGANG =
	{
		GENERIC = "Scary hole is closed.",
		OPEN = "Wolfgang dislike scary basement.",
	},
	WENDY =
	{
		GENERIC = "Maybe I can hide from everyone in there?",
		OPEN = "I can finally go and be there. Among the dark...",
	},
	WX78 =
	{
		GENERIC = "OPEN THE CELLAR'S GRAY DOORS",
		OPEN = "A PLACE TO HIDE FROM INFERIORS",
	},
	WICKERBOTTOM =
	{
		GENERIC = "I do hope no one is in there.",
		OPEN = "A quiet place to read.",
	},
	WOODIE =
	{
		GENERIC = "Closed, eh?",
		OPEN = "Deeper than the pit of a stump eh?",
	},
	WAXWELL =
	{
		GENERIC = "It will not stop Them.",
		OPEN = "Charlie must be creeping around somewhere.",
	},
	WATHGRITHR =
	{
		GENERIC = "Will there be a foe in there?",
		OPEN = "I would rather be fighting.",
	},
	WEBBER =
	{
		GENERIC = "We want to pull the plug!",
		OPEN = "It looks scary down there.",
	},
	WINONA =
	{
		GENERIC = "It's closing time.",
		OPEN = "The workshop is open for business.",
	},
})

Waffles.AddCharacterQuotes("DESCRIBE", "BASEMENT_EXIT",
{
	GENERIC = "It's time for a field test.",
	WILLOW = "The firewood is up there.",
	WOLFGANG = "Escape scary room!",
	WENDY = "The way in the unknown...",
	WX78 = "UP AND ATOM",
	WICKERBOTTOM = "A walkway leading to the outdoors.",
	WOODIE = "Wanna go chopping some trees, Lucy?",
	WAXWELL = "Up to the light of day.",
	WATHGRITHR = "Up to the battlefield!",
	WEBBER = "Where do they go?",
	WINONA = "A bit rough on the edges, but it'll do.",
})

Waffles.AddCharacterQuotes("ACTIONFAIL/BUILD", "LOWCEILING",
{
	GENERIC = "It won't fit in here.",
	WILLOW = "It won't fit. Then I will burn it!",
	WOLFGANG = "It not fit!",
	WENDY = "It won't fit here, like my soul...",
	WX78 = "WE MUST RAISE THE ROOF.",
	WICKERBOTTOM = "The height of this basement is rather limited.",
	WOODIE = "This ceiling is lower than a fallen evergreen eh?",
	WAXWELL = "It seems we will need to cut this down to size.",
	WATHGRITHR = "Not a proper stage for building that.",
	WEBBER = "It won't fit!",
	WINONA = "It's a bit too cramped in here.",
})

Waffles.AddPrefabStrings("basement_entrance_builder", "Basement", "A misty vault to hide in.")

Waffles.AddPrefabStrings("basement_entrance", "Hatch")

Waffles.AddPrefabStrings("basement_exit", Waffles.ReturnChild(_G, "STRINGS/NAMES/CAVE_EXIT") or "Stairs")

if TheConfiguration.language == "ru" then
	STRINGS.NAMES.BASEMENT_ENTRANCE = "Люк"

	STRINGS.NAMES.BASEMENT_ENTRANCE_BUILDER = "Подвал"
	STRINGS.RECIPE_DESC.BASEMENT_ENTRANCE_BUILDER = "Туманное убежище."
end

local steelwool, cutstone, gunpowder = string.match(TheConfiguration.recipe_ingredients, "(%d+)/(%d+)/(%d+)")
AddRecipe("basement_entrance_builder", {Ingredient("steelwool", steelwool), Ingredient("cutstone", cutstone), Ingredient("gunpowder", gunpowder)},
RECIPETABS[TheConfiguration.recipe_tab], TECH.SCIENCE_TWO, "basement_entrance_placer", 4, nil, nil, nil, "images/inventoryimages/basement.xml", "basement.tex",
function(pt, rot)
	if #TheSim:FindEntities(pt.x, 0, pt.z, 36, { "basement_part" }) > 0 then
		return false
	end
	for x = -2, 1.5, 0.5 do
		for z = -2, 1.5, 0.5 do
			if not TheWorld.Map:IsPassableAtPoint(pt.x + x, 0, pt.z + z) then
				return false
			end
		end
	end
	return true
end)

--[[!]] if not IsServer then return end

AddStategraphState("wilson", State {
	name = "jumpout_ceiling",
	tags = { "doing", "busy", "canrotate", "nopredict", "nomorph" },

	onenter = function(inst)
		_G.TemporarilyRemovePhysics(inst, 0.5)
		inst.components.locomotor:Stop()
		
		inst.AnimState:PlayAnimation("jumpout")
		inst.AnimState:SetTime(0.2)
		
		local x, y, z = inst.Transform:GetWorldPosition()
		inst.Physics:Teleport(x, 4, z)
		inst.Physics:SetMotorVel(5, -8, 0)
		
		Waffles.PushFakeShadow(inst, 18 * FRAMES, 1.3, 0.6)
		
		inst.AnimState:SetMultColour(0, 0, 0, 1)
		inst.components.colourtweener:StartTween({ 1, 1, 1, 1 }, 10 * FRAMES)
	end,

	timeline =
	{
		TimeEvent(10 * FRAMES, function(inst)
			inst.Physics:SetMotorVel(2, -8, 0)
		end),
		TimeEvent(15 * FRAMES, function(inst)
			inst.Physics:SetMotorVel(0, -8, 0)
		end),
		TimeEvent(15.2 * FRAMES, function(inst)
			inst.SoundEmitter:PlaySound("dontstarve/movement/bodyfall_dirt")
		end),
		TimeEvent(17 * FRAMES, function(inst)
			inst.Physics:SetMotorVel(0, -8, 0)
		end),
	},

	events =
	{
		EventHandler("animover", function(inst)
			if inst.AnimState:AnimDone() then
				inst.Physics:Stop()
				inst.sg:GoToState("idle")
			end
		end),
	},
})

AddStategraphPostInit("wilson", function(sg)
	local jumpin = sg.states.jumpin
	if jumpin ~= nil then
		local onenter = jumpin.onenter
		jumpin.onenter = function(inst, data)
			if data ~= nil and data.teleporter ~= nil
			and data.teleporter:HasTag("stairs") then
				inst.sg:GoToState("jump_stairs", data)
			else
				onenter(inst, data)
			end
		end
	end
end)

AddStategraphState("wilson", State {
	name = "jump_stairs",
	tags = { "doing", "busy", "canrotate", "nopredict", "nomorph" },

	onenter = function(inst, data)
		_G.TemporarilyRemovePhysics(inst, 42 * FRAMES)
		inst.components.locomotor:Stop()
		
		inst.sg.statemem.target = data.teleporter
		inst.sg.statemem.teleportarrivestate = "jumpout"
		
		inst.AnimState:PlayAnimation("jump_pre")
		
		Waffles.PushFakeShadow(inst, 42 * FRAMES, 1.3, 0.6)
	end,

	timeline =
	{
		TimeEvent(5 * FRAMES, function(inst)
			inst.AnimState:PlayAnimation("jumpout")
			inst.AnimState:SetTime(0.15)
			inst.Physics:SetMotorVel(4, 5, 0)
			
			if inst.components.inventory:IsHeavyLifting() then
				inst:PushEvent("encumberedwalking")
				Waffles.PlayCharacterSound(inst, "pose")
			end
		end),
		TimeEvent(16 * FRAMES, function(inst)
			inst.SoundEmitter:PlaySound("dontstarve/common/dropGeneric")
		end),
		TimeEvent(20 * FRAMES, function(inst)
			inst.Physics:SetMotorVel(0, 0, 0)
			local turn = (math.random() < 0.5 and -1 or 1) * 90
			inst.Transform:SetRotation(inst.Transform:GetRotation() + turn)
			inst.AnimState:PushAnimation("jump_pre")
		end),
		TimeEvent(31 * FRAMES, function(inst)
			inst.components.colourtweener:StartTween({ 0, 0, 0, 1 }, 6 * FRAMES)
		end),
		TimeEvent(33 * FRAMES, function(inst)
			inst.AnimState:PlayAnimation("jumpout")
			inst.AnimState:SetTime(0.15)
		end),
		TimeEvent(35 * FRAMES, function(inst)
			inst.Physics:SetMotorVel(3, 6, 0)
		end),
		TimeEvent(41 * FRAMES, function(inst)
			inst.Physics:SetMotorVel(0, 0, 0)
			if inst.sg.statemem.target ~= nil
			and	inst.sg.statemem.target:IsValid()
			and	inst.sg.statemem.target.components.teleporter ~= nil then
				inst.sg.statemem.target.components.teleporter:UnregisterTeleportee(inst)
				if inst.sg.statemem.target.components.teleporter:Activate(inst) then
					inst.sg.statemem.isteleporting = true
					inst.components.health:SetInvincible(true)
					if inst.components.playercontroller ~= nil then
						inst.components.playercontroller:Enable(false)
					end
					inst:Hide()
					inst.DynamicShadow:Enable(false)
					return
				end
			end
			inst.sg:GoToState("jumpout")
		end),
	},
	
	onexit = function(inst)
		inst.AnimState:SetMultColour(1, 1, 1, 1)
		inst.Physics:Stop()		
		if inst.sg.statemem.isteleporting then
			inst.components.health:SetInvincible(false)
			if inst.components.playercontroller ~= nil then
				inst.components.playercontroller:Enable(true)
			end
			inst:Show()
			inst.DynamicShadow:Enable(true)
		elseif inst.sg.statemem.target ~= nil
		and inst.sg.statemem.target:IsValid()
		and inst.sg.statemem.target.components.teleporter ~= nil then
			inst.sg.statemem.target.components.teleporter:UnregisterTeleportee(inst)
		end
	end,
})

AddPrefabPostInit("telestaff", function(inst)
	if inst.components.spellcaster ~= nil then
		local spell = inst.components.spellcaster.spell
		inst.components.spellcaster:SetSpellFn(function(...)
			local x, y, z = inst.Transform:GetWorldPosition()
			if #TheSim:FindEntities(x, y, z, 25, { "alt_tile" }) > 0 then
				if TheWorld:HasTag("cave") then
					TheWorld:PushEvent("ms_miniquake", { rad = 3, num = 5, duration = 1.5, target = inst })
				else
					SpawnPrefab("thunder_close")
				end
				if inst.components.finiteuses ~= nil then
					inst.components.finiteuses:Use(1)
				end
				return
			end				
			spell(...)
		end)
	end
end)