VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form PlotComFrm 
   Caption         =   "PlotComm"
   ClientHeight    =   4230
   ClientLeft      =   1680
   ClientTop       =   3330
   ClientWidth     =   5775
   Icon            =   "PlotComFrm.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4230
   ScaleWidth      =   5775
   Begin VB.TextBox Term 
      Height          =   4215
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   3  '̬Ҧ
      TabIndex        =   0
      Top             =   0
      Width           =   5775
   End
   Begin MSComDlg.CommonDialog Cdl 
      Left            =   420
      Top             =   4080
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
      Flags           =   2
      HelpKey         =   "0"
   End
   Begin VB.Menu cmFile 
      Caption         =   "File"
      Begin VB.Menu cmOpenFile 
         Caption         =   "Open File"
      End
      Begin VB.Menu test2 
         Caption         =   "-"
      End
      Begin VB.Menu cmExit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu cmSetting 
      Caption         =   "Setting..."
   End
   Begin VB.Menu Help 
      Caption         =   "Help"
      Begin VB.Menu cmAbout 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "PlotComFrm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'****************************************************************
'    Simple.bas
'     -- Main window for simple dumb terminal example program.
'
'    Description:
'      1.Select "setting..." menu item to set com port option.
'      2.Select "Open" menu item to open com port.
'        After selected "Open" from menu,you can type any character
'        to send to com port.When any data received from com port,
'        program will dump data to window.
'      3.Select "Close" menu item to close com port.
'
'    This program demo:
'        How to open com port(sio_open);
'        How to set commnunication parameter(sio_ioctl,sio_flowctrl);
'        How to control line status(sio_DTR,sio_RTS);
'        How to send data to com port(sio_write,sio_putch);
'        How to read data(sio_read);
'        How to close com port(sio_close);
'        How to use background thread to read data.
'
'    Use function:
'        sio_open,       sio_close,   sio_ioctl,
'        sio_flowctrl,   sio_DTR,     sio_RTS,
'        sio_read,       sio_putch,   sio_write.
'        sio_SetWriteTimeouts;
'
'    History:   Date       Author         Comment
'               6/1/98     Casper         Wrote it.
'
'****************************************************************


Option Explicit
Public GbOpen As Boolean
Public GszAppName As String

Dim Ldx As Long
Dim Ldy As Long

'Private Sub cmOpen_Click()
'    Call OpenPort
'End Sub

'Private Sub cmClose_Click()
'    Call ClosePort
'End Sub

'Private Sub cmClear_Click()
'    Term.Text = ""
'End Sub

'Private Sub cmSendAscii_Click()
'    Call SendAscii
'End Sub

Private Sub Form_Load()
Dim Plot0%, PlotSet1$, Dm$, Dummy%
    
    Open "C:\ProDoCad\ProMess\Plot\SetPlot.Stp" For Input Shared As #2 ' Pro Jet 180
       Lock #2
       Input #2, Plot0, Dummy, Dummy
       Input #2, PlotSet1, Dm, Dm
       Unlock #2
    Close #2
    
    'If Plot0 > 4 Then Printer Port
    If Plot0 > 3 Then End
    
    LoadConfig
        'With GCommData
        '    .Port = 1
        '    .BaudRate = B9600
        '    .ibaudrate = 12
        '    .Parity = P_NONE
        '    .iparity = 0
        '    .ByteSize = BIT_8
        '    .ibytesize = 3
        '    .StopBits = STOP_1
        '    .istopbits = 0
        '    .Hw = 0
        '    .Sw = 0
        '    .Dtr = 1
        '    .Rts = 1
        '    .AddChk = 0
        'End With
    
    
    Ldx = Width - Term.Width
    Ldy = Height - Term.Height
    GhExit = False
    GbOpen = False
    GszAppName = "PlotCom Demo"
    Set GhForm = PlotComFrm
    
    Call InitTable
    Call SwitchMenu
    
          GCommData.Port = Plot0
       If InStr(PlotSet1, "9600") Then GCommData.ibaudrate = 12
       If InStr(PlotSet1, "19200") Then GCommData.ibaudrate = 13
       If InStr(PlotSet1, "38400") Then GCommData.ibaudrate = 14
       If InStr(PlotSet1, ",N,") Then GCommData.iparity = 0
       If InStr(PlotSet1, ",E,") Then GCommData.iparity = 1
       If InStr(PlotSet1, ",O,") Then GCommData.iparity = 2
       If InStr(PlotSet1, ",7,") Then GCommData.ibytesize = 2
       If InStr(PlotSet1, ",8,") Then GCommData.ibytesize = 3
       If InStr(PlotSet1, ",1") Then GCommData.istopbits = 0
       If InStr(PlotSet1, ",2") Then GCommData.istopbits = 1
    Call OpenPort
       PlotFileName = "C:\ProDoCad\ProMess\Plot\Current.Plt"
    Call SendAscii
    Call ClosePort
       Unload PlotComFrm
    End
End Sub

Private Sub Form_Resize()
    If WindowState <> vbMinimized Then
        Term.Width = Width - Ldx
        Term.Height = Height - Ldy
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    If GbOpen Then
        Call ClosePort
    End If
End Sub

Private Sub cmOpenFile_Click()
Dim EventDo%
Dim TermLen%

On Error GoTo ErrLoad
    
    Cdl.FileName = FnFileName(PlotFileName)
 If PlotFileName = "" Then
    Cdl.InitDir = "C:\ProDoCad\ProMess\Plot\"
  Else
    Cdl.InitDir = FnPath(PlotFileName)
  End If
    Cdl.Filter = "Plot File|*.Plt|All File|*.*|"
    Cdl.ShowOpen
    PlotFileName = Cdl.FileName
 'If InStr(PlotFileName, ".Plt") = 0 Then PlotFileName = PlotFileName + ".Plt"

          TermLen = LenB(Term.Text)
          Term.SelStart = TermLen
          Term.SelLength = 0
          Term.SelText = "Ploting " + PlotFileName + Chr(13) + Chr(10)
       EventDo = DoEvents
    Call OpenPort
    Call SendAscii
    Call ClosePort
          TermLen = LenB(Term.Text)
          Term.SelStart = TermLen
          Term.SelLength = 0
          Term.SelText = "Finish Plot" + Chr(13) + Chr(10)

ErrLoad:
End Sub


Private Sub cmSetting_Click()
Dim bakdata As COMMDATA

    bakdata = GCommData
    Config.Show vbModal
    If (GbOpen) Then
        If (PortSet() = False) Then
            GCommData = bakdata
            Exit Sub
        End If
    End If
    Call ShowStatus
End Sub

Private Sub cmAbout_Click()
    About.AboutTxt1.Caption = "PLotCom Example"
    About.Show
End Sub

Private Sub cmExit_Click()
    If GbOpen Then
        Call ClosePort
    End If
       Unload PlotComFrm
    End
End Sub

Sub SwitchMenu()
    'cmOpen.Enabled = Not GbOpen
    'cmClose.Enabled = GbOpen
    'cmSendAscii.Enabled = GbOpen
End Sub

Private Sub Term_KeyPress(KeyAscii As Integer)
    If GbOpen Then
       ' Send the keystroke to the port.
       Call sio_putch(GCommData.Port, KeyAscii)
       KeyAscii = 0
    End If
End Sub

Private Function OpenPort() As Boolean
Dim ret As Long
Dim syserr As Long
    
    OpenPort = False
    
    ret = sio_open(GCommData.Port)
    If ret <> SIO_OK Then
        Call MxShowError("sio_open", ret, GetLastError())
        sio_close (GCommData.Port)
        Exit Function
    End If
    
    If PortSet() = False Then
        sio_close (GCommData.Port)
        Exit Function
    End If
    
    ret = sio_cnt_irq(GCommData.Port, AddressOf RxIrq, 1)
    If ret <> SIO_OK Then
        Call MxShowError("sio_cnt_irq", ret, GetLastError())
        sio_close (GCommData.Port)
        Exit Function
    End If
    
    OpenPort = True
    GbOpen = True
    Call SwitchMenu
    Call ShowStatus
End Function


Private Function ClosePort()
    GhExit = False
    Call sio_cnt_irq(GCommData.Port, 0, 1)
    sio_close (GCommData.Port)
    GbOpen = False
    Call SwitchMenu
    Call ShowStatus
End Function

Private Function SendAscii() As Boolean
Dim buf(0 To 511) As Byte
Dim i, k, okSent As Integer
Dim j As Long
Dim tout, baktout As Long
Dim Dm$
Dim rlen As Long
Dim ret As Long
Dim pth As Long


    Call sio_GetWriteTimeouts(GCommData.Port, baktout)
    
       tout = 1000 / sio_getbaud(GCommData.Port)  'ms /byte'
    If tout < 1 Then tout = 1
       tout = tout * 256 * 2             ' 256 byte;*2 for delay
    Call sio_SetWriteTimeouts(GCommData.Port, tout)


Open PlotFileName For Input Shared As #2

While Not EOF(2)
        Line Input #2, Dm

   If GCommData.AddChk Then
               j = Len(Dm) - 1
         For i = 0 To j
            Do
                      okSent = 1
               If j Mod 8 = 0 Then
                      rlen = 0
                  While rlen = 0
                      rlen = sio_read(GCommData.Port, buf(0), 512)
                   Wend
          
                      AgrBuf = Str(buf(rlen - 1))
                  'If InStr(AgrBuf, "17") = 0 Then okSent = 0
                   If InStr(AgrBuf, "19") Then okSent = 0
                End If
            Loop Until okSent = 1

            Do
                  pth = sio_putch(GCommData.Port, Asc(Mid(Dm, i + 1, 1)))
            Loop Until pth = 1
          Next
    
    Else
               j = Len(Dm)
      If j > 0 Then
         For i = 0 To j - 1
               buf(i) = Asc(Mid(Dm, i + 1, 1))
          Next

         Call sio_write(GCommData.Port, buf(0), j)
       End If
    End If

Wend
Close #2
    
       Call sio_SetWriteTimeouts(GCommData.Port, baktout)


                      
'        ret = sio_DTR(GCommData.Port, GCommData.Dtr)
'        rlen = sio_read(GCommData.Port, buf(0), 512)
'        pth = sio_putch(GCommData.Port, Asc(Mid(Dm, i + 1, 1)))
'        Call sio_write(GCommData.Port, buf(0), j)
'        Call sio_write(GCommData.Port, buf(0), 256)
End Function


Private Function PortSet() As Boolean
Dim Port As Long
Dim mode As Long
Dim Hw  As Long, Sw As Long
Dim ret As Long
Dim tout As Long

    Port = GCommData.Port
    mode = GCommData.Parity Or GCommData.ByteSize Or GCommData.StopBits
    If GCommData.Hw = 1 Then
        Hw = 3      'bit0 and bit1
    Else
        Hw = 0
    End If
    If GCommData.Sw = 1 Then
        Sw = 12     'bit2 and bit3
    Else
        Sw = 0
    End If
    
    PortSet = False
    
    ret = sio_ioctl(Port, GCommData.BaudRate, mode)
    If ret <> SIO_OK Then
        Call MxShowError("sio_ioctl", ret, GetLastError())
        Exit Function
    End If

    ret = sio_flowctrl(Port, Hw Or Sw)
    If ret <> SIO_OK Then
        Call MxShowError("sio_flowctrl", ret, GetLastError())
        Exit Function
    End If

    ret = sio_DTR(Port, GCommData.Dtr)
'MsgBox CStr(ret) + "," + CStr(SIO_OK) + "," + CStr(GCommData.Dtr)
    If ret <> SIO_OK Then
        Call MxShowError("sio_DTR", ret, GetLastError())
        Exit Function
    End If

    If GCommData.Hw = 0 Then
        ret = sio_RTS(Port, GCommData.Rts)
'MsgBox CStr(ret) + "," + CStr(SIO_OK) + "," + CStr(GCommData.Rts)
        If ret <> SIO_OK Then
            Call MxShowError("sio_RTS", ret, GetLastError())
            Exit Function
        End If
    End If
    
    tout = 1000 / sio_getbaud(GCommData.Port)  'ms /byte'
    If tout < 1 Then
        tout = 1
    End If
    tout = tout * 1 * 3             ' 1 byte; '*3' is for delay
    Call sio_SetWriteTimeouts(GCommData.Port, tout)

    Call ShowStatus
    PortSet = True
End Function

Public Sub ShowData(ByVal Term As Control, ByRef Dta() As Byte, ByVal rlen As Long)
Dim TermLen%
Dim i As Integer

    On Error Resume Next
    
    For i = 0 To rlen - 1
        ' Make sure the existing text doesn't get too large.
            TermLen = LenB(Term.Text)
        If TermLen >= 16384 Then
            Term.Text = Mid$(Term.Text, 4097)
            TermLen = LenB(Term.Text)
        End If

        ' Point to the end of Term's data.
        Term.SelStart = TermLen
        Term.SelLength = 0
        Term.SelText = "char ascii = " + Str(Dta(i)) + Chr(13) + Chr(10)
    Next i
        
       ' If rlen Then
       '    AgrBuf = Str(Dta(rlen - 1))
       '  End If
   
End Sub


Public Sub ShowStatus()
Dim szMessage As String

    szMessage = GszAppName
    
    If GbOpen Then
        szMessage = szMessage & " -- COM" & GCommData.Port & ","
        szMessage = szMessage & _
                GstrBaudTable(GCommData.ibaudrate) & ","
        szMessage = szMessage & _
                GstrParityTable(GCommData.iparity) & ","
        szMessage = szMessage & _
                GstrByteSizeTable(GCommData.ibytesize) & ","
        szMessage = szMessage & _
                GstrStopBitsTable(GCommData.istopbits)
        If GCommData.Hw = 1 Then
            szMessage = szMessage & ",RTS/CTS"
        End If

        If GCommData.Sw = 1 Then
           szMessage = szMessage & ",XON/XOFF"
        End If
    End If
    Caption = szMessage
End Sub


Public Sub LoadConfig()
Dim A%
On Error GoTo ErrLoad
    Open "C:\ProDoCad\ProMess\Plot\ComConfig.Stp" For Input Shared As #5
       
    With GCommData
       Input #5, .Port, .ibaudrate, .iparity, .ibytesize, .istopbits, A, A, A
       Input #5, A, .BaudRate, .Parity, .ByteSize, .StopBits, A, A, A
       Input #5, .Hw, .Sw, A, .Rts, .Dtr, A, .AddChk, A
    End With
    
    Close #5
 Exit Sub

ErrLoad:
    Close #5
End Sub


