-- https://github.com/mhvuze/MonsterHunterRiseModding/wiki/Weapon-IDs
sdk.hook(sdk.find_type_definition("snow.gui.fsm.smithy.GuiHyakuryuProcess"):get_method("setEquipBoxFilter"),
function(args)
	if sdk.to_int64(args[3]) == 262144 then
		sdk.to_managed_object(args[2]):call("setEquipBoxFilter", 16383)
		return sdk.PreHookResult.SKIP_ORIGINAL
	end
end,
function(retval)
	return retval
end
);

re.on_draw_ui(function()
	if imgui.button("[Layer Weapon by ID]") then
		LayerWeaponWindow = true
	end
	
    if LayerWeaponWindow then
        if imgui.begin_window("Layer Weapon by ID", true, 64) then
			local doWrite = false
			local EquipDataManager = sdk.get_managed_singleton("snow.data.EquipDataManager")
			local HeldWeapon = EquipDataManager:get_field("_PlEquipPack"):get_field("<InventoryDataList>k__BackingField")[0]
			local HeldWeaponData = nil
			local HeldWeaponType = nil
			local filterSlotsByType = true
			if HeldWeapon then
				if HeldWeapon:get_field("_IdType")==1 then
					HeldWeaponData = sdk.to_managed_object(HeldWeapon:call("getWeaponData"))
				end
			end
			
			if HeldWeaponData then
				HeldWeaponType = HeldWeaponData:call("getWeaponType")
				imgui.text("Equipped Weapon: "..HeldWeaponData:call("get_Name"))
				local currentLayer = HeldWeapon:call("get_HyakuryuModelId")
				if currentLayer==1048576 or currentLayer==HeldWeaponData:call("getModelId") then
					imgui.text("Layered: No; ID:"..HeldWeaponData:call("getModelId"))
				else
					imgui.text("Layered: Yes")
				end
			else
				imgui.text("Equipped Weapon: None or Unreadable")
			end
			imgui.text("Input Weapon Model ID:")
			_, input = imgui.input_text("", input)
			if imgui.button("Set Held Weapon to Model ID") then
				if HeldWeaponData and tonumber(input) then
					HeldWeapon:call("set_HyakuryuModelId", tonumber(input))
				end
			end
			if imgui.button("Reset Held Weapon Model ID") then
				if HeldWeaponData then
					HeldWeapon:call("set_HyakuryuModelId", 1048576)
				end
			end
			imgui.end_window()
        else
            LayerWeaponWindow = false
        end
	end
end)