log.info("[Layer Any Weapon] started loading")

local configPath = "Layer_Any_Weapon_Config.json"

local config = {
	savedWeaponLayers = {

	},
	filterSlotsByType = true
}

if json ~= nil then
    local file = json.load_file(configPath)
    if file ~= nil then
		config = file
    else
        json.dump_file(configPath, config)
    end
end

sdk.hook(sdk.find_type_definition("snow.gui.fsm.smithy.GuiHyakuryuProcess"):get_method("setEquipBoxFilter"),
function(args)
	if sdk.to_int64(args[3]) == 262144 then
		sdk.to_managed_object(args[2]):call("setEquipBoxFilter", 16383)
		return sdk.PreHookResult.SKIP_ORIGINAL
	end
end,
function(retval)
	return retval
end
);

re.on_draw_ui(function()
	if imgui.button("[Layer Any Weapon]") then
		drawLayerWeaponOptionsWindow = true
	end
	
    if drawLayerWeaponOptionsWindow then
        if imgui.begin_window("Layer Any Weapon", true, 64) then
			local doWrite = false
			local EquipDataManager = sdk.get_managed_singleton("snow.data.EquipDataManager")
			local HeldWeapon = EquipDataManager:get_field("_PlEquipPack"):get_field("<InventoryDataList>k__BackingField")[0]
			local HeldWeaponData = nil
			local HeldWeaponType = nil
			local filterSlotsByType = true
			if HeldWeapon then
				if HeldWeapon:get_field("_IdType")==1 then
					HeldWeaponData = sdk.to_managed_object(HeldWeapon:call("getWeaponData"))
				end
			end
			
			if HeldWeaponData then
				HeldWeaponType = HeldWeaponData:call("getWeaponType")
				imgui.text("Equipped Weapon: "..HeldWeaponData:call("get_Name"))
				local currentLayer = HeldWeapon:call("get_HyakuryuModelId")
				if currentLayer==1048576 or currentLayer==HeldWeaponData:call("getModelId") then
					imgui.text("Layered: No")
				else
					imgui.text("Layered: Yes")
				end
			else
				imgui.text("Equipped Weapon: None or Unreadable")
			end
			
			if imgui.button("Reset Held Weapon Model") then
				if HeldWeaponData then
					HeldWeapon:call("set_HyakuryuModelId", 1048576)
				end
			end
			imgui.same_line()
			imgui.text("The Smithy will recongnize that the weapon has no Layered data")
			if imgui.button("Save Held Weapon to Layer Slots") then
				if HeldWeaponData then
					local newLayer = {modelId = tostring(HeldWeaponData:call("getModelId")), name = HeldWeaponData:call("get_Name"), weaponType = tostring(HeldWeaponData:call("getWeaponType"))}
					if config.savedWeaponLayers then
						table.insert(config.savedWeaponLayers, newLayer)
					else
						config.savedWeaponLayers = {newLayer}
					end
					doWrite = true
				end
			end
			imgui.same_line()
			imgui.text("Saves the weapon's true form, not any applied Layer")
			imgui.new_line()
			imgui.text("Saved Weapon Layer Slots: Changes will be applied when model is next loaded")
			
			changed, value = imgui.checkbox('Filter by Weapon Type', config.filterSlotsByType)
			if changed then
				config.filterSlotsByType = value
				doWrite = true
			end
			
			if config.savedWeaponLayers then 
				for i,savedLayer in ipairs(config.savedWeaponLayers) do
					if (not config.filterSlotsByType or HeldWeaponType==tonumber(savedLayer.weaponType)) then
						if imgui.button("Apply to Weapon##Slot"..tostring(i)) then
							if HeldWeaponData then
								HeldWeapon:call("set_HyakuryuModelId", tonumber(savedLayer.modelId))
							end
						end
						imgui.same_line()
						if imgui.button("Clear Slot##Slot"..tostring(i)) then
							table.remove(config.savedWeaponLayers, i)
							doWrite = true
						end
						imgui.same_line()
						imgui.text("  Slot "..tostring(i).." - "..savedLayer.name)
					end
				end
			end
			
			if doWrite then
				json.dump_file(configPath, config)
			end
			imgui.end_window()
        else
            drawLayerWeaponOptionsWindow = false
        end
    end
end)
log.info("[Layer Any Weapon] finished loading")