require "prefabutil"

local function test_ground(inst, pt)
	local basetile = GROUND.DIRT  
	if GetWorld():HasTag("shipwrecked") then
		basetile = GROUND.BEACH 
	elseif GetWorld():HasTag("volcano") then
		basetile = GROUND.VOLCANO_ROCK 
	end
	local tiletype = GetGroundTypeAtPosition(pt)
	return tiletype == basetile or inst.data.tile == "webbing"
end

--------
local function setTileBlocking(block, pt)
	local ground = GetWorld()
	local px,py,pz = ground.Map:GetTileCenterPoint(pt.x, pt.y, pt.z)			
	for ix=0,1 do
		for iy =0,1 do
			local modx =-1
			local mody =-1
			if ix == 1 then
				modx = modx+2
			end
			if iy == 1 then
				mody = mody+2
			end		
			print("Altering tile",px+modx,pz+mody)			
			ground.Flooding:SetIsPositionBlocked(px+modx,0,pz+mody, block, false)
		end
	end
end

local function ondeploy(inst, pt, deployer)
	if deployer and deployer.SoundEmitter then
		deployer.SoundEmitter:PlaySound("dontstarve/wilson/dig")
	end

	local ground = GetWorld()
	if ground then
		local original_tile_type = ground.Map:GetTileAtPoint(pt.x, pt.y, pt.z)
		local x, y = ground.Map:GetTileCoordsAtPoint(pt.x, pt.y, pt.z)
		if x and y then
			ground.Map:SetTile(x,y, inst.data.tile)
			ground.Map:RebuildLayer( original_tile_type, x, y )
			ground.Map:RebuildLayer( inst.data.tile, x, y )
		end

		local minimap = TheSim:FindFirstEntityWithTag("minimap")
		if minimap then
			minimap.MiniMap:RebuildLayer( original_tile_type, x, y )
			minimap.MiniMap:RebuildLayer( inst.data.tile, x, y )
		end
		--setTileBlocking(true, pt)
	end

	inst.components.stackable:Get():Remove()
end
	
	local assets =
	{
		Asset("ANIM", "anim/manga_turf.zip"),
		Asset("ATLAS", "images/inventoryimages/turf_manga8.xml")
	}
	
	local prefabs =
	{
		"gridplacer",
	}
	local data = {name = "manga8", anim = "manga8", tile = GROUND.MANGA8}
	
	local function fn(Sim)
		local inst = CreateEntity()
		inst:AddTag("groundtile")
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		MakeInventoryPhysics(inst)
	    
		inst.AnimState:SetBank("manga_turf")  
		inst.AnimState:SetBuild("manga_turf")
		inst.AnimState:PlayAnimation(data.anim)
        
		if GetWorld():HasTag("shipwrecked") then
	        MakeInventoryFloatable(inst, data.anim.."_water", data.anim)
	        end
		--MakeInventoryFloatable(inst, data.anim.."_water", data.anim)

		inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM
		
		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/turf_manga8.xml"
		inst.data = data

		inst:AddComponent("bait")
    	        inst:AddTag("molebait")
	    
		inst:AddComponent("fuel")
		inst.components.fuel.fuelvalue = TUNING.MED_FUEL
		
		if GetWorld():HasTag("shipwrecked") then
		inst:AddComponent("appeasement")
    	        inst.components.appeasement.appeasementvalue = TUNING.WRATH_SMALL
                end

                MakeMediumBurnable(inst, TUNING.MED_BURNTIME)
		MakeSmallPropagator(inst)
		inst.components.burnable:MakeDragonflyBait(3)
		
	    inst:AddComponent("deployable")
	    --inst.components.deployable.test = function() return true end
	    inst.components.deployable.ondeploy = ondeploy
	    inst.components.deployable.test = test_ground
	    inst.components.deployable.min_spacing = 0
	    inst.components.deployable.placer = "gridplacer"
		
		inst:ListenForEvent("FloodModeChanged", function(it, data)
		GetWorld():PushEvent("floodblockercreated",{blocker = inst})
	    end, GetWorld())
	    
		---------------------  
		return inst      
end
return Prefab( "common/objects/turf_"..data.name, fn, assets, prefabs)
	


