﻿using System;
using System.Collections.Generic;
using RimWorld;
using Verse;
using Verse.AI;
using Harmony;
using System.Reflection;

namespace AnimalRangeAttack
{

	[StaticConstructorOnStartup]
	internal static class AnimalRangeAttack_Init
	{
		static AnimalRangeAttack_Init()
		{
			HarmonyInstance harmony = HarmonyInstance.Create("com.github.rimworld.mod.AnimalRangeAttack");
			harmony.PatchAll(Assembly.GetExecutingAssembly());
		}
	}

	[HarmonyPatch(typeof(JobGiver_Manhunter), "TryGiveJob")]
	public static class ARA__ManHunter_Patch
	{
		//Possible change to prefix. Bool can determine if original run or not.

		static bool Prefix(ref JobGiver_Manhunter __instance, ref Job __result, ref Pawn pawn)
		{
			//Log.Warning("Detected Animal Attack");

			bool hasRangedVerb = false;
			List<VerbProperties> verbs = pawn.VerbProperties;

			for (int i = 0; i < verbs.Count; i++)
			{
				if (verbs[i].range > 1.1f)
				{
					hasRangedVerb = true;
					//Log.Warning("Detected range verb");
					break;
				}
			}

			//If there is no ranged verb just return;
			if (hasRangedVerb == false)
				return true;

			//Log.Warning("Range verb detected");
			//Not preferable, as this is redundant but not like I can get method value
			Thing target = Traverse.Create(__instance).Method("FindPawnTarget", pawn).GetValue<Pawn>();

			/*
			Thing target = (Pawn)AttackTargetFinder.BestAttackTarget((IAttackTargetSearcher)pawn, TargetScanFlags.NeedThreat, (Predicate<Thing>)(x =>
			{
				if (x is Pawn)
					return x.def.race.intelligence >= Intelligence.ToolUser;
				return false;
			}), 0.0f, 9999f, new IntVec3(), float.MaxValue, true);
			*/


			if (target == null || !pawn.CanReach((LocalTargetInfo)((Thing)target), PathEndMode.Touch, Danger.Deadly, false, TraverseMode.ByPawn))
			{
				//Log.Warning("No pawn to shoot");
				//FindTurretTarget already search for reachable.
				//target = (Building)AttackTargetFinder.BestAttackTarget((IAttackTargetSearcher)pawn, TargetScanFlags.NeedLOSToAll | TargetScanFlags.NeedReachable | TargetScanFlags.NeedThreat, (Predicate<Thing>)(t => t is Building), 0.0f, 70f, new IntVec3(), float.MaxValue, false);
				target = Traverse.Create(__instance).Method("FindTurretTarget", pawn).GetValue<Building>();
			}


			if (target.Position.AdjacentTo8Way(pawn.Position) || target == null)
				return true;
			//Log.Warning("Got target");


			//Method doesn't seem all that welcome, lets do without method for now

			//Formally range attack job
			if (target != null && pawn.CanReach(target, PathEndMode.Touch, Danger.Deadly, false))
			{
				//Log.Warning("Trying to fire at pawn");

				List<Verb> verbList = pawn.verbTracker.AllVerbs;

				//Log.Warning("Got list of verb");

				List<Verb> rangedVerb = new List<Verb>();
				for (int i = 0; i < verbList.Count; i++)
				{
					//Log.Warning("Checkity");
					//It corresponds with verbs anyway
					if (verbList[i].verbProps.range > 1.1f)
					{
						rangedVerb.Add(verbList[i]);
					}
					//Log.Warning("Added Ranged Verb");
				}
				//Log.Warning("got list of ranged verb");

				Verb verb = rangedVerb.RandomElement();
				if (verb == null)
				{
					Log.Warning("Can't get random range verb");
					return true;
				}
				//Log.Warning("Ranged verb selected, range of  " + verb.verbProps.range);
				IntVec3 intVec;

				//At the moment it tries to find cast position, instead of trying to see if it can shoot enemy.
				//We don't want clever behaviour from animal, if can shoot target, shoot. If not go to position to shoot.

				//Log.Warning("Trying to shoot");
				//Searches for target within range.
				TargetScanFlags targetScanFlags = TargetScanFlags.NeedLOSToAll;
				Thing thing = (Thing)AttackTargetFinder.BestShootTargetFromCurrentPosition(pawn, null, verb.verbProps.range, 1, targetScanFlags);
				if (thing != null)
				{
					//Log.Warning("Trying initiate job");
					__result = new Job(DefDatabase<JobDef>.GetNamed("AnimalRangeAttack"), thing, JobGiver_AIFightEnemy.ExpiryInterval_ShooterSucceeded.RandomInRange, true)
					{
						verbToUse = verb
					};
					//Log.Warning("Succesfully created job");
				}
				else
				{
					//Can't shoot at target from current position. Find a new position

					bool canShootCondition = false;
					//Log.Warning("Try casting");
					canShootCondition = CastPositionFinder.TryFindCastPosition(new CastPositionRequest
					{
						caster = pawn,
						target = target,
						verb = verb,
						maxRangeFromTarget = verb.verbProps.range,
						wantCoverFromTarget = false
					}, out intVec);

					if (!canShootCondition)
					{
						//Log.Warning("Can't find place to shoot at target");
						return true;
					}
					//Log.Warning("Going");
					//Go to new destination
					__result = new Job(JobDefOf.Goto, intVec)
					{

						expiryInterval = JobGiver_AIFightEnemy.ExpiryInterval_ShooterSucceeded.RandomInRange,
						checkOverrideOnExpire = true
					};

				}
				return false;
			}
			return true;
		}
	}

	//Because of the way patching work, tamed animal are saviour and smarter at shooting than wild one
		[HarmonyPatch(typeof(JobGiver_AIDefendMaster),"TryGiveJob")]
		static class ARA_FightAI_Patch
		{
			static bool Prefix(ref JobGiver_AIFightEnemy __instance, ref Job __result, ref Pawn pawn)
			{
				//Log.Warning("Tame animal job detected");
				bool hasRangedVerb = false;
				List<VerbProperties> verbs = pawn.VerbProperties;

				for (int i = 0; i < verbs.Count; i++)
				{
					if (verbs[i].range > 1.1f)
					{
						hasRangedVerb = true;
						//Log.Warning("Detected range verb");
						break;
					}
				}

				List<Verb> verbList = pawn.verbTracker.AllVerbs;
				List<Verb> rangedVerb = new List<Verb>();
				for (int i = 0; i < verbList.Count; i++)
				{
					//Log.Warning("Checkity");
					//It corresponds with verbs anyway
					if (verbList[i].verbProps.range > 1.1f)
					{
						rangedVerb.Add(verbList[i]);
					}
					//Log.Warning("Added Ranged Verb");
				}

				if (hasRangedVerb == false)
				{
					//Log.Warning("I don't have range verb");
					return true;
				}

				Verb verb = rangedVerb.RandomElement();
				if (verb == null)
				{
					Log.Warning("Can't get random range verb");
					return true;
				}

				
				Thing enemyTarget = (Pawn)AttackTargetFinder.BestAttackTarget((IAttackTargetSearcher)pawn, TargetScanFlags.NeedThreat, (Predicate<Thing>)(x =>
                x is Pawn), 0.0f, Traverse.Create(__instance).Method("GetFlagRadius", pawn).GetValue<float>() + 5 + verb.verbProps.range, new IntVec3(), float.MaxValue, true);



				if (enemyTarget == null || !pawn.CanReach((LocalTargetInfo)((Thing)enemyTarget), PathEndMode.Touch, Danger.Deadly, false, TraverseMode.ByPawn))
				{
					//Log.Warning("No pawn to shoot");
					//FindTurretTarget already search for reachable.
					enemyTarget = (Building)AttackTargetFinder.BestAttackTarget((IAttackTargetSearcher)pawn, TargetScanFlags.NeedLOSToAll | TargetScanFlags.NeedReachable | TargetScanFlags.NeedThreat, (Predicate<Thing>)(t => t is Building), 0.0f, 70f, new IntVec3(), float.MaxValue, false);
					//target = Traverse.Create(__instance).Method("FindTurretTarget", pawn).GetValue<Building>();
				}

				if (enemyTarget == null || !pawn.CanReach(enemyTarget, PathEndMode.Touch, Danger.Deadly, false))
				{
					//Log.Warning("I can't find anything to fight.");
					return true;
				}
				/*
				Traverse.Create(__instance).Method("UpdateEnemyTarget", pawn);
				Log.Warning("Enemy target updated");
				//__instance.UpdateEnemyTarget(pawn);
				Thing enemyTarget = pawn.mindState.enemyTarget;
				if (enemyTarget == null)
				{
					Log.Warning("I can't find anything to fight");
					__result = (Job)null;
					return false;
				}
				*/

				if (enemyTarget.Position.AdjacentTo8Way(pawn.Position))
				{
					__result = new Job(JobDefOf.AttackMelee, (LocalTargetInfo)enemyTarget)
					{
						maxNumMeleeAttacks = 1,
						expiryInterval = Rand.Range(420, 900),
						attackDoorIfTargetLost = false
					};
					return false;
				}
				
				//Log.Warning("got list of ranged verb");

				//Log.Warning("Attempting flag");
				bool flag1 = (double)CoverUtility.CalculateOverallBlockChance(pawn.Position, enemyTarget.Position, pawn.Map) > 0.00999999977648258;
				bool flag2 = pawn.Position.Standable(pawn.Map);
				bool flag3 = verb.CanHitTarget((LocalTargetInfo)enemyTarget);
				bool flag4 = (pawn.Position - enemyTarget.Position).LengthHorizontalSquared < 25;
				if (flag1 && flag2 && flag3 || flag4 && flag3)
				{
					//Log.Warning("Time to shoot");
					TargetScanFlags targetScanFlags = TargetScanFlags.NeedLOSToAll;
					Thing thing = (Thing)AttackTargetFinder.BestShootTargetFromCurrentPosition(pawn, null, verb.verbProps.range, 1, targetScanFlags);
					if (thing != null)
					{
						//Log.Warning("Trying initiate job");
						__result = new Job(DefDatabase<JobDef>.GetNamed("AnimalRangeAttack"), thing, JobGiver_AIFightEnemy.ExpiryInterval_ShooterSucceeded.RandomInRange, true)
						{
							verbToUse = verb
						};
						return false;
						//Log.Warning("Succesfully created job");
					}
					__result = new Job(DefDatabase<JobDef>.GetNamed("AnimalRangeAttack"), enemyTarget, JobGiver_AIFightEnemy.ExpiryInterval_ShooterSucceeded.RandomInRange, true);
					return false;
				}
				IntVec3 dest;
				bool canShootCondition = false;
			//Log.Warning("Try casting");

			//Animals with training seek cover
			/*
				if (pawn.training.IsCompleted(TrainableDefOf.Release) && (double)verb.verbProps.range > 7.0)
					Log.Warning("Attempting cover");
				Log.Warning("Try get flag radius :" + Traverse.Create(__instance).Method("GetFlagRadius", pawn).GetValue<float>());
				Log.Warning("Checking cast condition");
				*/
				canShootCondition = CastPositionFinder.TryFindCastPosition(new CastPositionRequest
				{
					caster = pawn,
					target = enemyTarget,
					verb = verb,
					maxRangeFromTarget = 9999,
					wantCoverFromTarget = pawn.training.IsCompleted(TrainableDefOf.Release) && (double)verb.verbProps.range > 7.0,
				}, out dest);

				if (!canShootCondition)
				{
					Log.Warning("I can't shoot target");
					return true;
				}
				
				if (dest == pawn.Position)
				{
					Log.Warning("I will stay here and attack");
					__result = new Job(DefDatabase<JobDef>.GetNamed("AnimalRangeAttack"), enemyTarget, JobGiver_AIFightEnemy.ExpiryInterval_ShooterSucceeded.RandomInRange, true);
					return false;
				}
				//Log.Warning("Going to new place");
				__result =  new Job(JobDefOf.Goto, (LocalTargetInfo)dest)
				{
					expiryInterval = JobGiver_AIFightEnemy.ExpiryInterval_ShooterSucceeded.RandomInRange,
					checkOverrideOnExpire = true
				};
				return false;
				}

		}
	

}