// 此函数确认是否有页面控制器，有则直接加载，无则注入数据
function page_reset() {
    var ccc = localStorage.getItem("page_control");
    if (ccc != null) {
        console.log("HistoryPage!")
    } else {
        localStorage.setItem("page_control", "0");

        let page_list = [
            {
                name: "搜索",
                onoff: true
            },
            {
                name: "书签",
                onoff: true
            }
            // ,
            // {
            //     name: "导航",
            //     onoff: false
            // }
        ]
        let page_list_json = JSON.stringify(page_list)
        localStorage.setItem("page_list", page_list_json);
    }

}
// 执行此函数
page_reset();

let page_list = JSON.parse(localStorage.getItem("page_list"))
// console.log(page_list)
let page_control = localStorage.getItem("page_control");


// 获得页面的数量
function num_get() {
    let a = 0
    let arr = page_list
    for (let i = 0; i < arr.length; i++) {
        if (arr[i].onoff) {
            a++
        }
    }
    return a
}
let num = num_get()
console.log("num=" + num)

// 到此时页面数据初始化完成

// 此函数确认是否有搜索控制器，有则直接加载，无则注入数据
function control_reset() {
    var ccc = localStorage.getItem("search_control");
    if (ccc != null) {
        console.log("HistorySearch!")
    } else {
        localStorage.setItem("search_control", "0");

        let search_list = [
            {
                "search-lei": "百度",
                "search-dizhi": "https://www.baidu.com/s?wd=",
                "search-yanse": "4E6EF2",
            },
            {
                "search-lei": "Google",
                "search-dizhi": "https://www.google.com/search?q=",
                "search-yanse": "ea4335",
            },
            {
                "search-lei": "bilibili",
                "search-dizhi": "https://search.bilibili.com/all?keyword=",
                "search-yanse": "F08198",
            }
        ]
        let search_list_json = JSON.stringify(search_list)
        localStorage.setItem("search_list", search_list_json);

        localStorage.setItem("face_control", "1");
    }

}
// 执行此函数
control_reset();

let search_engine = JSON.parse(localStorage.getItem("search_list"))
console.log(search_engine)
let search_control = localStorage.getItem("search_control");

// 到此时搜索数据初始化完成




// 此函数可以将变更后的搜索数据上传到localStorage
function upload_search_list() {
    let search_list_json = JSON.stringify(search_engine)
    localStorage.setItem("search_list", search_list_json);
}
function upload_search_control() {
    localStorage.setItem("search_control", String(search_control));
}




// 此函数上传页面控制器
function upload_page_control() {
    localStorage.setItem("page_control", String(page_control));
}
// 此函数上传页面列表数据
function upload_page_list() {
    let page_list_json = JSON.stringify(page_list)
    localStorage.setItem("page_list", page_list_json);
}


// 根据page_list数组生成页面开关
function create_page_switch() {
    let a = page_list
    for (let i = 0; i < a.length; i++) {
        let div_slider = document.createElement('div');
        let div = document.createElement('div');
        let div0 = document.createElement('div');
        let div00 = document.createElement('div');
        let input = document.createElement('input');
        let label = document.createElement('label');

        div.innerText = a[i].name

        input.setAttribute("type", "checkbox");
        input.className = "page-switch-btn-" + i + " " + "page-switch"
        input.checked = a[i].onoff;
        input.onclick = function () {
            let arr_switch = document.querySelectorAll(".page-switch")
            let bool_switch = false
            for (let j = 0; j < arr_switch.length; j++) {
                bool_switch = (bool_switch || arr_switch[j].checked)
            }
            if (!bool_switch) {
                arr_switch[0].checked = true
                page_list[0].onoff = true
            }

            // console.log(this.checked)
            page_list[i].onoff = this.checked
            upload_page_list()
            page_control = "0"
            upload_page_control()
            num = num_get()

            let arr_main = document.querySelectorAll('.main-content')
            for (let x = 0; x < arr_main.length; x++) {
                document.querySelector('.main').removeChild(arr_main[x])
            }
            let arr_sidemenu = document.querySelectorAll('.header-sidemenu-btn')
            for (let x = 0; x < arr_sidemenu.length; x++) {
                document.querySelector('.header-sidemenu').removeChild(arr_sidemenu[x])
            }

            create_page()

            page_change_btn()
            page_display()
            // let arr_main = document.querySelectorAll('.main-content')
            // document.querySelector('.main').removeChild(arr_main[i])
            // e.removeChild(childs[i]);

            if (document.querySelector('.search-content')) {
                document.querySelector('#search_setting').style.display = ""
                document.querySelector('#search_setting').previousElementSibling.style.display = ""
            } else {
                document.querySelector('#search_setting').style.display = "none"
                document.querySelector('#search_setting').previousElementSibling.style.display = "none"
            }
        }

        console.log(input.checked)

        div_slider.className = "slider"
        label.append(input)
        label.append(div_slider)
        label.className = "switch"

        div00.className = "page-switch-item"
        div00.append(div)
        div00.append(label)
        div0.append(div00)

        document.querySelector("#page-on-off").append(div0)
    }

}
create_page_switch()


// 根据page_list数组生成页面模板
function create_page() {
    let arr = page_list

    for (let i = 0; i < arr.length; i++) {
        if (arr[i].onoff) {
            let temside = document.querySelector("#tem-side-" + i)
            let tempage = document.querySelector("#tem-page-" + i)

            document.querySelector(".header-sidemenu").append(temside.content.cloneNode(true))
            document.querySelector(".main").append(tempage.content.cloneNode(true))
            let tempage_js = document.querySelector("#tem-page-js-" + i)
            document.querySelector(".main-content-" + i).after(tempage_js.content.cloneNode(true))
        }
    }
}
create_page()



// 根据数据初始化页面
function page_display() {
    let n = Number(page_control)
    change_page(n)
}
page_display()

// 此函数根据search_engine数组将所有数据写入到设置表单并初始化搜索框内提示
function html_reset() {
    let arr = search_engine
    let x = arr.length
    let n = search_control

    // 设置页内容的填充
    let div = document.createElement('div')
    div.className = "setting-title"
    div.innerText = "搜索引擎"
    document.querySelector("#search_setting").before(div)
    for (let i = 0; i < x; i++) {

        let temsearch = document.querySelector('#tem-search-setting')
        document.querySelector("#search_setting").append(temsearch.content.cloneNode(true))
    }
    let a1 = document.querySelectorAll('.search-form')
    for (let i = 0; i < a1.length; i++) {
        a1[i].name = "s" + i
        a1[i].id = "s" + i
        a1[i].ssm.value = arr[i]["search-lei"]
        a1[i].qqd.value = arr[i]["search-dizhi"]
        a1[i].ssc.value = arr[i]["search-yanse"]
    }
    let a2 = document.querySelectorAll('.ssm-get')
    for (let i = 0; i < a2.length; i++) {
        a2[i].id = "ssm-get" + i
        a2[i].innerText = arr[i]["search-lei"]
    }
    let a3 = document.querySelectorAll('.big-keshihua')
    for (let i = 0; i < a3.length; i++) {
        a3[i].id = "big-glass-" + i
        a3[i].style.background = "#" + arr[i]["search-yanse"]
    }
    var b = arr[n]["search-lei"]
    console.log(b);
    if (document.querySelector('#search-input')) {
        document.querySelector('#search-input').placeholder = (b + "   tab键切换搜索类型");
    }

}
html_reset()

// 此函数控制页面显示并更新page_control到local
function change_page(number) {
    page_control = number
    let page_arr = document.querySelectorAll('.main-content')
    for (let i = 0; i < page_arr.length; i++) {
        page_arr[i].style.display = "none";
    }
    // if (page_arr[number]) {
    //     page_arr[number].style.display = "";


    //     if (page_arr[number].className.indexOf('search-content') > -1) {
    //         document.getElementById("search-input").focus();
    //     } else if (page_arr[number].className.indexOf('bookmark-content') > -1) {
    //         document.getElementById("bookmark-search-input").focus();
    //     }
    // }
    page_arr[number].style.display = "";


    // 根据不同页面不同聚焦
    if (page_arr[number].className.indexOf('search-content') > -1) {
        document.getElementById("search-input").focus();
    } else if (page_arr[number].className.indexOf('bookmark-content') > -1) {
        document.getElementById("bookmark-search-input").focus();
    }

    upload_page_control()
    page_color_reset()
}

// 点击页面空白处执行页面切换函数
document.querySelector(".main").onclick = (function (event) {
    if (event.target == this) {
        main_content_change()
    }
});
function main_content_change() {
    let main_num = num
    var id = page_control;
    var next_id = (Number(id) + 1) % main_num;
    page_control = next_id;

    change_page(next_id)
}

// 页头按钮的点击操作
function page_change_btn() {
    let arr = document.querySelectorAll('.header-sidemenu-btn')
    for (let i = 0; i < arr.length; i++) {
        arr[i].onclick = function () { change_page(i) }
    }
}
page_change_btn()

//杂函数 节点的显示与隐藏
function display(ele) {
    if (ele.style.display != "none") {
        ele.style.display = "none"
    } else {
        ele.style.display = ""
    }
}

//杂函数 设置页的打开和关闭
document.querySelector(".btn-setting").onclick = function () {
    let a = document.querySelector(".setting-page")
    display(a)
}
document.querySelector(".icon-close").onclick = function () {
    let a = document.querySelector(".setting-page")
    display(a)
}

// 杂函数 反馈页面的跳转
document.querySelector(".btn-fankui").onclick = function () {
    window.open('https://support.qq.com/product/275877')
}

// 杂函数 反馈页面的跳转
document.querySelector(".url-pay").onclick = function () {
    window.open('https://www.goto-mars.com/static/dotted-key.html')
}

// 杂函数 页面按钮的颜色变更
function page_color_reset() {
    let n = page_control
    let arr = document.querySelectorAll('.header-sidemenu-btn')
    for (let i = 0; i < arr.length; i++) {
        arr[i].style.color = "#555555";
    }
    arr[n].style.color = "#000000";
}

// 杂 高级账户的设置页展开
document.querySelector('.pro-more').onclick = function () {
    this.style.display = "none"
    document.querySelector('.pro-content').style.display = "";
}

// 杂 高级账户的激活按钮
document.querySelector('.btn-jihuo').onclick = function () {
    let useremail = document.querySelector('.useremail').value.replace(/(^\s*)|(\s*$)/g, "")
    let userkey = document.querySelector('.userkey').value.replace(/(^\s*)|(\s*$)/g, "")
    // console.log(useremail) //844561094@qq.com
    // console.log(userkey)   // TGou58xv9ofCIkwZk/kjGYl/HRaSfw2MKDVZLZiWLqA=
    if (useremail != "") {
        let aseKey = "01234567"
        let key1 = CryptoJS.AES.decrypt(userkey, CryptoJS.enc.Utf8.parse(aseKey), {
            mode: CryptoJS.mode.ECB,
            padding: CryptoJS.pad.Pkcs7
        }).toString(CryptoJS.enc.Utf8);
        console.log(key1)
        if (key1 == useremail) {
            console.log("激活成功" + key1)
            localStorage.setItem("keyurl", "https://www.goto-mars.com/key=2");
            document.querySelector('.pro-more').style.display = "";
            document.querySelector('.pro-content').style.display = "none";
            pro_reset()

        } else {
            document.querySelector('.alret-false>div').innerText = "*激活失败，请检查邮箱及激活码是否有拼写错误*"
            document.querySelector('.alret-false').style.display = "";
        }
    } else {
        document.querySelector('.alret-false>div').innerText = "*激活失败，邮箱和验证码不能为空*"
        document.querySelector('.alret-false').style.display = "";
    }


    // document.querySelector('.pro-more').style.display = "";
    // document.querySelector('.pro-content').style.display = "none";
}

// 杂 高级账户的取消按钮
document.querySelector('.btn-chexiao').onclick = function () {
    document.querySelector('.alret-false').style.display = "none";
    document.querySelector('.pro-more').style.display = "";
    document.querySelector('.pro-content').style.display = "none";
}

// 此函数判定是否是会员用户
function pro_reset() {
    let pro = localStorage.getItem("keyurl");
    if (pro != null) {
        console.log(pro)
        if (pro == "https://www.goto-mars.com/key=2") {
            let arr = document.querySelectorAll('.def')
            for (let i = 0; i < arr.length; i++) {
                arr[i].style.display = "block";
            }

            document.querySelector('.pro-text').innerText = "您已经是高级账户啦！"
            document.querySelector('.pro-more').style.display = "none"


        } else {
            let arr = document.querySelectorAll('.def')
            let i = arr.length - 1
            arr[i].style.display = "block";

        }

    } else {
        localStorage.setItem("keyurl", "https://www.goto-mars.com/key=1");
        let arr = document.querySelectorAll('.def')
        let i = arr.length - 1
        arr[i].style.display = "block";
    }

}
pro_reset()