"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNativeBinding = exports.GeckoDownloadPriority = exports.GeckoLogLevel = exports.GeckoEnv = void 0;
var GeckoEnv;
(function (GeckoEnv) {
    GeckoEnv[GeckoEnv["Test"] = 1] = "Test";
    GeckoEnv[GeckoEnv["Online"] = 2] = "Online";
})(GeckoEnv = exports.GeckoEnv || (exports.GeckoEnv = {}));
var GeckoLogLevel;
(function (GeckoLogLevel) {
    GeckoLogLevel[GeckoLogLevel["Debug"] = 0] = "Debug";
    GeckoLogLevel[GeckoLogLevel["Info"] = 1] = "Info";
    GeckoLogLevel[GeckoLogLevel["Warnning"] = 2] = "Warnning";
    GeckoLogLevel[GeckoLogLevel["Error"] = 3] = "Error";
})(GeckoLogLevel = exports.GeckoLogLevel || (exports.GeckoLogLevel = {}));
var GeckoDownloadPriority;
(function (GeckoDownloadPriority) {
    GeckoDownloadPriority[GeckoDownloadPriority["Low"] = 0] = "Low";
    GeckoDownloadPriority[GeckoDownloadPriority["Medium"] = 1] = "Medium";
    GeckoDownloadPriority[GeckoDownloadPriority["High"] = 2] = "High";
    GeckoDownloadPriority[GeckoDownloadPriority["UseInteraction"] = 3] = "UseInteraction";
})(GeckoDownloadPriority = exports.GeckoDownloadPriority || (exports.GeckoDownloadPriority = {}));
var _a = require('fs'), existsSync = _a.existsSync, readFileSync = _a.readFileSync;
var join = require('path').join;
var platform = process.platform, arch = process.arch;
var nativeBinding = null;
var loadError = null;
var localFileExisted = null;
var libFileName = "gecko.node";
/**
 * 获取 gecko c++ binding
 */
var getNativeBinding = function () {
    switch (platform) {
        case 'win32':
            switch (arch) {
                case 'x64':
                    localFileExisted = existsSync(join(__dirname, 'out/windows_x64', libFileName));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require("./out/windows_x64/".concat(libFileName));
                        }
                        else {
                            nativeBinding = require("../windows_x64/".concat(libFileName));
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                    break;
                case 'ia32':
                    localFileExisted = existsSync(join(__dirname, 'out/windows_x86', libFileName));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require("./out/windows_x86/".concat(libFileName));
                        }
                        else {
                            nativeBinding = require("../windows_x86/".concat(libFileName));
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                    break;
                default:
                    throw new Error("Unsupported architecture on Windows: ".concat(arch));
            }
            break;
        case 'darwin':
            switch (arch) {
                case 'x64':
                    localFileExisted = existsSync(join(__dirname, 'out/macos_x86_64', libFileName));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require("./out/macos_x86_64/".concat(libFileName));
                        }
                        else {
                            nativeBinding = require("../macos_x86_64/".concat(libFileName));
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                    break;
                case 'arm64':
                    localFileExisted = existsSync(join(__dirname, 'out/macos_arm64', libFileName));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require("./out/macos_arm64/".concat(libFileName));
                        }
                        else {
                            nativeBinding = require("../macos_arm64/".concat(libFileName));
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                    break;
                default:
                    throw new Error("Unsupported architecture on macOS: ".concat(arch));
            }
            break;
        default:
            throw new Error("Unsupported OS: ".concat(platform, ", architecture: ").concat(arch));
    }
    if (!nativeBinding) {
        if (loadError) {
            throw loadError;
        }
        throw new Error("Failed to load native binding");
    }
    nativeBinding.GeckoClient.getVersionLoader = function (accesskey, channel) {
        var loader = new nativeBinding.GeckoVersionLoader();
        if (loader.init(accesskey, channel)) {
            return loader;
        }
        else {
            return null;
        }
    };
    return nativeBinding;
};
exports.getNativeBinding = getNativeBinding;
