
function createContainer(id){
    var chartcontainer = document.createElement('div');
    chartcontainer.id = id

    var superContainer = document.getElementById('chart_area')
    if(superContainer === null || superContainer === undefined){
        superContainer = document.createElement('div')
        superContainer.id = 'chart_area'
        document.getElementById('memory-monitor').appendChild(superContainer)
    }

    var title = document.createElement('div')
    title.style = 'text-align:center;font-size:large;'
    title.innerHTML = '<b>'+id+'</b>'

    subcontainer = document.createElement('div')
    subcontainer.style = 'border-width: 2px;  border-style: solid; border-color: gray; margin: 5px;margin-top:20px;border-radius:10px;'


    subcontainer.appendChild(title)
    subcontainer.appendChild(chartcontainer)

    superContainer.appendChild(subcontainer)
}

var chartsContainer = []

function addMemoryInfoChart(name,keys){
    createContainer(name)

    var chart = new G2.Chart({
        id : name,
        forceFit: true,
        height: window.innerHeight/2
    });

    data = []

    chart.source(data, {
        time: {
            alias: '时间',
            type: 'time',
            mask: 'YYYY-MM-DD hh:mm:ss',
            tickCount: 10,
            nice: false
        },
        value: {
            alias: '个数'
        },
        type: {
            type: 'cat'
        }
    });
    chart.line().position('time*value').color('type').shape('smooth').size(2);
    chart.render();
    
    chartsContainer.push({
        name:name,
        keys:keys,
        data:data,
        chart:chart
    })
}

function updateMemoryChart(info){
    updateData = (info, leak_chart, leak_data, keys) => {
        var now = new Date();
        var time = now.getTime();
        if (leak_data.length >= 200) {
            leak_data.shift();
            leak_data.shift();
        }
    
        for (let key_index in keys) {
            leak_data.push({
                time: time,
                value: info[keys[key_index]],
                type: keys[key_index]
            });
        }
    
        leak_chart.changeData(leak_data);
    }

    for(i in chartsContainer){
        let chart = chartsContainer[i]
        updateData(JSON.parse(info),chart.chart,chart.data,chart.keys)
    }
}

var startRecord = ()=>{
    if(chartsContainer === null || chartsContainer === undefined || chartsContainer.length === 0){
        
        addMemoryInfoChart('leak',[
            'leak_blink_node_e',
            'leak_blink_js_event_listener_e',
            'leak_blink_array_buffer_contents_e',
            'player_video_tag_cnt',
            'player_count',
        ])
        addMemoryInfoChart('memory',[
            'render_blink_gc_mb',
            'render_v8_usage_mb',
            'render_partition_alloc_mb',
            'dm_allocated_size_mb',
            'render_private_footprint_mb'
        ])
    }
    if(this.record === null || this.record === undefined){
        console.log("startRecord")
        this.record = setInterval(()=>{
            chrome.devtools.inspectedWindow.eval(
                "ttwebview.getPerformanceData()",
                function(result, isException) {
                    updateMemoryChart(result)
                }
            );
        },1000)        
    }
}

var stopRecord = ()=>{
    console.log("stopRecord")
    clearInterval(this.record)
    this.record = null
}

var clearRecord = ()=>{
    for(i in chartsContainer){
        chartsContainer[i].data = []
    }
    updateMemoryChart('{}')
}

var startLeak = ()=>{
    console.log('startLeak')
    chrome.devtools.inspectedWindow.eval(
        `window.leak = setInterval(() => {
            var e = new KeyboardEvent('keydown',{'keyCode':83,'which':83});
            document.dispatchEvent(e);
        }, 5000)`,
        function(result, isException) {
            console.log(result)
        }
      );
    // 这个可以让视频自动往下刷

  }
  
stopLeak = ()=>{
    console.log("stopLeak")
    chrome.devtools.inspectedWindow.eval(
        `clearInterval(window.leak)`,
        function(result, isException) {
            console.log(result)
        }
      );
}

function addEventButton(name, event){
    let buttton_area = document.getElementById("button_area");
    var new_button = document.createElement('button');
    new_button.style = 'background-color:#e6feed;border-radius:5px;z-index:100;'
    // new_button.className = "vc-switch" 
    // style="right: 0px; bottom: 20px; display: block;
    new_button.innerHTML = name
    new_button.addEventListener('click',event)
    buttton_area.appendChild(new_button)
}

function getAllGetKeys(){
    chrome.devtools.inspectedWindow.eval(
        "ttwebview.getPerformanceData()",
        function(info, isException) {
            window.info_keys = []
            for(let key in JSON.parse(info)){
                window.info_keys.push(key)
            }
            createForm()
        }
    );
}

addEventButton('startRecord',startRecord)
addEventButton('stopRecord',stopRecord)
addEventButton('clearRecord',clearRecord)
addEventButton('startLeak',startLeak)
addEventButton('stopLeak',stopLeak)
addEventButton('reload devtools',()=>{location.reload()})
addEventButton('reload page',()=>{
    chrome.devtools.inspectedWindow.eval(
        `location.reload()`,
        function(result, isException) {}
      );
})

function createNavigateBar(){
    let form = document.createElement('form')

    form.style = 'margin:5px;'

    form.innerHTML = `<input id = 'navigator_id' type="text" name="url" style='width:300px'>`

    chrome.devtools.inspectedWindow.eval(
        "location.href",
        function(url, isException) {
            document.getElementById('navigator_id').value = url
        }
    );

    var button = document.createElement('button')
    button.type = 'submit'
    button.textContent = "跳转网页"
    button.onclick = ()=>{
        console.log("navigate to "+document.getElementById('navigator_id').value)
        chrome.devtools.inspectedWindow.eval(
            'location.href = '+"'"+document.getElementById('navigator_id').value+"'",
            function(result, isException) {
                console.log(isException)
            }
          );
        return false
    }
    form.appendChild(button)
    document.getElementById('common-tools').appendChild(form)
}

createNavigateBar()

// start default
startRecord()
getAllGetKeys()


window.chart_id = 0

function createForm(){
    console.log('createFrom')
    if(document.getElementById('input_form_id')!==null){
        document.getElementById('memory-monitor').removeChild(document.getElementById('input_form_id'))
    }
    form = document.createElement('form');
    form.id = 'input_form_id'
    form.style = 'background-color : lightgray;display: flex; flex-wrap:wrap; '
    document.getElementById('memory-monitor').appendChild(form)


    addFormItem = (item_name)=>{
        let div = document.createElement('div');
        div.style = 'width:250px;'
        
        var checkbox = document.createElement('input');
        checkbox.type = 'checkbox'
        checkbox.value = item_name
        checkbox.className = 'memory_info_class'
        div.appendChild(checkbox)
        div.append(item_name)
        // div.appendChild(document.createElement('br'))
        
        form.appendChild(div)

    }

    function submitAndAddChart(){
        checkboxes = document.getElementsByClassName('memory_info_class')
        let keys = []
        for(let i in checkboxes){
            if(checkboxes[i].checked){
                keys.push(checkboxes[i].value)
            }
        }
        console.log(keys)
        addMemoryInfoChart('anonymous_chart_'+window.chart_id.toString(),keys)
        window.chart_id += 1
        createForm()
    }

    addSubmitButton = ()=>{
        var button = document.createElement('button')
        button.type = 'submit'
        button.textContent = "创建新图表"
        button.onclick = submitAndAddChart
        button.style = 'background-color:#e6feed;border-radius:5px;z-index:100;'
        form.appendChild(button)
    }

    for(let i in window.info_keys){
        addFormItem(window.info_keys[i])
    }

    addSubmitButton()
}


