require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/wander"
require "behaviours/doaction"
require "behaviours/avoidlight"
require "behaviours/panic"

local MAX_CHASE_TIME = 30
local MAX_WANDER_DIST = 50

local ToadStoolBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function ToadStoolBrain:OnStart()
    local root = PriorityNode(
    {
		ChaseAndAttack(self.inst, MAX_CHASE_TIME),
		Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST) 
    }, .25)
    
    self.bt = BT(self.inst, root)
end

return ToadStoolBrain
