local function ToadStoolSoundDistant(boss)
	local sound = CreateEntity()
    sound.entity:AddTransform()
    sound.entity:AddSoundEmitter()
    sound.persists = false
	local theta = math.random() * 2 * PI
	local radius = 5
	local offset = Vector3(GetPlayer().Transform:GetWorldPosition()) +  Vector3(radius * math.cos( theta ), 0, -radius * math.sin( theta ))
	sound.Transform:SetPosition(offset.x,offset.y,offset.z)
	local snd = math.random(1,2)
	sound.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_phase_transition_roar_v2_" .. snd)
	sound:DoTaskInTime(1.5, function() sound:Remove() end)
end	

local MOB_DELAY = TUNING.TOADSTOOL_SPAWN_DELAY
local MOB_DELAY_RANDOM = 360

local FrogBoss = Class(function(self, inst)
	self.inst = inst
	self.inst:StartUpdatingComponent(self)
	self.mobspawndelay = MOB_DELAY + math.random(0,MOB_DELAY_RANDOM)
	self.randommob = nil
end)

function FrogBoss:OnSave()
	if not self.noserial then
		return 
		{
			mobspawndelay = self.mobspawndelay,
		}
	end
	self.noserial = false
end

function FrogBoss:OnLoad(data)
	self.mobspawndelay = data.mobspawndelay or MOB_DELAY + math.random(0,MOB_DELAY_RANDOM)
end

function FrogBoss:OnUpdate()
	self.mobspawndelay = self.mobspawndelay - 1
	if self.mobspawndelay == 0 then
		local sound = CreateEntity()
		sound.entity:AddTransform()
		sound.entity:AddSoundEmitter()
		sound.persists = false
		local sm = GetSeasonManager()
		local pt = Vector3(GetPlayer().Transform:GetWorldPosition())
		local spawn_pt = self:GetFloorSpawnPoint()
		if spawn_pt then
			local pos = Vector3(GetPlayer().Transform:GetWorldPosition())
			local ground = GetWorld()  
			local tile = ground.Map:GetTileAtPoint(pos.x, pos.y, pos.z)
			local chance = math.random(1,3)
			local new_spawn_pt = self:GetFloorSpawnPoint()
			if new_spawn_pt then
				self.randommob = SpawnPrefab("toadstool_cap")
				ToadStoolSoundDistant()
				GetPlayer().components.talker:Say("Hmm... What was that?")
				self.randommob.Physics:Teleport(new_spawn_pt:Get())
				self.mobspawndelay = MOB_DELAY + math.random(0,MOB_DELAY_RANDOM)
				print("Frog Boss succes!")
			else
				print("Frog Boss failed!")
				self.mobspawndelay = 5
			end
		else
			print("Shadow Pieces failed!")
			self.mobspawndelay = 5	
		end
	end
end

function FrogBoss:GetSpawnPoint(pt)
    local theta = math.random() * 2 * PI
    local radius = math.random(60,180)
	local offset = FindWalkableOffset(pt, theta, radius, 12, true)
	if offset then
		return pt+offset
	end
end

function FrogBoss:GetFloorSpawnPoint()
	local pt = Vector3(GetPlayer().Transform:GetWorldPosition())	
	local spawn_pt = self:GetSpawnPoint(pt)
	if spawn_pt then	
		return spawn_pt
	end
end

return FrogBoss