local assets =
{
    Asset("ANIM", "anim/toadstool_basic.zip"),
    Asset("ANIM", "anim/toadstool_actions.zip"),
    Asset("ANIM", "anim/toadstool_build.zip"),
    Asset("ANIM", "anim/toadstool_upg_build.zip"),
}

local prefabs = 
{
	"froglegs",
	"meat",
	"red_cap",
	"blue_cap",
	"green_cap",
	"shroom_skin",
}

SetSharedLootTable('toadstool',
{
    {"froglegs",      1.00},
    {"meat",          1.00},
    {"meat",          1.00},
    {"meat",          1.00},
    {"meat",          0.50},
    {"meat",          0.25},
	
	{"shroom_skin",      1.00},
	{"shroom_skin",      1.00},
	{"shroom_skin",      0.75},
	{"shroom_skin",      0.50},
	{"shroom_skin",      0.25},
	
    {"red_cap",       1.00},
    {"red_cap",       0.33},
    {"red_cap",       0.33},
	
    {"blue_cap",      1.00},
    {"blue_cap",      0.33},
    {"blue_cap",      0.33},
	
    {"green_cap",     1.00},
    {"green_cap",     0.33},
    {"green_cap",     0.33},
})

local function RetargetFn(inst)
	return FindEntity(inst, 10, 
		function(tar) return inst.components.combat:CanTarget(tar) end, nil, 
		{"prey", "bird", "butterfly", "aquatic", "toadstool", "rabbit"})
end

local function KeepTarget(inst, target)
    local shouldkeep = inst.components.combat:CanTarget(target)
    local onwater = target:HasTag("aquatic")
    return shouldkeep and not onwater
end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 30, function(dude)
        return dude:HasTag("toadstool")
               and not dude.components.health:IsDead()
    end, 10)
end

local function CalcSanityAura(inst, observer)	
	if inst.components.combat.target then
		return -TUNING.SANITYAURA_HUGE
	else
		return -TUNING.SANITYAURA_LARGE
	end	
	return 0
end

local function oncollide(inst, other)
    local v1 = Vector3(inst.Physics:GetVelocity())
    if v1:LengthSq() < 1 then 
		return 
	end
    inst:DoTaskInTime(2*FRAMES, function()
        if other and other.components.workable and other.components.workable.workleft > 0 and not other:HasTag("mushroomsprout") then
            SpawnPrefab("collapse_small").Transform:SetPosition(other:GetPosition():Get())
            other.components.workable:Destroy(inst)
        end
    end)
end

function SpawnMushroomSprout(inst)
	if IsDLCEnabled(CAPY_DLC) then
		local pt = Vector3(inst.Transform:GetWorldPosition())
		local theta = math.random() * 2 * PI
		local radius = math.random(4,8)
		local offset = FindWalkableOffset(pt, theta, radius, 12, true)
		if offset then
			local pos = pt + offset
			local ground = GetWorld()
			local tile = GROUND.GRASS
			if ground and ground.Map then
				tile = inst:GetCurrentTileType(pos:Get())
			end
			local onWater = ground.Map:IsWater(tile)
			if not onWater then 
				SpawnPrefab("mushroomsprout").Physics:Teleport(pos:Get())
			end 
		end
	else
		local pt = Vector3(inst.Transform:GetWorldPosition())
		local theta = math.random() * 2 * PI
		local radius = math.random(4,8)
		local offset = FindWalkableOffset(pt, theta, radius, 12, true)
		if offset then
			local pos = pt + offset
			local ground = GetWorld()
			local tile = GROUND.GRASS
			if ground and ground.Map then
				tile = inst:GetCurrentTileType(pos:Get())
			end
			SpawnPrefab("mushroomsprout").Physics:Teleport(pos:Get())
		end
	end
end

local function WanttoHeal(inst)
	inst:DoTaskInTime(7,function(inst) 
		if inst.did_healing < inst.max_healing and inst.components.health:GetPercent() < .66 and not (inst.sg:HasStateTag("busy") or inst.components.sleeper:IsAsleep() or inst.components.freezable:IsFrozen() or inst.components.health:IsDead()) then
			local starthealing = math.random(1,2)
			if starthealing == 1 then
				inst.sg:GoToState("channel")
				if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
					inst.components.health:SetAbsorptionAmount(0.80)
				else
					inst.components.health:SetAbsorbAmount(0.80)
				end		
				inst.did_healing = inst.did_healing + 1	
				inst:DoTaskInTime(math.random(1,2),function(inst) SpawnMushroomSprout(inst) end)
				inst:DoTaskInTime(math.random(3,4),function(inst) SpawnMushroomSprout(inst) end)
				inst:DoTaskInTime(math.random(5,6),function(inst) SpawnMushroomSprout(inst) end)
				inst:DoTaskInTime(math.random(7,8),function(inst) SpawnMushroomSprout(inst) end)
				inst:DoTaskInTime(math.random(9,10),function(inst) SpawnMushroomSprout(inst) end)
				inst:DoTaskInTime(math.random(11,12),function(inst) SpawnMushroomSprout(inst) end)
				inst:DoTaskInTime(420*FRAMES,function(inst)  
					if inst.sg:HasStateTag("channeling") and not (inst.components.sleeper:IsAsleep() or inst.components.freezable:IsFrozen() or inst.components.health:IsDead()) then
						inst.sg:GoToState("channel_pst")
						if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
							inst.components.health:SetAbsorptionAmount(0.0)
						else
							inst.components.health:SetAbsorbAmount(0.0)
						end				
					end
				end)		
			end
		end
		WanttoHeal(inst)
	end)
end	

local SHAKE_DIST = 40

local function ShakeIfClose(inst)
    local player = GetClosestInstWithTag("player", inst, SHAKE_DIST)
    if player then
        player.components.playercontroller:ShakeCamera(inst, "FULL", 0.35, 0.02, 1.25, SHAKE_DIST)
    end
end

local function ChannelExplode(inst)
	local pt = inst:GetPosition()
	local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 7)
	for k,v in pairs(ents) do
		if v.components.combat and v ~= inst and not (v:HasTag("toadstool") or v:HasTag("shadow")) then
			v.components.combat:GetAttacked(inst, 10)
		end
	end					
end

local FADE_FRAMES = 20
local FADE_INTENSITY = .75
local FADE_RADIUS = 2
local FADE_FALLOFF = .5

local function StartNight(inst)
    inst.components.sleeper:WakeUp()
end

local function ShouldSleep(inst)
    return GetClock():IsDay()
           and not (inst.components.combat and inst.components.combat.target)
           and not (inst.components.burnable and inst.components.burnable:IsBurning())
		   and not inst.sg:HasStateTag("channeling")
end

local function ShouldWake(inst)
    return GetClock():IsNight()
           or (inst.components.combat and inst.components.combat.target)
           or (inst.components.burnable and inst.components.burnable:IsBurning() )
end

function GetMushroomSprout(inst)
	local x,y,z = inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x,y,z,450, {"mushroomsprout"}, {"FX", "NOCLICK", "DECOR","INLIMBO"})
    return ents
end

function OnDeath(inst)
	local chestloot = TUNING.TOADSTOOL_ORNATECHEST
	inst:DoTaskInTime(2,function(inst) 
		local mushrooms = GetMushroomSprout(inst)
		for k,v in pairs(mushrooms) do			
			if not (v.components.burnable:IsBurning() or v:HasTag("treedown")) then
				v.components.workable:Destroy(inst)
			end
		end
	end)
	if chestloot == 1 then
		inst:DoTaskInTime(5, function()
			inst.SoundEmitter:PlaySound("dontstarve/common/ghost_spawn")
			local chest = SpawnPrefab("minotaurchest")
			local pos = inst:GetPosition()
			chest.Transform:SetPosition(pos.x, 0, pos.z)
			local fx = SpawnPrefab("statue_transition_2")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,2,1)
			end
			fx = SpawnPrefab("statue_transition")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,1.5,1)
			end
			chest:AddComponent("scenariorunner")
			chest.components.scenariorunner:SetScript("chest_toadstool")
			chest.components.scenariorunner:Run()
		end)
	end
end

function SpawnChest(inst)
	local chestloot = TUNING.TOADSTOOL_ORNATECHEST
	if chestloot == 1 then
		inst:DoTaskInTime(3, function()
			inst.SoundEmitter:PlaySound("dontstarve/common/ghost_spawn")
			local chest = SpawnPrefab("minotaurchest")
			local pos = inst:GetPosition()
			chest.Transform:SetPosition(pos.x, 0, pos.z)
			local fx = SpawnPrefab("statue_transition_2")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,2,1)
			end
			fx = SpawnPrefab("statue_transition")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,1.5,1)
			end
			chest:AddComponent("scenariorunner")
			chest.components.scenariorunner:SetScript("chest_toadstool")
			chest.components.scenariorunner:Run()
		end)
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize(6, 3.5)
	inst.entity:AddLight()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddLightWatcher()
	inst.Transform:SetSixFaced()
	MakeCharacterPhysics(inst, 1000, 2.5)
	inst.Physics:SetCollisionCallback(oncollide)
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "toadstool.tex" )
	
	inst.Light:SetRadius(FADE_RADIUS)
    inst.Light:SetFalloff(FADE_FALLOFF)
    inst.Light:SetIntensity(FADE_INTENSITY)
	inst.Light:SetColour(180 / 255, 60 / 255, 255 / 255)
	
	inst:AddTag("epic")
    inst:AddTag("monster")
    inst:AddTag("hostile")
    inst:AddTag("toadstool")
    inst:AddTag("scarytoprey")
    inst:AddTag("largecreature")
	
	inst.did_healing = 0
	inst.max_healing = 3
	
	anim:SetBank("toadstool")
	anim:SetBuild("toadstool_build")	
	anim:PlayAnimation("idle", true)
	anim:SetLightOverride(.3)
	
    inst.AnimState:Show("ARM_carry") 
    inst.AnimState:Hide("ARM_normal") 
	
	if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
		inst:AddComponent("groundpounder")
	end	
	
    inst:AddComponent("locomotor")
    inst.components.locomotor.pathcaps = {ignorewalls = true}
    inst.components.locomotor.walkspeed = .6
	
	inst:AddComponent("knownlocations")
	
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = CalcSanityAura
	
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(5000)
	if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
		inst.components.health:SetAbsorptionAmount(0.0)
	else
		inst.components.health:SetAbsorbAmount(0.0)
	end		

	inst:DoPeriodicTask(1,function(inst) 
		if inst.components.health then
			local level = 0
			local mushrooms = GetMushroomSprout(inst)
			for k,v in pairs(mushrooms) do			
				if not (v.components.burnable:IsBurning() or v:HasTag("treedown")) then
					if v:HasTag("mushroomsprout_level_2") then
						level = level + 2
					elseif v:HasTag("mushroomsprout_level_3") then
						level = level + 3
					elseif v:HasTag("mushroomsprout_level_4") then
						level = level + 4
					else
						level = level + 1
					end
				end
			end
			if level < 6 then
				if not inst.sg:HasStateTag("channeling") then  
					if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then  
						inst.components.health:SetAbsorptionAmount(0.0) 
					else
						inst.components.health:SetAbsorbAmount(0.0)	
					end
				end
				inst.components.locomotor.walkspeed = .6
				inst.components.combat:SetDefaultDamage(100)
				inst.AnimState:ClearOverrideSymbol("toad_mushroom")
			elseif level >= 6 and level < 11 then
				if not inst.sg:HasStateTag("channeling") then  
					if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then  
						inst.components.health:SetAbsorptionAmount(0.10) 
					else
						inst.components.health:SetAbsorbAmount(0.10)	
					end
				end
				inst.components.locomotor.walkspeed = .8
				inst.components.combat:SetDefaultDamage(115)
				inst.AnimState:OverrideSymbol("toad_mushroom", "toadstool_upg_build", "toad_mushroom1")
			elseif level >= 11 and level < 16 then
				if not inst.sg:HasStateTag("channeling") then  
					if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then  
						inst.components.health:SetAbsorptionAmount(0.20) 
					else
						inst.components.health:SetAbsorbAmount(0.20)	
					end
				end
				inst.components.locomotor.walkspeed = 1.2
				inst.components.combat:SetDefaultDamage(130)
				inst.AnimState:OverrideSymbol("toad_mushroom", "toadstool_upg_build", "toad_mushroom2")
			elseif level >= 16 then
				if not inst.sg:HasStateTag("channeling") then  
					if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then  
						inst.components.health:SetAbsorptionAmount(0.30) 
					else
						inst.components.health:SetAbsorbAmount(0.30)	
					end
				end
				inst.components.locomotor.walkspeed = 3.2
				inst.components.combat:SetDefaultDamage(150)
				inst.AnimState:OverrideSymbol("toad_mushroom", "toadstool_upg_build", "toad_mushroom3")
			end		
		end
	end)
	
	inst:DoTaskInTime(3,function(inst) 
		WanttoHeal(inst)
	end)
	
    inst:AddComponent("combat")
    inst.components.combat:SetDefaultDamage(100)
	inst.components.combat:SetRange(4)	
	inst.components.combat.playerdamagepercent = .66
    inst.components.combat:SetAreaDamage(4,0.5)	
    inst.components.combat:SetAttackPeriod(3)
	inst.components.combat:SetRetargetFunction(1,RetargetFn)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	
	inst:AddComponent("inspectable")
	
	inst:AddComponent("leader")
	
	inst:AddComponent("sleeper")
    inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWake)
	
	local brain = require "brains/toadstoolbrain"
    inst:SetBrain(brain)
	
    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable("toadstool")
	
	MakeLargeBurnableCharacter(inst, "swap_fire")
    MakeHugeFreezableCharacter(inst, "dragonfly_body")
    inst.components.freezable.wearofftime = 1.5
	
	inst:ListenForEvent("attacked", OnAttacked)
	inst:ListenForEvent("death", OnDeath)
	inst:ListenForEvent("death", SpawnChest)
	
	inst:SetStateGraph("SGtoadstool")
	
	inst:ListenForEvent("dusktime", function() StartNight(inst) end, GetWorld())
    return inst
end

STRINGS.NAMES.TOADSTOOL = "Toadstool"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TOADSTOOL = "Yeesh! I'm not kissing that!"

return Prefab("common/toadstool", fn, assets, prefabs)