local assets =
{
    Asset("ANIM", "anim/toadstool_actions.zip"),
    Asset("ANIM", "anim/toadstool_build.zip"),
}

local prefabs =
{
    "toadstool",
}

local function onworked(inst, worker)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/use_axe_mushroom")
    inst.AnimState:PlayAnimation("mushroom_toad_hit")
end

local function workdone(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/mushroom_up")
    local toadstool = SpawnPrefab("toadstool")
    toadstool.Transform:SetPosition(inst.Transform:GetWorldPosition())
    toadstool.sg:GoToState("surface")	
	inst:Remove()
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.Transform:SetSixFaced()
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "toadstool_cap.tex" )

    inst.AnimState:SetBank("toadstool")
    inst.AnimState:SetBuild("toadstool_build")
    --inst.AnimState:PlayAnimation("picked")
	inst.AnimState:PlayAnimation("mushroom_toad_idle_loop", true)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)

    MakeObstaclePhysics(inst, .5)

    inst:AddComponent("inspectable")
	
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.CHOP)
	inst.components.workable:SetWorkLeft(5)
	inst.components.workable:SetOnWorkCallback(onworked)
	inst.components.workable:SetOnFinishCallback(workdone)
    return inst
end

STRINGS.NAMES.TOADSTOOL_CAP = "Toadstool Cap"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TOADSTOOL_CAP = "That toadstool's just asking to be cut down."

return Prefab("toadstool_cap", fn, assets, prefabs)