local assets =
{
    Asset("ANIM", "anim/mushroombomb.zip"),
    Asset("ANIM", "anim/mushroombomb_base.zip"),
}

local projectile_assets =
{
    Asset("ANIM", "anim/mushroombomb.zip"),
}

local projectile_prefabs =
{
    "mushroombomb",
}

local FADE_FRAMES = 10
local FADE_INTENSITY = .8
local FADE_RADIUS = 1
local FADE_FALLOFF = .5

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()
    inst.entity:AddSoundEmitter()

    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("mushroombomb")
    inst.AnimState:SetBuild("mushroombomb")
    inst.AnimState:PlayAnimation("land")
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
	
	inst.Light:SetFalloff(FADE_FALLOFF)
    inst.Light:SetIntensity(FADE_INTENSITY)
    inst.Light:SetRadius(FADE_RADIUS)
    inst.Light:SetColour(180 / 255, 60 / 255, 255 / 255)
    inst.Light:Enable(true)
	
    inst:AddTag("explosive")
	
	inst:DoTaskInTime(1.3,function(inst)  inst.AnimState:PlayAnimation("grow1") end)
	inst:DoTaskInTime(2.6,function(inst)  inst.AnimState:PlayAnimation("grow2") end)
	inst:DoTaskInTime(3.9,function(inst)
		inst.AnimState:PlayAnimation("explode_pre")
		inst:DoTaskInTime(0.7,function(inst)
			local pos = Vector3(inst.Transform:GetWorldPosition())
			inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")  
			local smoke = SpawnPrefab("maxwell_smoke")
			local explode = SpawnPrefab("explode_small")
			local pos = inst:GetPosition()
			smoke.Transform:SetPosition(pos.x, pos.y, pos.z)
			smoke.Transform:SetScale(1.4,1.4,1.4)
			explode.Transform:SetPosition(pos.x, pos.y, pos.z)
			explode.Transform:SetScale(1.8,1.8,1.8)
			explode.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
			explode.AnimState:SetLightOverride(1)
			local pt = inst:GetPosition()
			local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 4)
			for k,v in pairs(ents) do
				if v.components.combat and v ~= inst and not (v:HasTag("toadstool") or v:HasTag("shadow")) then
					v.components.combat:GetAttacked(inst, 100)
				end
			end	
			inst:Remove()
		end)
	end)
    return inst
end

local function OnProjectileHit(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
    local bomb = SpawnPrefab("mushroombomb")
    bomb.Transform:SetPosition(x, y, z)
	inst:Remove()
end

local function projectile_fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    inst.entity:AddPhysics()
    inst.Physics:SetMass(1)
    inst.Physics:SetCapsule(.2, .2)
    inst.Physics:SetFriction(0)
    inst.Physics:SetDamping(0)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)

    inst.AnimState:SetBank("mushroombomb")
    inst.AnimState:SetBuild("mushroombomb")
    inst.AnimState:PlayAnimation("projectile_loop")

    inst:AddTag("NOCLICK")
	
    inst:AddComponent("locomotor")

    inst:AddComponent("complexprojectile2")
    inst.components.complexprojectile2:SetHorizontalSpeed(15)
    inst.components.complexprojectile2:SetGravity(-25)
    inst.components.complexprojectile2:SetLaunchOffset(Vector3(0, 2.5, 0))
    inst.components.complexprojectile2:SetOnHit(OnProjectileHit)	
    inst.persists = false
    return inst
end

return Prefab("mushroombomb", fn, assets),
    Prefab("mushroombomb_projectile", projectile_fn, projectile_assets, projectile_prefabs)