require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/mushroomsprout.zip"),
	Asset("ANIM", "anim/mushroomsprout_upg_build.zip"),
}

local prefabs =
{
}

local FADE_FRAMES = 10
local FADE_INTENSITY = .8
local FADE_RADIUS = 1
local FADE_FALLOFF = .5

local function stop_burning(inst)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
end

local function OnBurnt(inst)
    inst:RemoveComponent("burnable")
    inst:RemoveComponent("propagator")
    inst.components.workable:SetOnWorkCallback(nil)
    inst.components.workable:SetOnFinishCallback(nil)
	if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
		inst.components.workable:SetWorkable(false)
	end	
	inst:AddTag("treedown")
    RemovePhysicsColliders(inst)
    --SpawnPrefab("sporecloud").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.AnimState:PlayAnimation("burnt_chop")
    inst:ListenForEvent("animover", inst.Remove)
    inst:AddTag("NOCLICK")
end

local function chop_down_tree(inst, worker)
    inst.components.workable:SetOnWorkCallback(nil)
    inst.components.workable:SetOnFinishCallback(nil)
    if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
		inst.components.workable:SetWorkable(false)
	end	
	inst:AddTag("treedown")
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst:DoTaskInTime(28*FRAMES, stop_burning)
    end
    inst.SoundEmitter:PlaySound("dontstarve/forest/treeCrumble")
    inst.AnimState:PlayAnimation("fall")
    inst:ListenForEvent("animover", inst.Remove)
    inst:AddTag("NOCLICK")
end

local function chop_tree(inst, chopper)
	if chopper and chopper.components.beaverness and chopper.components.beaverness:IsBeaver() then
		inst.SoundEmitter:PlaySound("dontstarve/characters/woodie/beaver_chop_tree")
	else
		inst.SoundEmitter:PlaySound("dontstarve/wilson/use_axe_mushroom")
	end
    inst.AnimState:PlayAnimation("chop")
end

local function Level2(inst)
	inst.regenlevel = 2
	inst:RemoveTag("mushroomsprout_level_3")
	inst:RemoveTag("mushroomsprout_level_4")
	inst:AddTag("mushroomsprout_level_2")	
	inst.AnimState:ClearOverrideSymbol("trunk")
	inst.AnimState:OverrideSymbol("trunk", "mushroomsprout_upg_build", "trunk1")
end

local function Level3(inst)
	inst.regenlevel = 3
	inst:RemoveTag("mushroomsprout_level_2")
	inst:RemoveTag("mushroomsprout_level_4")
	inst:AddTag("mushroomsprout_level_3")	
	inst.AnimState:OverrideSymbol("trunk", "mushroomsprout_upg_build", "trunk2")
end

local function Level4(inst)
	inst.regenlevel = 4
	inst:RemoveTag("mushroomsprout_level_2")
	inst:RemoveTag("mushroomsprout_level_3")
	inst:AddTag("mushroomsprout_level_4")
	inst.AnimState:OverrideSymbol("trunk", "mushroomsprout_upg_build", "trunk3")
end

function GetToadStool(inst)
	local x,y,z = inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x,y,z,450, {"toadstool"}, {"FX", "NOCLICK", "DECOR","INLIMBO"})
    return ents
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()
    inst.entity:AddSoundEmitter()
	inst.entity:AddPhysics()
    inst.Physics:SetMass(0) 
    inst.Physics:SetCapsule(.25, 2)
    inst.Physics:SetCollisionGroup(COLLISION.OBSTACLES)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.ITEMS)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)
	
	inst.Light:SetFalloff(FADE_FALLOFF)
    inst.Light:SetIntensity(FADE_INTENSITY)
    inst.Light:SetRadius(FADE_RADIUS)
    inst.Light:SetColour(180 / 255, 60 / 255, 255 / 255)
    inst.Light:Enable(true)
		
	inst.AnimState:SetBank("mushroomsprout")
	inst.AnimState:SetBuild("mushroomsprout")
	inst.AnimState:PlayAnimation("shroom_pre")
	inst.AnimState:SetLightOverride(.3)
	
	inst:AddTag("tree")
    inst:AddTag("mushroomsprout")
    inst:AddTag("cavedweller")
		
	inst:AddComponent("inspectable")
	
	inst.regenlevel = 1
	
	inst:DoTaskInTime(6, function(inst) 
		if not (inst.components.burnable:IsBurning() or inst:HasTag("treedown")) then
			inst.AnimState:PlayAnimation("transform")
			inst.SoundEmitter:PlaySound("dontstarve/forest/treeGrow")
			inst:DoTaskInTime(15*FRAMES, function(inst) Level2(inst) end)
		end
	end)
	
	inst:DoTaskInTime(18, function(inst) 
		if not (inst.components.burnable:IsBurning() or inst:HasTag("treedown")) then
			inst.AnimState:PlayAnimation("transform")
			inst.SoundEmitter:PlaySound("dontstarve/forest/treeGrow")
			inst:DoTaskInTime(15*FRAMES, function(inst) Level3(inst) end)
		end
	end)
	
	inst:DoTaskInTime(36, function(inst) 
		if not (inst.components.burnable:IsBurning() or inst:HasTag("treedown")) then
			inst.AnimState:PlayAnimation("transform")
			inst.SoundEmitter:PlaySound("dontstarve/forest/treeGrow")
			inst:DoTaskInTime(15*FRAMES, function(inst) Level4(inst) end)
		end
	end)
	
	inst:DoPeriodicTask(17*FRAMES,function(inst)
		local toadstool = GetToadStool(inst)
		for k,v in pairs(toadstool) do
			if not v.components.health:IsDead() then
				v.components.health:DoDelta(5 * inst.regenlevel)
			end
		end
	end)
	
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.CHOP)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnWorkCallback(chop_tree)
    inst.components.workable:SetOnFinishCallback(chop_down_tree)

	MakeMediumBurnable(inst, nil, nil, true)
	MakeSmallPropagator(inst)
	inst.components.burnable:SetOnBurntFn(OnBurnt)
	return inst
end

STRINGS.NAMES.MUSHROOMSPROUT = "Mushroom Sprout"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MUSHROOMSPROUT = "I should chop that quickly."

return Prefab( "common/mushroomsprout", fn, assets, prefabs)