local assets=
{
	Asset("ANIM", "anim/shroom_skin.zip"),
	Asset("IMAGE", "images/inventoryimages/shroom_skin.tex"),
	Asset("ATLAS", "images/inventoryimages/shroom_skin.xml"),
}

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("shroom_skin")
    anim:SetBuild("shroom_skin")
    anim:PlayAnimation("idle")
    
    inst:AddComponent("inspectable")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = -20
	inst.components.edible.hungervalue = 150
	inst.components.edible.sanityvalue = 200
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/shroom_skin.xml"
	inst.components.inventoryitem:ChangeImageName("shroom_skin")
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = 9999
    return inst
end

STRINGS.NAMES.SHROOM_SKIN = "Shroom Skin"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHROOM_SKIN = "Warts and all!"

return Prefab( "common/inventory/shroom_skin", fn, assets) 
