require("stategraphs/commonstates")

local easing = require("easing")

local actionhandlers = 
{
	ActionHandler(ACTIONS.HAMMER, "attack"),
	ActionHandler(ACTIONS.GOHOME, "taunt"),
}

local function FindMushroomBombTargets(inst)
    local maxbombs = 6--inst.mushroombomb_variance > 0 and inst.mushroombomb_count + math.random(inst.mushroombomb_variance) or inst.mushroombomb_count
    local delta = (1 + math.random()) * PI / maxbombs
    local offset = 2 * PI * math.random()
    local angles = {}
    for i = 1, maxbombs do
        table.insert(angles, i * delta + offset)
    end
    local pt = inst:GetPosition()
    local maxrange = 8.75
    for i = 1, 2 do
        local closerange = (4 + maxrange) * .5
        local targets = TheSim:FindEntities(pt.x, 0, pt.z, closerange, { "_combat", "_health" }, { "player", "INLIMBO" })
        maxrange = closerange
    end
    local range = GetRandomMinMax(4, maxrange)
    local targets = {}
    while #angles > 0 do
        local theta = table.remove(angles, math.random(#angles))
        local offset = FindWalkableOffset(pt, theta, range, 12, true)
        if offset ~= nil then
            offset.x = offset.x + pt.x
            offset.y = 0
            offset.z = offset.z + pt.z
            table.insert(targets, offset)
        end
    end
    return targets
end

local function SpawnMushroomBombProjectile(inst, targets)
    local x, y, z = inst.Transform:GetWorldPosition()
    local projectile = SpawnPrefab("mushroombomb_projectile")
    projectile.Transform:SetPosition(x, y, z)
    local targetpos = table.remove(targets, 1)
    local dx = targetpos.x - x
    local dz = targetpos.z - z
    local rangesq = dx * dx + dz * dz
    local maxrange = 15
    local bigNum = 15
    local speed = easing.linear(rangesq, bigNum, 3, maxrange * maxrange)
    projectile.components.complexprojectile2:SetHorizontalSpeed(speed)
    projectile.components.complexprojectile2:Launch(targetpos, inst, inst)
    if #targets > 0 then
        inst:DoTaskInTime(FRAMES, SpawnMushroomBombProjectile, targets)
    end
end

local function DoMushroomBomb(inst)
    local targets = FindMushroomBombTargets(inst)
    if #targets > 0 then
        inst:DoTaskInTime(FRAMES, SpawnMushroomBombProjectile, targets)
    end
end

local SHAKE_DIST = 40

local function ShakeIfClose(inst)
    local player = GetClosestInstWithTag("player", inst, SHAKE_DIST)
    if player then
        player.components.playercontroller:ShakeCamera(inst, "FULL", 0.35, 0.02, 1.25, SHAKE_DIST)
    end
end

local function DoFootstep(inst)
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/step_soft")
end

local function DoStompstep(inst)
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/step_stomp")
    --ShakeIfClose(inst)
end

local function RoarA(inst)
	local snd = math.random(1,4)
	inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_RoarA_" .. snd)
end

local function RoarB(inst)
	local snd = math.random(1,4)
	inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_RoarB_v2_" .. snd)
end

local function BigRoar(inst)
	local snd = math.random(1,2)
	inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_phase_transition_roar_v2_" .. snd)
	inst:DoTaskInTime(8*FRAMES, function(inst) ShakeIfClose(inst) end)
	inst:DoTaskInTime(21*FRAMES, function(inst) ShakeIfClose(inst) end)
end

local function AppearPre(inst)
	local snd = math.random(1,3)
	inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_spawn_appear_pre_" .. snd)
end

local function Appear(inst)
	local snd = math.random(1,3)
	inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_spawn_appear_" .. snd)
end

local function Hit(inst)
	local snd = math.random(1,7)
	inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_hit_v2_" .. snd)
end

local events=
{
    CommonHandlers.OnLocomote(false,true),
    CommonHandlers.OnSleep(),
    CommonHandlers.OnFreeze(),
    CommonHandlers.OnAttack(),
	EventHandler("doattack", function(inst, data)
		if inst.components.health and not inst.components.health:IsDead() and (inst.sg:HasStateTag("hit") or not inst.sg:HasStateTag("busy")) then
			local altattackchance = math.random(1,10)
			if altattackchance == 1 then
				inst.sg:GoToState("pound_pre")
			elseif altattackchance > 1 and altattackchance <= 5 then
				inst.sg:GoToState("sporebomb")
			elseif altattackchance > 5 then
				inst.sg:GoToState("attack")
			end
		end
	end),
    CommonHandlers.OnAttacked(),
    CommonHandlers.OnDeath(),
}

local states=
{
	State
	{
        name = "idle",
        tags = {"idle"},

        onenter = function(inst)
			inst.Physics:Stop()
			inst.AnimState:PlayAnimation("idle", true)
        end,
    },

    State
	{
        name = "death",
        tags = {"busy"},
        onenter = function(inst)
            inst.SoundEmitter:PlaySound("dontstarve/wilson/death") 
            inst.AnimState:PlayAnimation("death")
            inst.Physics:Stop()
            RemovePhysicsColliders(inst)            
            inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition()))            
        end,
    },
	
	State
	{
        name = "death",
        tags = {"busy"},

        onenter = function(inst)
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("death")
            inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/dragonfly/death")
            inst:AddTag("NOCLICK")
        end,

        timeline =
        {
            TimeEvent(4*FRAMES, function(inst) inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_channeling_LP_v2", "channel") end),
            TimeEvent(23*FRAMES, function(inst) inst.SoundEmitter:KillSound("channel") end),
            TimeEvent(24*FRAMES, function(inst) RoarB(inst) end),
            TimeEvent(35*FRAMES, function(inst)
                --local x, y, z = inst.Transform:GetWorldPosition()
                --for i, v in ipairs(TheSim:FindEntities(x, y, z, 8, { "sporecloud" })) do
                    --v:FinishImmediately()
                --end
				inst.components.lootdropper:DropLoot(inst:GetPosition())
            end),	
            TimeEvent(36*FRAMES, function(inst) inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toad_death_fall_v2") end),
            TimeEvent(52*FRAMES, function(inst)inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toad_stool_death") end),
            --TimeEvent(5-FRAMES, function(inst) inst:FadeOut() end),
            --TimeEvent(5,ErodeAway),
        },

        onexit = function(inst)
            inst.SoundEmitter:KillSound("channel")
            inst:RemoveTag("NOCLICK")
            inst:CancelFade()
        end,
    },
	
	State
	{
        name = "walk_start",
        tags = {"moving", "canrotate"},

        onenter = function(inst)
            inst.components.locomotor:WalkForward()
            inst.AnimState:PlayAnimation("walk_pre")
        end,
		
		events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("walk") end),        
        },
    },
	
	State
	{
        name = "walk",
        tags = {"moving", "canrotate"},

        onenter = function(inst)
            inst.components.locomotor:WalkForward()
            inst.AnimState:PlayAnimation("walk")
        end,

        timeline =
        {
            TimeEvent(0*FRAMES, DoFootstep),
            TimeEvent(10*FRAMES, DoStompstep),
            TimeEvent(19*FRAMES, DoFootstep),
            TimeEvent(30*FRAMES, DoStompstep),
        },
		
		events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("walk") end),        
        },
    },
    
    State{
    
        name = "run_stop",
        tags = {"canrotate", "idle"},
        
        onenter = function(inst) 
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("run_pst")
        end,
        
        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),        
        },
        
    },    

	State
	{
        name = "walk_stop",
        tags = {"canrotate"},

        onenter = function(inst)
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("walk_pst")
        end,

        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),        
        },
    },
	
	State
	{
        name = "attack",
        tags = {"attack", "busy", "canrotate"},

        onenter = function(inst)
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("attack_basic")
            inst.components.combat:StartAttack()
        end,

        timeline =
        {
            TimeEvent(0*FRAMES, function(inst) RoarA(inst) end),
            --TimeEvent(10*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/toad_stool/spore_shoot") end),
			TimeEvent(14*FRAMES, function(inst) 
				--inst.components.combat:DoAttack(inst.sg.statemem.target) 
				DoMushroomBomb(inst)
			end),
            --TimeEvent(12*FRAMES, function(inst)
            --    inst.sg:AddStateTag("nosleep")
            --    inst.sg:AddStateTag("nofreeze")
            --end),
            --TimeEvent(14*FRAMES, function(inst)
            --    DoMushroomBombShake(inst)
            --    inst:DoMushroomBomb()
            --    inst.sg.mem.mushroombomb_chains = (inst.sg.mem.mushroombomb_chains or 0) + 1
            --    if inst.sg.mem.mushroombomb_chains >= inst.mushroombomb_maxchain then
            --         inst.sg.mem.mushroombomb_chains = 0
            --        inst.components.timer:StartTimer("mushroombomb_cd", inst.mushroombomb_cd)
            --    end
            --end),
        },

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	
	State
	{
        name = "sporebomb",
        tags = {"attack", "busy", "sporebombing", "canrotate"},

        onenter = function(inst, targets)
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("attack_infection")
            inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_channeling_LP_v2", "channel")	
            inst.SoundEmitter:SetParameter("channel", "intensity", 1)
            inst.components.combat:StartAttack()
        end,

        timeline =
        {
            TimeEvent(15*FRAMES, function(inst) inst.sg:AddStateTag("nosleep") inst.sg:AddStateTag("nofreeze") end),
            TimeEvent(18*FRAMES, function(inst) inst.SoundEmitter:KillSound("channel") RoarB(inst) end),
            TimeEvent(21*FRAMES, function(inst) RoarA(inst) end),
			--TimeEvent(22*FRAMES, function(inst) inst.components.combat.poisonous = true inst.components.combat:DoAttack(inst.sg.statemem.target)  end),
			--TimeEvent(27*FRAMES, function(inst) inst.components.combat:DoAttack(inst.sg.statemem.target) inst.components.combat.poisonous = false end),
			TimeEvent(22*FRAMES, function(inst) inst.components.combat:DoAttack(inst.sg.statemem.target) end),
			TimeEvent(27*FRAMES, function(inst) inst.components.combat:DoAttack(inst.sg.statemem.target) end),
            --TimeEvent(22*FRAMES, function(inst)
                --DoSporeBombShake(inst)
                --inst:DoSporeBomb(inst.sg.statemem.targets)
                --inst.components.timer:StartTimer("sporebomb_cd", inst.sporebomb_cd)
            --end),
            TimeEvent(43*FRAMES, function(inst) inst.sg:RemoveStateTag("busy") inst.sg:RemoveStateTag("nosleep") inst.sg:RemoveStateTag("nofreeze") end),
        },

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },

        onexit = function(inst)
            inst.SoundEmitter:KillSound("channel")
        end,
    },
	
	State
	{
        name = "pound_pre",
        tags = {"attack", "busy", "pounding", "nosleep", "nofreeze"},

        onenter = function(inst)
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("attack_pound_pre")
            --inst.pound_speed = math.min(6,9)
            --inst.components.timer:StartTimer("pound_cd", Remap(inst.pound_speed, 1, 6, inst.pound_cd, inst.pound_cd * .5))
        end,

        timeline =
        {
            TimeEvent(11*FRAMES, function(inst) RoarB(inst) end),
            TimeEvent(37*FRAMES, function(inst)
                ShakeIfClose(inst)
				if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
					inst.components.groundpounder:GroundPound()
					inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/groundpound")
				else
					inst.components.combat:DoAreaAttack(inst, 7, nil, nil, nil, { "INLIMBO", "notarget", "invisible", "noattack", "flight", "playerghost", "shadow", "shadowchesspiece", "shadowcreature" })
					inst.components.combat:DoAreaAttack(inst, 7, nil, nil, nil, { "INLIMBO", "notarget", "invisible", "noattack", "flight", "playerghost", "shadow", "shadowchesspiece", "shadowcreature" })
					inst.components.combat:DoAreaAttack(inst, 7, nil, nil, nil, { "INLIMBO", "notarget", "invisible", "noattack", "flight", "playerghost", "shadow", "shadowchesspiece", "shadowcreature" })
				end	
				
            end),
        },
		
		events =
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("pound") end),
        },
    },

    State
	{
        name = "pound",
        tags = {"attack", "busy", "pounding", "nosleep", "nofreeze"},

        onenter = function(inst)
            inst.AnimState:PlayAnimation("attack_pound_loop")
        end,

        timeline =
        {
            TimeEvent(8*FRAMES, function(inst)
                --TheWorld:PushEvent("ms_miniquake", { rad = 20, num = 20, duration = 2.5, target = inst })
				ShakeIfClose(inst)
                if (IsDLCEnabled(CAPY_DLC) or IsDLCEnabled(REIGN_OF_GIANTS)) then
					inst.components.groundpounder:GroundPound()
					inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/groundpound")
				else
					inst.components.combat:DoAreaAttack(inst, 7, nil, nil, nil, { "INLIMBO", "notarget", "invisible", "noattack", "flight", "playerghost", "shadow", "shadowchesspiece", "shadowcreature" })
					inst.components.combat:DoAreaAttack(inst, 7, nil, nil, nil, { "INLIMBO", "notarget", "invisible", "noattack", "flight", "playerghost", "shadow", "shadowchesspiece", "shadowcreature" })
					inst.components.combat:DoAreaAttack(inst, 7, nil, nil, nil, { "INLIMBO", "notarget", "invisible", "noattack", "flight", "playerghost", "shadow", "shadowchesspiece", "shadowcreature" })
				end	
            end),
        },
		
		events =
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("pound_pst") end),
        },
    },

    State
	{
        name = "pound_pst",
        tags = {"attack", "busy", "pounding", "nosleep", "nofreeze"},

        onenter = function(inst, sleeping)
            inst.AnimState:PlayAnimation("attack_pound_pst")
        end,

        timeline =
        {
            TimeEvent(5*FRAMES, function(inst)
                inst.sg:RemoveStateTag("busy")
                inst.sg:RemoveStateTag("nosleep")
                inst.sg:RemoveStateTag("nofreeze")
            end),
        },

        events =
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	
    State
	{
        name = "hit",
        tags = {"hit"},

        onenter = function(inst)
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("hit")	
            Hit(inst)		
            inst.sg.mem.last_hit_time = GetTime()
        end,

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	
	State
	{
        name = "taunt",
        tags = {"taunt", "busy", "nosleep", "nofreeze"},

        onenter = function(inst)
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("phase_transition")
        end,

        timeline =
        {
            TimeEvent(8*FRAMES, function(inst) BigRoar(inst) end),
        },

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	
	State
	{
        name = "surface",
        tags = {"busy", "nosleep", "nofreeze", "noattack"},

        onenter = function(inst)
            inst.components.locomotor:StopMoving()
            inst.components.health:SetInvincible(true)
            inst.AnimState:PlayAnimation("spawn_appear_toad")
            inst.AnimState:SetLightOverride(0)
            inst.DynamicShadow:Enable(false)
            inst.Light:Enable(false)
        end,

        timeline =
        {
            TimeEvent(0*FRAMES, function(inst) AppearPre(inst) end),
            TimeEvent(10*FRAMES, function(inst) ShakeIfClose(inst) end),
            TimeEvent(12*FRAMES, function(inst)
                Appear(inst)
                inst.AnimState:SetLightOverride(.3)
                inst.DynamicShadow:Enable(true)
                inst.Light:Enable(true)
            end),
            TimeEvent(31*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/groundpound") end),
            TimeEvent(32*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/dustpoof") end),
        },

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("taunt") end),
        },

        onexit = function(inst)
            inst.components.health:SetInvincible(false)
            inst.AnimState:SetLightOverride(.3)
            inst.DynamicShadow:Enable(true)
            inst.Light:Enable(true)
        end,
    },
	
	State
	{
        name = "channel_pre",
        tags = {"busy", "channeling","nosleep", "nofreeze", "noattack", "canrotate"},

        onenter = function(inst)
			inst.Physics:Stop()
            inst.components.locomotor:StopMoving()
            inst.AnimState:PlayAnimation("attack_channeling_pre")
        end,

        timeline =
        {
			--TimeEvent(0*FRAMES, function(inst) inst.healing = inst.healing + 1 end),
			TimeEvent(14*FRAMES, function(inst) ShakeIfClose(inst) end),
        },

		events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("channel") end),
        },
    },

    State
	{
        name = "channel",
        tags = {"busy", "channeling","nosleep", "nofreeze", "noattack", "canrotate"},

        onenter = function(inst)
			inst.Physics:Stop()
            inst.AnimState:PlayAnimation("attack_channeling_loop", true)
            if not inst.SoundEmitter:PlayingSound("channel") then
                inst.SoundEmitter:PlaySound("toadstool/toadstool/DST_toadstool_channeling_LP_v2", "channel")
                inst.SoundEmitter:SetParameter("channel", "intensity", 0)
            end	
        end,

        onupdate = function(inst)
            inst.SoundEmitter:SetParameter("channel", "intensity", 1)
        end,

		events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("channel") end),
        },
    },

    State
	{
        name = "channel_pst",
        tags = {"busy"},

        onenter = function(inst)
            inst.AnimState:PlayAnimation("attack_channeling_pst")
        end,

        timeline =
        {
            TimeEvent(15*FRAMES, function(inst) inst.sg:RemoveStateTag("busy") end),
        },

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
}

CommonStates.AddSleepStates(states,
{
    starttimeline =
    {
        TimeEvent(45*FRAMES, function(inst) inst.sg:RemoveStateTag("caninterrupt") end),
        TimeEvent(46*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/step_stomp") ShakeIfClose(inst) end),
    },
    waketimeline =
    {
        TimeEvent(45*FRAMES, function(inst) inst.sg:RemoveStateTag("busy") inst.sg:RemoveStateTag("nosleep") end),
    },
},
{
    onsleep = function(inst)
        inst.sg:AddStateTag("caninterrupt")
    end,
})

CommonStates.AddSimpleState(states,"refuse", "hungry", {"busy"})
CommonStates.AddFrozenStates(states)

return StateGraph("toadstool", states, events, "idle", actionhandlers)