-- AttachableSettings specialization by rafftnix
-- author: rafftnix
-- History FS 11: 
--          v1.0: initial Version (November 2011) 
--			v1.1: moveable HUD added and some Bugfixes (January 2011) 
--
-- History FS 13: 
--			v1.0: convert to FS 13
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

AttachableSettings = {};

function AttachableSettings.prerequisitesPresent(specializations)
    return true;
end;

function AttachableSettings:load(xmlFile)
	self.aiMarkerBackup = {}
	
	if self.aiLeftMarker ~= nil then
		self.aiMarkerBackup.left = {getTranslation(self.aiLeftMarker)}
	end;
	if self.aiRightMarker ~= nil then
		self.aiMarkerBackup.right = {getTranslation(self.aiRightMarker)}
	end;
	if self.aiBackMarker ~= nil then
		self.aiMarkerBackup.back = {getTranslation(self.aiBackMarker)}
	end;
	
	if self.aiLeftMarker ~= nil and self.aiRightMarker ~= nil then 
		self.allowTrackCountImplement = not SpecializationUtil.hasSpecialization(Plough, self.specializations);
		self.hirableToolsReady = true;
	else
		self.hirableToolsReady = false;
	end;
	
	if SpecializationUtil.hasSpecialization(Attachable, self.specializations) and SpecializationUtil.hasSpecialization(Combine, self.specializations) then
		self.hirableToolsReady = false;
	end;

	-- make sure the ai markers are symmetrical
	if self.aiLeftMarker ~= nil and self.aiRightMarker ~= nil then 
		local rightNeg = -self.aiMarkerBackup.right[1];
		local diff = self.aiMarkerBackup.left[1] - rightNeg;
		if not (diff < 1 and diff > -1) then	
			self.allowTrackCountImplement = false;
		end;
	end;
end;

function AttachableSettings:delete()
end;

function AttachableSettings:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AttachableSettings:keyEvent(unicode, sym, modifier, isDown)
end;

function AttachableSettings:onAttach(attacherVehicle)
	local marker = self.aiMarkerBackup;
	local trackCount = attacherVehicle.trackCount;
	local headLand = attacherVehicle.headLand;
		
	if marker ~= nil and trackCount ~= nil and headLand ~= nil then
		if self.aiLeftMarker ~= nil then
			setTranslation(self.aiLeftMarker, marker.left[1] * trackCount, marker.left[2], marker.left[3] + headLand);
		end;
		if self.aiRightMarker ~= nil then
			setTranslation(self.aiRightMarker, marker.right[1] * trackCount, marker.right[2], marker.left[3] + headLand);
		end;
		if self.aiBackMarker ~= nil then
			setTranslation(self.aiBackMarker, marker.back[1] * trackCount, marker.back[2], marker.back[3] + headLand);
		end;
	end;
end;

function AttachableSettings:onDetach(attacherVehicle)
	local marker = self.aiMarkerBackup;

	if self.aiLeftMarker ~= nil then
		setTranslation(self.aiLeftMarker, marker.left[1], marker.left[2], marker.left[3]);
	end;
	if self.aiRightMarker ~= nil then
		setTranslation(self.aiRightMarker, marker.right[1], marker.right[2], marker.right[3]);
	end;
	if self.aiBackMarker ~= nil then
		setTranslation(self.aiBackMarker, marker.back[1], marker.back[2], marker.back[3]);
	end;
end;

function AttachableSettings:update(dt)

end;

function AttachableSettings:draw()

end;