-- HirableTools specialization by rafftnix
-- author: rafftnix
-- History FS 11: 
--          v1.0: initial Version (November 2011) 
-- 			v2.0: Mousemenue, "headLand", Multiplayer support added and renamed because of Compatiblity. (January 2012)
-- 			v2.1: Moveable HUD added and some Bugfixes (March 2012)

-- History FS 13: 
--			v1.0: converted for FS 13, code simplified
--
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

HirableTools = {};
HirableTools.dir = g_currentModDirectory;

function HirableTools.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Hirable, specializations);
end;

function HirableTools:load(xmlFile)
	-- functions
	self.setHirableToolsSettings = SpecializationUtil.callSpecializationsFunction("setHirableToolsSettings");
	self.setTurnstageAtHeadLand = SpecializationUtil.callSpecializationsFunction("setTurnstageAtHeadLand");
	self.attachImplement = Utils.overwrittenFunction(self.attachImplement, HirableTools.attachImplementFix);	
	self.detachImplement = Utils.overwrittenFunction(self.detachImplement, HirableTools.detachImplementFix);	
	
	-- basic settings
	self.trackCount = 1;
	self.headLand = 0;
	self.turnStageBackup = 0;
	self.hirableToolsAllowed = false;
	self.allowTrackCount = false;
	self.checkMouseActive = false;
	
	self.allowHeadLand = not SpecializationUtil.hasSpecialization(Combine, self.specializations);
 
	-- HUD
	self.hirableToolsHUD = {}
	self.hirableToolsHUD.isActive = false;
	self.hirableToolsHUD.baseX = 0.85;
	self.hirableToolsHUD.baseY = 0.53;
	self.hirableToolsHUD.isMoving = false;
	local file = HirableTools.dir.."hud.dds";
	self.hirableToolsHUD.overlay = createImageOverlay(file);
	local file = HirableTools.dir.."icn_plus.dds";
	self.hirableToolsHUD.plus = createImageOverlay(file);
	local file = HirableTools.dir.."icn_minus.dds";
	self.hirableToolsHUD.minus = createImageOverlay(file);
	
	-- self propelled harvester
	if self.onStartReel ~= nil and self.onStopReel ~= nil then
		if self.hirableToolsReady then
			self.hirableToolsAllowed = true;
		end;
		if self.allowTrackCountImplement ~= nil and self.allowTrackCountImplement then
			self.allowTrackCount = true;
		end;
	end;
end;

function HirableTools:delete()

end;

function HirableTools:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local trackCount = getXMLInt(xmlFile, key.."#trackCount");
	local headLand = getXMLInt(xmlFile, key.."#headLand");
	if trackCount ~= nil and headLand ~= nil then
		self:setHirableToolsSettings(trackCount, headLand);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function HirableTools:getSaveAttributesAndNodes(nodeIdent)
	local attributes = string.format('trackCount="%d" ', self.trackCount);
	attributes = attributes..string.format('headLand="%d"', self.headLand);
	return attributes, nil;
end;

function HirableTools:readStream(streamId, connection)
	self.hirableToolsBackup = {}
	self.hirableToolsBackup[1] = streamReadInt8(streamId);
	self.hirableToolsBackup[2] = streamReadInt8(streamId);
end;

function HirableTools:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.trackCount);
	streamWriteInt8(streamId, self.headLand);
end;

function HirableTools:setHirableToolsSettings(trackCount, headLand, noEventSend, setNoAttributes)
	if not self.allowHeadLand then
		headLand = 0;
	end;
	
	if not setNoAttributes then
		self.headLand = headLand;
		self.trackCount = trackCount;
	end;

	for k, v in pairs(self.attachedImplements) do 
		local implement = v.object;
		if implement.hirableToolsReady then
			local trackCount2 = 1;
			if self.allowTrackCount then
				trackCount2 = trackCount;
			end;
		
			local marker = implement.aiMarkerBackup;
			if implement.aiLeftMarker ~= nil then
				setTranslation(implement.aiLeftMarker, marker.left[1] * trackCount2, marker.left[2], marker.left[3] + headLand);
			end;
			if implement.aiRightMarker ~= nil then
				setTranslation(implement.aiRightMarker, marker.right[1] * trackCount2, marker.right[2], marker.right[3] + headLand);
			end;
			if implement.aiBackMarker ~= nil then
				setTranslation(implement.aiBackMarker, marker.back[1], marker.back[2], marker.back[3] + headLand);
			end;
		end;
	end;
		
	if self.aiMarkerBackup ~= nil and self.hirableToolsReady then
		local trackCount2 = 1;
		if self.allowTrackCount then
			trackCount2 = trackCount;
		end;
			
		if self.aiLeftMarker ~= nil then
			setTranslation(self.aiLeftMarker, self.aiMarkerBackup.left[1] * trackCount2, self.aiMarkerBackup.left[2], self.aiMarkerBackup.left[3] + headLand);
		end;
		if self.aiRightMarker ~= nil then
			setTranslation(self.aiRightMarker, self.aiMarkerBackup.right[1] * trackCount2, self.aiMarkerBackup.right[2], self.aiMarkerBackup.right[3] + headLand);
		end;
		if self.aiBackMarker ~= nil then
			setTranslation(self.aiBackMarker, self.aiMarkerBackup.back[1] * trackCount2, self.aiMarkerBackup.back[2], self.aiMarkerBackup.back[3] + headLand);
		end;
	end;
	
	if not noEventSend then
		SetHirableToolsSettingsEvent.sendEvent(self, trackCount, headLand, noEventSend);
	end;
end;

function HirableTools:setTurnstageAtHeadLand() 
	if self.turnStage == 1 then
		self:setHirableToolsSettings(self.trackCount, 0, true, true);
	elseif self.turnStage == 0 then
		self:setHirableToolsSettings(self.trackCount, self.headLand, true);
	end;
end;

function HirableTools:mouseEvent(posX, posY, isDown, isUp, button)
	if self:getIsActiveForInput(false) and self.hirableToolsAllowed then
		if self.hirableToolsHUD.isMoving then
			self.hirableToolsHUD.baseX = posX;
			self.hirableToolsHUD.baseY = posY + 0.09;
		end;
		-- HUD move
		local baseX = self.hirableToolsHUD.baseX;
		local baseY = self.hirableToolsHUD.baseY;
		
		local HUDchanged = false;
		if self.hirableToolsHUD.isMoving and isDown and button == 1 then
			self.hirableToolsHUD.isMoving = false;
			HUDchanged = true;
		end;
		if isDown and button == 1 and HUDchanged ~= true then
			if (baseX-0.10) < posX and posX < (baseX+0.05) and (baseY-0.10) < posY and posY < (baseY-0.08) then
				self.hirableToolsHUD.isMoving = true;
			end;
		end;
		
		if self.hirableToolsHUD.isActive and isDown and button == 1 then
			if self.allowTrackCount then
				if (baseX+0.09) < posX and (baseX+0.115) > posX and (baseY-0.02) > posY and (baseY-0.05) < posY then 
					self:setHirableToolsSettings(math.min(self.trackCount + 1, 3), self.headLand);
				end;
				if (baseX+0.12) < posX and (baseX+0.145) > posX and (baseY-0.02) > posY and (baseY-0.05) < posY then
					self:setHirableToolsSettings(math.max(1, self.trackCount - 1), self.headLand);
				end;
			end;
			
			if self.allowHeadLand then
				if (baseX+0.09) < posX and (baseX+0.115) > posX and (baseY-0.05) > posY and (baseY-0.08) < posY then
					self:setHirableToolsSettings(self.trackCount, math.min(40, self.headLand + 1));
				end;
				if (baseX+0.12) < posX and (baseX+0.145) > posX and (baseY-0.05) > posY and (baseY-0.08) < posY then
					self:setHirableToolsSettings(self.trackCount, math.max(0, self.headLand - 1));
				end;
			end;
		end;
	end;
end;

function HirableTools:keyEvent(unicode, sym, modifier, isDown)
end;

function HirableTools:onLeave()
	if g_gui.currentGui == nil then
		InputBinding.setShowMouseCursor(false);
	end;
	self.hirableToolsHUD.isMoving = false;
end;

function HirableTools:onEnter()
	if self.hirableToolsHUD.isActive then
		InputBinding.setShowMouseCursor(true);
	end;
end;

function HirableTools:update(dt)
	if self:getIsActiveForInput(false) then
		if InputBinding.hasEvent(InputBinding.HELFERTOOLS_HUD) then
			local state = self.hirableToolsHUD.isActive;
			state = not state;
			if not self.hirableToolsAllowed then
				state = false;
			end;
			InputBinding.setShowMouseCursor(state);
			self.hirableToolsHUD.isActive = state;
		end;
		if self.checkMouseActive then
			self.checkMouseActive = false;
			InputBinding.setShowMouseCursor(self.hirableToolsHUD.isActive);
		end;
	end;		
end;

function HirableTools:updateTick(dt)
	if self.turnStageBackup ~= self.turnStage then
		self:setTurnstageAtHeadLand();
	end;
	self.turnStageBackup = self.turnStage;
	
	if self.cameras ~= nil and self.cameras[self.camIndex] ~= nil then
		self.cameras[self.camIndex].isActivated = not self.hirableToolsHUD.isActive;
	end;
	
	if not self:getIsActiveForInput(false) and self.hirableToolsHUD.isActive then
		self.checkMouseActive = true;
	end;
	
	if self.hirableToolsBackup ~= nil then
		self:setHirableToolsSettings(self.hirableToolsBackup[1], self.hirableToolsBackup[2], true);
		self.hirableToolsBackup = nil;
	end;
end;

function HirableTools:draw()

	if self.hirableToolsHUD.isActive and self:getIsActiveForInput(false) and self.hirableToolsAllowed then		
		-- overlay
		renderOverlay(self.hirableToolsHUD.overlay, (self.hirableToolsHUD.baseX-0.10), (self.hirableToolsHUD.baseY-0.105), 0.26, 0.12);
		
		-- headline
		setTextBold(true);
		renderText((self.hirableToolsHUD.baseX-0.10), (self.hirableToolsHUD.baseY-0.01), 0.025, g_currentMission.hirableTools.texts.hirableToolsHUD);
		setTextBold(false);
		
		-- headLand
		if self.allowHeadLand then
			renderOverlay(self.hirableToolsHUD.plus, (self.hirableToolsHUD.baseX+0.09), (self.hirableToolsHUD.baseY-0.075), 0.025, 0.025);
			renderOverlay(self.hirableToolsHUD.minus, (self.hirableToolsHUD.baseX+0.12), (self.hirableToolsHUD.baseY-0.075), 0.025, 0.025);
			renderText((self.hirableToolsHUD.baseX-0.10), (self.hirableToolsHUD.baseY-0.07), 0.025, g_currentMission.hirableTools.texts.headLand.." "..tostring(self.headLand).." m");
		else
			renderText(self.hirableToolsHUD.baseX-0.10, self.hirableToolsHUD.baseY-0.07, 0.025, g_currentMission.hirableTools.texts.headLand.." "..g_currentMission.hirableTools.texts.impossible);
		end;
		
		-- trackCount
		if self.allowTrackCount then
			renderText(self.hirableToolsHUD.baseX-0.10, self.hirableToolsHUD.baseY-0.04, 0.025, g_currentMission.hirableTools.texts.trackCount.." "..tostring(self.trackCount));
			renderOverlay(self.hirableToolsHUD.plus, (self.hirableToolsHUD.baseX+0.09), (self.hirableToolsHUD.baseY-0.045), 0.025, 0.025);
			renderOverlay(self.hirableToolsHUD.minus, (self.hirableToolsHUD.baseX+0.12), (self.hirableToolsHUD.baseY-0.045), 0.025, 0.025);
		else
			renderText(self.hirableToolsHUD.baseX-0.10, self.hirableToolsHUD.baseY-0.04, 0.025, g_currentMission.hirableTools.texts.trackCount.." "..g_currentMission.hirableTools.texts.impossible);
		end;
		
		-- move window
		renderText((self.hirableToolsHUD.baseX-0.10), (self.hirableToolsHUD.baseY-0.10), 0.025, g_currentMission.hirableTools.texts.moveHUD);
	elseif self.hirableToolsAllowed then
		g_currentMission:addHelpButtonText(g_currentMission.hirableTools.texts.activateHUD, InputBinding.HELFERTOOLS_HUD); 
	end;
end;

function HirableTools:attachImplementFix(oldFunc, object, jointDescIndex, noEventSend, index, startLowered)
	oldFunc(self, object, jointDescIndex, noEventSend, index, startLowered);

	local allowed = false;
	local trackCountAllowed = false;
	for k, v in pairs(self.attachedImplements) do 
		if v.object ~= nil and v.object.hirableToolsReady ~= nil and v.object.hirableToolsReady then
			allowed = true;
			if v.object.allowTrackCountImplement ~= nil and v.object.allowTrackCountImplement then
				trackCountAllowed = true;
			end;
		end;
	end;
	if self.hirableToolsReady then
		allowed = true;
		print("");
	end;
	if self.allowTrackCountImplement ~= nil and self.allowTrackCountImplement then
		trackCountAllowed = true;
	end;
	
	self.hirableToolsAllowed = allowed;
	self.allowTrackCount = trackCountAllowed;
end;

function HirableTools:detachImplementFix(oldFunc, implementIndex, noEventSend) 
	oldFunc(self, implementIndex, noEventSend);
	
	local allowed = false;
	local trackCountAllowed = false;
	for k, v in pairs(self.attachedImplements) do 
		if v.object ~= nil and v.object.hirableToolsReady ~= nil and v.object.hirableToolsReady then
			allowed = true;
			if v.object.allowTrackCountImplement ~= nil and v.object.allowTrackCountImplement then
				trackCountAllowed = true;
			end;
		end;
	end;
	if self.hirableToolsReady then
		allowed = true;
	end;
	if self.allowTrackCountImplement ~= nil and self.allowTrackCountImplement then
		trackCountAllowed = true;
	end;
	
	self.hirableToolsAllowed = allowed;
	self.allowTrackCount = trackCountAllowed;
end;

-- Events

SetHirableToolsSettingsEvent = {};
SetHirableToolsSettingsEvent_mt = Class(SetHirableToolsSettingsEvent, Event);
InitEventClass(SetHirableToolsSettingsEvent, "SetHirableToolsSettingsEvent");
function SetHirableToolsSettingsEvent:emptyNew()
    local self = Event:new(SetHirableToolsSettingsEvent_mt);
    self.className="SetHirableToolsSettingsEvent";
    return self;
end;

function SetHirableToolsSettingsEvent:new(object, trackCount, headLand)
    local self = SetHirableToolsSettingsEvent:emptyNew(); 
    self.object = object; 
	self.trackCount = trackCount;
	self.headLand = headLand;
    return self;
end;

function SetHirableToolsSettingsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.trackCount);
	streamWriteInt8(streamId, self.headLand);
end;

function SetHirableToolsSettingsEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.trackCount = streamReadInt8(streamId);
	self.headLand = streamReadInt8(streamId);
    self:run(connection);
end;

function SetHirableToolsSettingsEvent:run(connection)
	self.object:setHirableToolsSettings(self.trackCount, self.headLand, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetHirableToolsSettingsEvent:new(self.object, self.trackCount, self.headLand), nil, connection, self.object);
	end; 
end;

function SetHirableToolsSettingsEvent.sendEvent(object, trackCount, headLand, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(SetHirableToolsSettingsEvent:new(object, trackCount, headLand), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(SetHirableToolsSettingsEvent:new(object, trackCount, headLand)); 
		end;
	end;
end;