﻿# История версий Duplicate Files Search & Link (ранее программа называлась Duplicate & Same Files Searcher).

## Версия 10.3.0 от 03.12.2023
- Улучшена производительность, исправлено несколько мелких ошибок.
- Добавлена поддержка .NET 8.0.

## Версия 10.2.3 от 06.05.2023
- Исправлена ошибка - лаунчер не запускает портируемую версию 10.2.2.

## Версия 10.2.2 от 30.04.2023
 - Исправлено несколько найденных мелких проблем в пользовательском интерфейсе.
 - Исправлена проблема с запуском версии .NET 7.0 под Windows 7 в режиме администратора (переменные среды, установленные для обхода проблемы с выделением памяти для процесса .NET 7.0, не передавались при запуске в режиме администратора).

## Версия 10.2.1 от 02.04.2023
 - Исправлена ошибка из-за которой иногда игнорируются дубликаты файлов.
 - Исправлена ошибка отображения некоторых символических ссылок.
 - Команда "Отметить все файлы в '[выбранной папке]' и подпапках" теперь будет основной в контекстном меню вместо  "Отметить все файлы в '[выбранной папке]'".

## Версия 10.2.0 от 28.03.2023
 - Улучшена производительность на старых процессорах, уменьшена нагрузка на процессор при сканировании.
 - Исправлена проблема с производительностью при сравнении нескольких тысяч файлов одинакового размера, скорость сравнения выросла в несколько раз.
 - Исправлены недочёты в пользовательском интерфейсе.
 - Исправлена и улучшена навигация клавишами клавиатуры по таблице одинаковых файлов, также добавлена поддержка сочетаний клавиш Ctrl-Up/Ctrl-Down для перемещений между группами файлов. - Отмеченные каталоги теперь сохраняются индивидуально для каждого профиля.

## Версия 10.1.4 от 27.02.2023
 - Исправлено: сообщение о том что версия 10.1.3 доступна для загрузки отображается для установленной версии 10.1.3.

## Версия 10.1.3 от 24.02.2023
 - Исправлено: команда "Заменить файлы жёсткими ссылками" была доступна для файлов на дисках в с файловой системой FAT32.
 
## Версия 10.1.2 от 12.01.2023
 - Улучшена производительность.
 - Исправлена сортировка по размеру.
 - Заменён сертификат подписывания кода. Предыдущий был проверочный и больше не действителен.

## Версия 10.1.1 от 03.01.2023
 - Установщик, все *.exe и *.dll теперь подписаны доверенным сертификатом подписи кода. Поэтому больше нет предупреждений о «неизвестном издателе» и уменьшена вероятность ложных срабатываний при запуске Duplicate Searcher.
 - Проверка совместимости прав доступа файлов при замене файлов на жесткие ссылки теперь доступна без запуска от имени администратора.

## Версия 10.1.0 от 01.01.2023
 - Добавлена новая колонка "Расширение" с возможностью сортировки и фильтрации.
 - Исправлено несколько незначительных ошибок.

## Версия 10.0.5 от 19.12.2022
 - Исправлено: элементы главного меню не помещались в окно и скрывались при уменьшении ширины окна или при выборе в настройках среднего и больших шрифтов.
 - Исправлено: некорректное отображение панели фильтров.

## Версия 10.0.4 от 12.12.2022
 - В программе запуска реализован патч для обхода проблемы с выделение большого количества памяти сборкой .NET 7.0 на 64-битный Windows 7, задающий переменным окружения значения, отключающие новые технологии, которые вызывают проблемы на 64-битный Windows 7. Теперь Duplicate Searcher должен без проблем работать на 64-битный Windows 7 с установленной .NET 7.0.
	К сожалению Microsoft отказались поддерживать и исправлять ошибки .NET 7.0 в Windows 7, поэтому принимайте решение об использовании .NET 7.0 с 64-битный Windows 7 с учётом отсутствия поддержки, исправлений при наличии описанной мной проблемы.
 - В программу запуска добавлены дополнительные проверки установленных компонентов в Windows 7 и Windows 8/8.1.

## Версия 10.0.3 от 09.12.2022
 - Проблема с выделение большого количества памяти сборкой .NET 7.0 не проявляется в 32-битный режиме на Windows 7, поэтому запуск 32-битной сборки  DuplicateSearcherNet7.x86.exe для .NET 7.0 на 32- и 64-битной Windows 7 включен без ограничений.
 - Исправлено небольшое замедление при сравнении медиафайлов со включённой опцией "Игнорировать различие в метаданных..."

## Версия 10.0.2 от 08.12.2022
 - На Windows 7 сборка .NET 7.0 DuplicateSearcherNet7.x64.exe по невыясненным пока причинам выделяет очень много памяти сразу при запуске. 
	Просьба пользователям Windows 7 пользоваться исполняемыми файлами для .NET 6.0 (в папке net6.0) или .NET Framework 4.7.2 (в папке netfx). Они тоже работают быстро.
 - Исправлен баг в лаунчере DuplicateSearcher.Launcher.exe, который не находил файл DuplicateSearcherNetFramework.exe у пользователей, у которых не установлен .NET 6.0 или .NET 7.0.

## Версия 10.0 от 07.12.2022
 - Добавлена поддержка .NET 7.0.
 - Ещё немного улучшена производительность.
 - Исправлена пара незначительных ошибок.
 - Добавлены автоматические профили для файлов аудио, видео и изображений.
 - Добавлено простое окно для просмотра метаданных медиафайлов по щелчку мыши.
 - Улучшена реакция на изменение найденных файлов сторонними программи - теперь Duplicate Files Search & Link автоматически перепроверит хэши, и если хэши не изменились, оставит файлы в таблице. Это позволяет редактировать тэги и метаданные медиафайлов в сторонних программах, при этом изменённые файлы не пропадают из таблицы одинаковых файлов. 
 - Возвращена возможность выбирать файлы для жёстких ссылок для сетевых дисков с назначенной буквой диска, отформатированных в файловую систему Linux EXT2,3,5. В версии 9.0 не на всех устройствах была возможность выбирать и создавать жёсткие ссылки, так как не все NAS-устройства корректно сообщают Windows о поддержке жёстких ссылок.
 - Изменена структура каталогов в папке программы для разделения исполняемых и dll-файлов для платформ .NET Framework 4.7.2, .NET 6.0 и .NET 7.0.
 Лучше распакуйте новую версию в отдельную новую папку, чтобы не смешивать со старыми файлами.

====

## Версия 9.0.5 от 26.10.2022
 - Исправлена ошибка - неотработанное исключение, если файл IncompressibleFiles.txt не найден в папке программы.

## Версия 9.0.4 от 26.10.2022
 - Исправлено несколько ошибок, вызывавших неотработанные исключения.
 - Исправлена проблема в DuplicateSearcherNetFramework.exe для .Net Framework: ключевые файлы не загружались, несколько элементов меню отсутствовали.

## Версия 9.0.3 от 18.09.2022
 - Исправлена проблема - программа выдаёт ошибку и не работает корректно, если на свежей системе не был установлен .NET Framework 2.0/3.5. Зависимость от .NET Framework 2.0/3.5 убрана.

## Версия 9.0.2 от 11.09.2022
 - Исправлено несколько мелких недочётов в пользовательском интерфейсе.
 - Реализована возможность выделять и отмечать группу файлов целчком мышки + Shift.

## Версия 9.0.1 от 07.09.2022
 - Обновление языковых файлов польского и китайского языков.
 - Исправлена проблема с автообновлением языковых файлов.

## Версия 9.0.0 от 05.09.2022
 - Новые команды выбора, позволяющие сразу выбирать целевые файлы для жёстких ссылок без предварительного выделения файлов, которые должны быть заменены жёсткими ссылками, и последующего снятия выделения с целей для ссылок.
 - Добавлена поддержка простого скриптового языка, позволяющего выполнять сценарии выделения файлов, удаления или замены жёсткими ссылками, в том числе из командной строки.
 - Добавлена возможность дополнительной группировки файлов по диску, папке и имени файлов.
 - Добавлена поддержка замены символических ссылок на жёсткие.
 - Реализован автоматический выбор нового файла для жёстких ссылок при замене более 1023 файлов жёсткими ссылками (ограничение файловой сиcтемы NTFS 1024 ссылки на файл).  
 - Добавлена возможность продолжения поиска с новыми настройками и пополнения списка найденных дубликатов файлами, найденными с новыми настройками.
 - Увеличена скорость сравнения файлов в разных сценариях. 
 - При запуске .NET 6.0-версии программа также теперь автоматически получит дополнительный прирост скорости на современных процессорах, поддерживающих AVX и аппаратное ускорение SHA256.
 - Также решены проблемы с производительностью на некоторых сценариях поиска при большом количестве найденных файлов.
 - Добавлена возможность вручную помечать диски как твердотельные (SSD), чтобы кратно ускорить поиск на смонтированных виртуальных дисках, томах VeraCrypt и т.п., физически расположенных на SSD.
 - Добавлена поддержка работы с жёсткими и символическими ссылками на файловой системе ReFS (в теории, на практике не проверял, кто проверит - напишите о результатах).
 - Добавлено информирование системы о нежелательности автоматического перехода в спящий режим во время длительного сканирования при неактивности пользователя.  

====

## Версия 8.0.10 от 05.08.2022
 - Исправлено падение программы при сравнении определённого сочетания множества небольших файлов.

## Версия 8.0.9 от 08.05.2022
 - Исправлено несколько незначительных ошибок.
 - Добавлена поддержка путей к папкам для сканирования, передаваемых через командную строку, с разделителем '/' в стиле Юникса (например, "e:/Photo/Photo" вместо "e:\Photo\Photo").
 - Добавлен новый файл DuplicateSearcher.Launcher.exe для автоматического запуска наиболее подходящей версии в зависимости от установленной версии среды .NET (6.0, 5.0 или 4.8) и архитектуры системы (32 или 64 бит). 
Я рекомендую установить последнюю версию .NET 6.0 для наилучшей производительности и стабильности (https://dotnet.microsoft.com/en-us/download/dotnet/6.0/runtime).

## Версия 8.0.8 от 05.12.2021
 - Несколько снижена загрузка процессора и улучшена производительность при многопоточном сравнении файлов на SSD в некоторых сценариях.
 - Исправлена незначительная ошибка, вызывавшая сообщение об ошибке в некоторых системах.

## Версия 8.0.7 от 01.12.2021
 - Исправлена незначительная ошибка.
 - Добавлена портируемая сборка для новой платформы .NET 6.0 (загружайте отдельно с моего сайта).

## Версия 8.0.6 от 27.10.2021
 - Исправлено отсутствие перевода пунктов меню c многоточием в конце.

## Версия 8.0.5 от 27.10.2021
 - Исправлена ошибка System.BadImageFormatException при запуске программы на некоторых системах.

## Версия 8.0.4 от 24.10.2021
 - Значительно улучшена производительность при сравнении тысяч небольших файлов одинакового размера.
 - Решена проблема с неправильным масштабированием окна в .NET 5-версии (DuplicateSearcherCore.exe) при выборе в Windows 10 масштаба текста 150% и выше.
 - Решена проблема с долговременным "зависанием" интерфейса после переноса на другой диск очень большого количества файлов.
 - Добавлена 32-битная версия DuplicateSearcherCore.x86.exe для платформы .NET 5, для запуска в 32-битных версиях Windows 7, Windows 8.1, Windows 10. 

## Версия 8.0.3 от 23.04.2021
 - Исправлена ошибка - одинаковые видеофайлы размером более 2 ГБ не находились при включенной опции "Частичное сравнение больших видеофайлов".
 - Незначительные улучшения и исправления.

## Версия 8.0.2 от 17.04.2021
 - Решена проблема с "зависаниями" интерфейса на продолжительное врeмя при запуске операции удаления большого количества файлов.
 - Исправлен некорректный поиск в DuplicateSearcherCore.exe (для .NET 5), связанный с некорректной реализацией некоторых функций в .NET 5.
 - Реализована единообразная сортировка файлов в версиях DuplicateSearcher.exe (для .NET 4.7.2+) и DuplicateSearcherCore.exe (для .NET 5).

## Версия 8.0.1 от 11.04.2021
 - Добавлена новая опция "Частичное сравнение больших видеофайлов", при включении которой большие видеофайлы (размером от 250 МБ) сравниваются частично в разных частях (~4 МБ каждые 100 МБ). 
Эта опция позволяет очень быстро оценить, являются ли видеофайлы скорее всего одинаковыми. 
 - Добавлены приблизительная оценка и отображение времени, оставшегося до завершения сканирования (и других длительных операций).
 - Добавлен новый столбец "Файлы", позволяющий сортировать группы по количеству файлов в них.
 - Добавлено контекстное меню, открываемое щелчком правой кнопкой мыши на заголовке таблицы, позволяющее скрывать ненужные столбцы. 
 - Переработано диалоговое окно команды "Выделение по фильтру", упрощён выбор, добавлена операция инвертирования выделения. 
 - Исправлен ряд найденных ошибок.
 - Процесс сканирования теперь использует меньше памяти.
 - Скорость сканирования увеличена на несколько процентов.
 - Возвращена версия DuplicateSearcherCore.exe, собранная для платформы .NET 5. Для её корректной работы необходимо обновить .NET Desktop Runtime до версии не ниже 5.0.4. Пожалуйста, дайте знать, если столкнётесь с какими-то новыми проблемами при использовании DuplicateSearcherCore.exe для .NET 5.0.
 - Если программа оказалась полезна для вас, то, пожалуйста, не забывайте благодарить, чтобы поддерживать мою мотивацию к дальнейшей разработке.

====

## Версия 7.0.7 от 14.01.2021
 - Исправлены найденные проблемы.
 - Исправлена ошибка, иногда приводившая к невозможности прочитать ранее сохранённые файлы результатов поиска при определённом сочетании факторов.
 - Приложение DuplicateSearcherCore.exe для платформы .NET 5.0, добавленное с версией 7.0.6, временно исключено из пакета в связи с найденной ошибкой, приводящей к утечке GDI-ресурсов в некоторых функциях, что вызывает ошибку "A generic error occurred in GDI+" при прокрутке результатов поиска.

## Версия 7.0.6 от 20.12.2020
 - Исправлены мелкие ошибки.
 - Пользователи портируемой версии могут попробовать новую сборку DuplicateSearcherCore.exe, адаптированную и построенную для новейшей платформы .NET Desktop Runtime 5.0.
Платформа .NET 5.0 имеет много оптимизаций производительности, поэтому DuplicateSearcherCore.exe должен работать быстрее стандартной сборки для .NET Framework 4.7.2.
Для запуска DuplicateSearcherCore.exe для NET 5.0 вам потребуется самостоятельно загрузить и установить .NET Desktop Runtime 5.0:
https://dotnet.microsoft.com/download/dotnet-core/5.0/runtime/ 
Инсталлятор также будет копировать исполняемый файл DuplicateSearcherCore.exe для .NET 5.0 в папку программы, но для него не будет создаваться ярлык, и он пока не будет запускаться автоматически.
Продвинутые пользователи моей программы могут создать для него ярлык и запускать самостоятельно, установив .NET Desktop Runtime 5.0.
В будущих версиях я планирую добавить лаунчер для автоматического запуска версий для .NET 5+, если эта платформа уже установлена на компьютере.
В будущем платформа .NET 5+ станет основной при разработке новых версий программы.
 - Обновлен файл перевода на русской язык. 

## Версия 7.0.5 от 23.10.2020
 - Исправлено: отсутствующие иконки каталогов и тормоза при прокрутке после повторного поиска.

## Версия 7.0.4 от 21.09.2020
 - Исправлено: ошибки GDI+, приводившие к падению программы после сканировании большого количества файлов, вызванные ограничениями Windows на количество иконок файлов, одновременно созданных в памяти.
 - Исправлено: исключение "Недостаточно памяти для продолжения выполнения программы" при переполнении панели списка ошибок. Количество строк в списке ограничено 1000.
 - Добавлен вывод в список ошибок информации о символьных ссылках, указывающих на несуществующий файл.

## Версия 7.0.3 от 08.09.2020
 - Улучшено определение симлинков. Предыдущие версии игнорировали симлинки на отдельные файлы без дубликатов.

## Версия 7.0.2 от 07.09.2020
 - Исправлено: журнал выполненных операций не открывался.

## Версия 7.0.1 от 06.09.2020
 - Добавлен список выбранных путей для поиска дубликатов под деревом каталогов в окне диалога выбора папок для поиска. Теперь всех путей для поиска хорошо виден перед сканированием. Также добавлены новые отдельные кнопки панели инструментов "Снять отметки со всех" и "Отметить все" для быстрой очистки/выделения всех папок.
 - Добавлен пропущенный перевод на русский для двух кнопок в фильтрах.

## Версия 7.0.0 от 27.07.202
 - Добавлена поддержка поиска файлов видео, аудио и изображений (только jpg) с одинаковым двоичным медиаконтентом, но различающимися метаданными или медиатэгами.
 - Добавлена поддержка запуска внешних командных файлов или утилит (например Beyond Compare) для выделенных файлов.
 - Добавлена новая команда "Копировать выбранные строки в буфер обмена в формате .csv".

====

## Версия 6.0.3 от 09.06.2020
 - Увеличена производительность в некоторых сценария.
 - Исправлено: дата-время изменения файлов теперь отображается как местное время. В предыдущих версия время отображалось как UTC (Всемирное координированное время).
 - Исправлено неработающее автообновление в портируемой версии. Автообновление с новой версии на последующие в портируемой версии должно теперь работать корректно (хотелось бы в это верить :)).

## Версия 6.0.2 от 06.06.2020
 - Исправлена ошибка, приводившая к нахождению ложных дубликатов при сравнении mp3-файлов, если включена опция "Игнорировать различия в ID3-тэгах MP3-файлов".

## Версия 6.0.1 от 05.06.2020
 - Исправлена ошибка, блокировавшая создание символьных ссылок на файлы, расположенные на других дисках.

## Версия 6.0.0 от 03.06.2020
 - В этой версии значительно увеличена производительность:
 - Добавлена поддержка параллельного сканирования и сравнения файлов на физически независимых дисках (файлы на нескольких внешних дисках могут сравниваться параллельно с учётом разграничения доступа). Это кратно повышает скорость сравнения файлов в таких сценариях.
Тома в дереве каталогов теперь группируются по физическим устройствам.
 - Добавлена поддержка многопоточного сканирования и сравнения файлов на твёрдотельных дисках (SSD). По моим тестам, поиск дубликатов в 4 потока на SSD-дисках с интерфейсом SATA повышает производительность более чем в 3 раза. На дисках с интерфейсом NVMe ускорение должно быть ещё больше. SSD-носители распознаются автоматически. 
 - Добавлена поддержка жёстких и символьных ccылок в файловых системах EXT2/EXT3/EXT4 (тестировалось только с драйвером Ext2Fsd для Windows https://www.ext2fsd.com/ ). Если вдруг будет работать с другими драйверами EXT2 для Windows - дайте знать :).
 - Добавлена поддержка поиска дубликатов в ZIP-архивах вместе с файлами на диске. Никакие операции с файлами в ZIP-архивах при этом совершать нельзя. Для поиска в ZIP-архиве его нужно добавить в узел "Архивы" в дереве каталогов.
 - Добавлена возможность назначения собственных "горячих" клавиш для всех операций.
 - Добавлена возможность переноса файлов вместе со структурой подкаталогов, в которых они находятся. 
 - Некоторые мелкие исправления и улучшения.
 - В Windows XP работать не будет. Версия 6.0 построена для платформы исполнения .Net Framework 4.7.2+, которая не поддерживается в Windows XP, увы.

====

## Версия 5.2.7 от 25.04.2020
 - Исправлена ошибка, приводившая к обращению к нулевой ссылке в диалоге переноса файлов.
 - Исправлена ошибка, приводивщая к созданию лишнего каталога Settings при обновлении установленной версии через функцию автоматического обновления.

## Версия 5.2.6 от 23.03.2020
 - Добавлен автоматический пропуск файлов в папке OneDrive, которые физически не находятся на локальном компьютере (файлы в облаке).
Файлы в облаке по умолчанию будут исключены из поиска, но если вы хотите включить облачные файлы в поиск дубликатов и позволить OneDrive автоматически подгружать их на компьютер для сравнения, вы можете установить SkipFilesInCloud="0" в настройках профиля поиска в файле settings.xml.
Это пока техническое исправление. Отдельная галочка в окне настроек будет добавлена в одной из следующих версий.

## Версия 5.2.5 от 28.02.2020
 - Исправлена незначительная ошибка.

## Версия 5.2.4 от 16.02.2020
 - Исправлены падения на некоторых конфигурациях, вызванные попыткой использования несуществующих шрифтов.
 - Исправлены проблемы с отображением текстов при выбранном среднем или большом размере шрифта.
 - Исправлены падения на некоторых конфигурациях по отчётам, присланным пользователями. 
 - Добавлен ключ для некоммерческого использования без истечения срока действия.  

## Версия 5.2.3 от 06.11.2019
 - Испралено несколько мелких ошибок, улучшена стабильность.

## Версия 5.2.2 от 17.10.2019
 - Исправлена проблема специфическая для Windows 10 - отображаемый нулевой размер на диске для некоторый системных файлов в папке WindowsApps.

## Версия 5.2.1 от 08.10.2019
 - Исправлено несколько проблем, приводившим к падениям программы.

## Версия 5.2 от 01.09.2019
 - На боковой панели добавлена новая кнопка "Показать только группы, содержащие выбранные файлы", позволяющая увидеть только то, что выделено.
 - Добавлено отображение текущей скорости чтения диска в процессе сравнения файлов.
 - Устранена пара необработанных исключений при ошибках, которые могли приводить к падениям.
 - Незначительное улучшение производительности.

## Версия 5.1.9.1 от 14.08.2019
 - Обновлен перевод на польский язык.

## Версия 5.1.9 от 13.08.2019
 - Исправлено падение программы при сканирование сетевых папок.
 - Исправлено падение программы при сканирование mp3-файлов с неформатными ID3v2 тэгами с включенной опцией "Игнорировать различия в ID3-тэгах MP3-файлов".
 - Исправлена (я надеюсь) ошибка программы при попытке открытия системного диалога сохранения файлов на некоторых системах с какой-то повреждённой конфигурацией.
 - Добавлена возможность отмечать и снимать отметки с файлов от родительских папок выбранного файла.
 - Ширина и порядок колонок теперь сохраняется между сканированиями и перезапусками программы.

## Версия 5.1.7 от 09.08.2019
 - Исправлена еще одна критическая ошибка: приложение зависает, когда пользователь нажимает кнопку "Начать поиск" , если предыдущий поиск был в сетевых папках.

## Версия 5.1.6 от 08.08.2019
 - Исправлено несколько ошибок, приводивших к падению приложения.
Спасибо тем, кто отправлял сообщения об ошибках!
 - Исправлена функция "Игнорировать различия в ID3-тэгах MP3-файлов". Теперь она находит гораздо больше MP3-файлов с различиями только в тегах ID3.

## Версия 5.1.5 от 23.07.2019
 - Найдены и исправлены две причины, приводившие к редким падениям программы в некоторых ситуациях. 
Одна из причин связана с багом в .Net Framework.
Спасибо тем, кто отправлял отчеты!
 - Эта версия должна ещё работать на Windows XP.

## Версия 5.1.4 от 15.07.2019
 - Исправлен баг: операция "Переместить файлы..." не работала.
 - Настройки поиска сохраняются теперь, даже если диалог поиска закрывается нажатием на кнопку Отмена или Esc.
 - DLL-файлы перепакованы в один .exe для для уменьшения количества файлов в портируемой версии .

## Версия 5.1.3 от 10.06.2019
 - Уменьшена загрузка процессора в некоторых конфигурациях при сканировании большого количества файлов.
 - Исправлен баг: падение программы, если ранее добавленный сетевой путь больше не доступен.
 - Исправлен баг: ограничение количества создаваемых симлинков у зарегистрированных пользователей.
 - Иправлены перепутанные строки в файле русского и белорусского языков.

## Версия 5.1.2 от 21.04.2019
 - Исправлена ошибка поиска в сетевых папках

## Версия 5.1.1 от 08.04.2019
 - Исправлен сброс статистики совобожденного места при некоторых операциях.
 - Внимание пользователям Windows XP: эта версия вероятно будет последняя, откомпилированная под .NET 4.0 и поддерживающая Windows XP.
  Я планирую строить новые версии с поддержкой новых технологий и возможностей .NET 4.6.2+ (и .NET Core 3.0), которые не поддерживаются в WinXP.
  Но в случае нахождения критических ошибок в этой версии для неё будут сделаны исправления с поддержкой .NET 4.0.

## Версия 5.1.0 от 02.04.2019
 - Исправлен баг по невозможности фильтрации файлов из списка по имени, появившийся в последней версии.
 - Исправлено несколько мелких багов.
 - Добавлена возможность сортировки внутри групп по именам файлов, папок, количеству фрагментов, жёстких ссылок и дате изменения файлов.
 - Добавлен вывод расширенной статистики по найденным дубликатам, по освобождённому месту на диске и количеству удалённых и заменённых ссылками файлов.
 - Добавлена возможность задавать пути для поиска файлов в виде списка строк.
 - Добавлена возможность копировать в буфер обмена пути к папкам файлов.
 - Увеличена скорость отрисовки списка файлов.

## Версия 5.0.3 от 15.02.2019
 - Заплатка: исправено падение программы при текстовом поиске имен файлов через "Найти в списке…"

## Версия 5.0.1 от 01.12.2018
 - Добавлен перевод на белорусский язык.
 - Исправлена подсказка на английском.

## Версия 5.0 от 18.11.2018
 - Добавлена поддержка символьных ссылок на файлы (поиск, отображение и создание).
 - Исправлено несколько найденных ошибок и недочетов.
 - Ряд улучшений производительности. В некоторых сложных сценариях (при сравнении большого количества файлов одинакового размера) скорость поиска и сравнения может быть выше в несколько раз.

====

## Версия 4.3 от 29.04.2016
 - Исправлен баг - поиск перестал работать на 32-битных версиях Windows.

## Версия 4.2 от 20.04.2016
 - Добавлена поддержка масок в фильтрах имён файлов и каталогов таблицы результатов. Можно задавать несколько масок одновременно, разделяя их символом '|' (или ';'),  к примеру'DSC*.JPG | IMG*.JPG'.
 - Добавлена опция для пропуска NTFS-сжатия для несжимаемых и плохо сжимаемых файлов, что уменьшает фрагментацию файлов и износ SSD-дисков.

## Версия 4.1.1 от 15.02.2016
 - Исправлена ошибка: автоматическая проверка наличия обновлений не работает в версиях 4.0 и 4.1.
 - Операция NTFS-сжатия теперь игнорирует файлы меньше 4 КБ.
 - Исправлено падение программы, проявлявшееся у некоторых пользователей.

## Версия 4.1.0 от 05.02.2016
 - Значительно увеличена производительность при сравнении существующих жестких ссылок.
 - Добавлена интеграция в контекстное меню Проводника Windows (только при установке через инсталлятор). Поиск дубликатов теперь может быть запущен из контекстного меню при выборе папки или диска в Проводнике Windows.
 - Добавлена поддержка командной строки для поиска дубликатов.
Опции командной строки:
	-s "Path1;[Path2;][Path3;]": поиск дубликатов в папках, пути к которым разделены символом ';'
		Например: DuplicateSearcer.exe -s "D:\Photos1;D:\Photos2;"
	-profile "<ProfileName>": имя существующего профиля настроек для поиска. Если опция опущена или профиль с данным именем еще не существует, 
		для поиска из командной строки используются настройки профиля по умолчанию "Default".
		Например: DuplicateSearcer.exe -s "D:\Photos1;D:\Photos2;" -profile "Photos".
	
## Версия 4.0.0 от 15.12.2015
 - Построена на платформе Microsoft .NET Framework 4, что улучшает производительность и снимает необходимость в установке .NET Framework 3.5 для работы программы на и Win 8.1 и Win 10.
 - Добавлена поддержка пользовательских профайлов для поиска файлов по различным критериям.
 - Добавлена поддержка фильтрации результатов поиска по различным критериям.
 - Исправлено несколько найденных мелких багов.
 - Портируемая версия теперь сохраняет настройки в локальном подкаталоге программы.
 - "Запуск от имени администратора" отключен по умолчанию.

====

## Версия 3.0.2 от 17.06.2015
 - Обновлен файл лицензии.

## Версия 3.0.1 от 01.03.2015
 - Исправлено несколько мелких багов пользовательского интерфейса.
 - Добавлено несколько новых команд выделения файлов.

## Версия 3.0.0 от 12.01.2015
 - Исправлено несколько мелких ошибок.
 - Добавлен предпросмотр картинок и фотографий в подсказках при наведении курсора.
 - Добавлено отображение расширенных свойств медиафайлов (поддерживаются не все форматы).
 - Добавлено несколько новых команд выделения файлов.

## Версия 2.2.6 от 20.05.2014
 - Добавлена новая опция поиска "Искать только дубликаты с одинаковыми именами".
 - Исправлена ошибка: не работала операция "Переместить файлы в заданную папку".

## Версия 2.2.3 от 31.01.2014
 - Реализована возможность увеличивать размер шрифта программы.
 - Незначительное улучшение.

## Версия 2.2.1 от 19.10.2013
 - Исправлена ошибка: поиск файлов по маске не всегда работал корректно.

## Версия 2.2.0 от 01.10.2013
 - Добавлено журналирование успешно выполненных операций с файлами.
 - Добавлена опция удаления пустых каталогов после удаления файлов.

## Версия 2.1.3 от 27.07.2013
 - Исправлена ошибка, появляющаяся при раскрытии диска C: в окне выбора папок для сканирования. 
Приношу извинения тем, кто с ней столкнулся!	

## Версия 2.1.2 от 16.07.2013
 - Исправлена ошибка: программа не обновляла список файлов после операции удаления в корзину.
 - Добавлена проверка и отмена операции удаления, если все дубликаты файлов выбраны для удаления.

## Версия 2.1.1 от 26.06.2013
 - Небольшое обновление.

## Версия 2.1.0 от 06.03.2013
 - Добавлена поддержка добавления и выбора сетевых папок для поиска дубликатов.
 - Новый диалог с информацией об изменениях в новых версиях.
 - Исправлено аварийное закрытие программы, возникавшее на некоторых системах при вызове пункта меню "Отправить отзыв..." при установленной программе The Bat!.

## Версия 2.0.3 от 28.01.2013
 - Решена проблема производительности при открытии диалога "Несовместимые права доступа к файлу".
 - При обновлении информации о файлах при загрузке файла результатом теперь выводится окно статуса операции.
 - Размер найденных и выделенных файлов в статусной строке теперь отображается с учётом реально занимаемого на диске места.

## Версия 2.0.2 от 02.12.2012
 - Улучшена скорость обновления файлов при загрузке результатов.
 - Добавлена поддержка загрузки файлов результатов через командную строку и перетаскивание файлов мышью (Drag&Drop).

## Версия 2.0.1 от 25.11.2012
 - Добавлена поддержка длинных путей к файлам и папкам (длиннее стандартного ограничения в 260 символов).
 - Добавлена возможность сохранять и загружать результаты поиска.
 - Улучшена поддержка Windows 8.
 - Добавлена поддержка сравнения альтернативных потоков NTFS при сравнении файлов.
 - Ускорено сканирование и сравнение небольших файлов.
 - Добавлено несколько новых опций по выделению файлов.
 - Добавлены описания опций.
 - Добавлена проверка совместимости NTFS-прав доступа оригинального и целевого файлов при замене файлов жёсткими ссылками.
 - Добавлена экспериментальная опция по сравнению музыкального контента MP3-файлов с игнорированием различий в метаданных. Это позволяет находить MP3-файлы с одинаковым звуковым контентом, но различными ID3-тэгами.
 - Исправлены некоторые мелкие недочёты и ошибки.
 - Возможно добавлены новые. :)

====

## Версия 1.6.5.1 от 20.09.2010
 - Исправлено неправильное поведение элементов диалога "Выбор папки для сканирования" при изменении его размеров.

## Версия 1.6.5 от 19.09.2010
 - Исправлена ошибка: чекбокс "Скрыть файлы, путь к которым содержит символьную ссылку" некорректно работал в версии 1.6.4.

## Версия 1.6.4 от 24.08.2010
 - Исправлено несколько мелких багов.

## Версия 1.6.3 от 06.02.2010
 - Исправлена небольшая ошибка: опция "Автоматически проверять наличие обновлений" не запоминалась при перезапуске программы.
 - Добавлен запрос прав администратора на системах Windows Vista и Windows 7.

## Версия 1.6.2 от 01.12.2009
 - Исправлена ошибка: программа повисает при нажатии на "Отметить все" в диалоге поиска в списке.
 - Добавлена поддержка расширений панели задач Windows 7.
 - Несколько мелких исправлений.

## Версия 1.6.1 от 16.11.2009
 - Исправлена ошибка: при выборе файлов из диалога поиска в списке не обновлялись ссылки в группах. 

## Версия 1.6 от 15.11.2009
 - Исправлено несколько мелких багов.
 - Добавлены новые команды:
	- "Исключить отмеченные файлы из списка",
	- "Отметить все файлы в этой папке",
	- "Снять отметки со всех файлов в этой папке",
	- "Найти в списке".
 - Добавлены кнопки, позволяющие скрывать оптические, съёмные и сетевые диски в дереве папок.

## Версия 1.5.1 от 25.10.2009
 - Исправлено: команды "Свернуть все" и "Раскрыть все" не работали в версии 1.5.

## Версия 1.5 от 10.10.2009
 - Исправлена проблема: программа не работала на 64-битной версии Windows.
 - Значительно уменьшено потребление памяти, и улучшена производительность при работе с большим количеством найденных файлов.
 - Добавлено: автоматическое обновление списка результатов при изменении/удалении файлов внешними приложениями.
 - Исправлено несколько мелких недочётов.
   
## Версия 1.4.3 от 02.07.2009 
 - Добавлены команды контекстного меню "Отметить все" и "Снять отметки со всех" к диалогу выбора папок для сканирования.
 - Добавлена новая команда "Снять отметки с других NTFS-ссылок, если хотя бы одна не отмечена". Эта команда позволяет снять выделение со всей группы NTFS-ссылок на файл для того, чтобы использовать этот файл для привязки к нему новых жёстких ссылок.
 - Исправлено: падение программы, когда юзер выбирает чекбокс "Спрятать группы без реальных дубликатов" и должен быть получен пустой список.
 - Улучшена скорость прокрутки списка результатов.
 
## Версия 1.4.2 от 04.05.2009
 - Исправлено несколько небольших ошибок, относящихся к интерфейсу.

## Версия 1.4.1 от 17.04.2009
 - Добавлены горячие клавиши для команд.
 - Добавлена новая опция поиска "Искать только NTFS-ссылки к файлам".

## Версия 1.4 от 08.03.2009
 - Добавлено: окно прогресса для отображения процесса удаления файлов, замены файлов жёсткими ссылками и отсоединения жёстких ссылок.
 - Добавлено: приложение теперь умеет автоматически проверять наличие обновлений.
 - Некоторые внутренние улучшения кода.

## Версия 1.3.1 от 10.01.2009
 - Добавлена возможность переименовывать файлы непосредственным редактированием имени в таблице результатов.
 - Приложение теперь автоматически сохраняет/восстанавливает положение главного окна при выгрузке/запуске.

## Версия 1.3 от 22.12.2008
 - Приложение было переименовано в "Duplicate and Same Files Searcher".
 - Добавлена возможность сжимать файлы на NTFS-томах.
 - Сжатые файлы на NTFS-томах теперь отображаются голубым цветом (как в проводнике).
 - "Размер на диске" теперь также отображается в столбце размера файлов.
 - Исправлена некорректная сортировка по имени в таблице результатов.

## Версия 1.2.1 от 13.11.2008
 - Добавлено: возможность выбора восходящего и нисходящего порядка сортировки файлов по размеру. 
 - Нисходящий по размеру порядок сортировки файлов теперь основной при сканировании и отображении результатов.

## Версия 1.2 от 21.10.2008
 - Добавлено: теперь пользователь может вводить маски "Искать" и "Исключить" при выборе настроек сканирования.
 - Добавлено: индикатор прогресса для отображения процесса сканирования.
 - Добавлено: новая операция "Отсоединение жёстких ссылок".
 - Добавлено: если заменяемые файлы используются другим процессом, то они будут удалены автоматически при следующей перезагрузке системы.
 - Исправлена проблема: операции над отмеченными файлами не производились, если группа файлов была свёрнута.
 - Исправлено несколько проблем с интерфейсом.
 - Исправлено несколько мелких внутренних багов.
 - Увеличена скорость работы.
 - Уменьшено потребление памяти.
 
## Версия 1.1 от 04.09.2008
 - Добавлено: новая опция поиска "Пропускать файлы, не занимающие места на диске (резидентные файлы)".
 - Добавлено: новая опция поиска "Пропускать каталоги-символьные ссылки".
 - Добавлено: опции поиска теперь сохраняются/восстанавливаются автоматически при выгрузке/запуске программы.
 - Добавлена возможность копировать пути к отмеченным файлам в буфер обмена.
 - Улучшена производительность заполнения таблицы результатов.

## Версия 1.0.1 от 10.03.2008
 - Первый релиз.
