/*
 * Decompiled with CFR 0.152.
 */
package clickme.animals.client.model;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;

public class ImageGenerator {
    private static final int WIDTH = 64;
    private static final int HEIGHT = 32;
    private List<Region> occupiedRegions = new ArrayList<Region>();

    private boolean isFree(Region region, int xo, int yo) {
        if (region.x1 + xo < 0) {
            return false;
        }
        if (region.y1 + yo < 0) {
            return false;
        }
        if (region.x2 + xo > 64) {
            return false;
        }
        if (region.y2 + yo > 32) {
            return false;
        }
        for (int i = 0; i < this.occupiedRegions.size(); ++i) {
            if (!this.occupiedRegions.get(i).overlaps(region, xo, yo)) continue;
            return false;
        }
        return true;
    }

    public void generateImage(List<ModelRenderer> parts) {
        ArrayList<ModelBox> cubes = new ArrayList<ModelBox>();
        for (ModelRenderer mp : parts) {
            this.getCubes(mp, cubes);
        }
        Collections.sort(cubes, new Comparator<ModelBox>(){

            @Override
            public int compare(ModelBox c0, ModelBox c1) {
                int hh1;
                int xs = MathHelper.func_76123_f((float)(c0.field_78248_d - c0.field_78252_a));
                int ys = MathHelper.func_76123_f((float)(c0.field_78249_e - c0.field_78250_b));
                int zs = MathHelper.func_76123_f((float)(c0.field_78246_f - c0.field_78251_c));
                int ww0 = xs * 2 + zs * 2;
                int hh0 = zs + ys;
                xs = MathHelper.func_76123_f((float)(c1.field_78248_d - c1.field_78252_a));
                ys = MathHelper.func_76123_f((float)(c1.field_78249_e - c1.field_78250_b));
                zs = MathHelper.func_76123_f((float)(c1.field_78246_f - c1.field_78251_c));
                int ww1 = xs * 2 + zs * 2;
                if (ww0 * hh0 < ww1 * (hh1 = zs + ys)) {
                    return 1;
                }
                if (ww0 * hh0 > ww1 * hh1) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<UnfoldedCube> unfolded = new ArrayList<UnfoldedCube>();
        for (ModelBox cube : cubes) {
            UnfoldedCube uc = new UnfoldedCube(cube);
            boolean placed = false;
            block4: for (int y = 0; y < 32 - uc.height; ++y) {
                for (int x = 0; x < 64 - uc.width; ++x) {
                    if (!uc.fits(x, y)) continue;
                    uc.place(x, y);
                    placed = true;
                    break block4;
                }
            }
            if (!placed) {
                System.out.println("Failed to place " + uc.id);
                continue;
            }
            unfolded.add(uc);
        }
        BufferedImage img = new BufferedImage(64, 32, 2);
        Graphics g = img.getGraphics();
        System.out.println("----------------");
        for (UnfoldedCube uc : unfolded) {
            System.out.println("setMapTex(\"" + uc.id + "\", " + uc.x + ", " + uc.y + ");");
            uc.render(g);
        }
        try {
            ImageIO.write((RenderedImage)img, "png", new File("output.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getCubes(ModelRenderer mp, List<ModelBox> cubeList) {
        block0: for (ModelBox cube : mp.field_78804_l) {
            if (cube.field_78247_g != null) {
                for (ModelBox otherCube : cubeList) {
                    if (otherCube.field_78247_g == null || !otherCube.field_78247_g.equals(cube.field_78247_g)) continue;
                    System.out.println("Duplicate " + cube.field_78247_g);
                    continue block0;
                }
            }
            cubeList.add(cube);
        }
    }

    public static void main(String[] args) {
        new ImageGenerator().generateImage(new ModelDragon((float)0.0f).field_78092_r);
    }

    private class UnfoldedCube {
        public int x;
        public int y;
        public Region[] cubeRegions = new Region[6];
        public String id;
        public int width;
        public int height;

        public UnfoldedCube(ModelBox cube) {
            int xs = MathHelper.func_76123_f((float)(cube.field_78248_d - cube.field_78252_a));
            int ys = MathHelper.func_76123_f((float)(cube.field_78249_e - cube.field_78250_b));
            int zs = MathHelper.func_76123_f((float)(cube.field_78246_f - cube.field_78251_c));
            this.width = xs * 2 + zs * 2;
            this.height = zs + ys;
            this.id = cube.field_78247_g;
            this.cubeRegions[0] = new Region(0, zs, zs, zs + ys);
            this.cubeRegions[1] = new Region(zs, zs, zs + xs, zs + ys);
            this.cubeRegions[2] = new Region(zs + xs, zs, zs + xs + zs, zs + ys);
            this.cubeRegions[3] = new Region(zs + xs + zs, zs, zs + xs + zs + xs, zs + ys);
            this.cubeRegions[4] = new Region(zs, 0, zs + xs, zs);
            this.cubeRegions[5] = new Region(zs + xs, 0, zs + xs * 2, zs);
        }

        public boolean fits(int x, int y) {
            for (int i = 0; i < 6; ++i) {
                if (ImageGenerator.this.isFree(this.cubeRegions[i], x, y)) continue;
                return false;
            }
            return true;
        }

        public void place(int x, int y) {
            this.x = x;
            this.y = y;
            for (int i = 0; i < 6; ++i) {
                this.cubeRegions[i].move(x, y);
                ImageGenerator.this.occupiedRegions.add(this.cubeRegions[i]);
            }
        }

        public void render(Graphics g) {
            float hue = (float)Math.random();
            g.setColor(new Color(Color.HSBtoRGB(hue, 1.0f, 0.7f)));
            this.cubeRegions[5].render(g);
            g.setColor(new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f)));
            this.cubeRegions[4].render(g);
            g.setColor(new Color(Color.HSBtoRGB(hue, 1.0f, 0.9f)));
            this.cubeRegions[1].render(g);
            this.cubeRegions[3].render(g);
            g.setColor(new Color(Color.HSBtoRGB(hue, 1.0f, 0.8f)));
            this.cubeRegions[0].render(g);
            this.cubeRegions[2].render(g);
        }
    }

    private class Region {
        public int x1;
        public int y1;
        public int x2;
        public int y2;

        public Region(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public void move(int xo, int yo) {
            this.x1 += xo;
            this.y1 += yo;
            this.x2 += xo;
            this.y2 += yo;
        }

        public boolean overlaps(Region r2, int xo, int yo) {
            if (r2.x2 + xo <= this.x1) {
                return false;
            }
            if (r2.y2 + yo <= this.y1) {
                return false;
            }
            if (r2.x1 + xo >= this.x2) {
                return false;
            }
            return r2.y1 + yo < this.y2;
        }

        public void render(Graphics g) {
            g.fillRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        }
    }
}

