/*
 * Decompiled with CFR 0.152.
 */
package clickme.animals.entity.passive;

import clickme.animals.entity.ai.EntityAIFlying;
import clickme.animals.entity.passive.EntityBirdBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBird
extends EntityBirdBase {
    private double flightTargetX;
    private double flightTargetY;
    private double flightTargetZ;
    public float wingRotation;
    public float prevWingRotation;
    public float flapSpeed;
    public float prevFlapSpeed;
    public float timeInAir = 1.0f;

    public EntityBird(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.6f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFlying(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 1.0, 1.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 8.0f, 1.0, 1.4));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 4.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevWingRotation = this.wingRotation;
        this.prevFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (this.field_70122_E ? -1.0 : 1.2));
        if (this.flapSpeed < 0.0f) {
            this.flapSpeed = 0.0f;
        }
        if (this.flapSpeed > 1.0f) {
            this.flapSpeed = 1.0f;
        }
        if (!this.field_70122_E && this.timeInAir < 1.0f) {
            this.timeInAir = 1.0f;
        }
        this.timeInAir = (float)((double)this.timeInAir * 0.9);
        if (this.isFlying()) {
            this.field_70181_x *= 0.1;
        } else if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.timeInAir * 2.0f;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isFlying()) {
            double d = this.flightTargetX - this.field_70165_t;
            double d1 = this.flightTargetY - this.field_70163_u;
            double d2 = this.flightTargetZ - this.field_70161_v;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (!this.canBlockBeSeen(this.flightTargetX, this.flightTargetY, this.flightTargetZ) || d3 < 1.0) {
                this.setFlying(false);
            } else {
                d3 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += d / d3 * 0.05;
                this.field_70181_x += d1 / d3 * 0.1;
                this.field_70179_y += d2 / d3 * 0.05;
                float f = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
                this.field_70177_z += f1;
            }
        } else if (this.field_70146_Z.nextInt(100) == 0 && this.findNewFlightTarget(Material.field_151584_j)) {
            this.setFlying(true);
        }
    }

    private boolean findNewFlightTarget(Material material) {
        AxisAlignedBB axisalignedbb = this.field_70121_D.func_72314_b(8.0, 8.0, 8.0);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = this.field_70170_p.func_147439_a(k1, l1 - 1, i2);
                    if (block.func_149688_o() != material || !this.canBlockBeSeen((double)k1 + 0.5, (double)l1 + 0.5, (double)i2 + 0.5)) continue;
                    this.flightTargetX = (double)k1 + 0.5;
                    this.flightTargetY = (double)l1 + 0.5;
                    this.flightTargetZ = (double)i2 + 0.5;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canBlockBeSeen(double x, double y, double z) {
        return this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), Vec3.func_72443_a((double)x, (double)y, (double)z)) == null;
    }

    protected void func_70069_a(float f) {
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Type", this.getBirdType());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setBirdType(par1NBTTagCompound.func_74762_e("Type"));
    }

    protected String func_70639_aQ() {
        switch (this.getBirdType()) {
            default: {
                return "animals:mob.bird.jay.say";
            }
            case 1: {
                return "animals:mob.bird.cardinal.say";
            }
            case 2: {
                return "animals:mob.bird.sparrow.say";
            }
            case 3: {
                return "animals:mob.bird.parrot.say";
            }
            case 4: {
                return "animals:mob.bird.chickadee.say";
            }
            case 5: 
        }
        return "animals:mob.bird.crow.say";
    }

    protected String func_70621_aR() {
        switch (this.getBirdType()) {
            default: {
                return "animals:mob.bird.jay.hurt";
            }
            case 1: {
                return "animals:mob.bird.cardinal.hurt";
            }
            case 2: {
                return "animals:mob.bird.sparrow.hurt";
            }
            case 3: {
                return "animals:mob.bird.parrot.hurt";
            }
            case 4: {
                return "animals:mob.bird.chickadee.hurt";
            }
            case 5: 
        }
        return "animals:mob.bird.crow.hurt";
    }

    protected String func_70673_aS() {
        switch (this.getBirdType()) {
            default: {
                return null;
            }
            case 1: {
                return "animals:mob.bird.cardinal.death";
            }
            case 5: 
        }
        return "animals:mob.bird.crow.death";
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        this.func_85030_a("mob.chicken.step", 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151008_G;
    }

    public int getBirdType() {
        return this.field_70180_af.func_75683_a(13);
    }

    public void setBirdType(int i) {
        this.field_70180_af.func_75692_b(13, (Object)((byte)i));
    }

    public boolean func_70617_f_() {
        return this.isFlying() ? false : super.func_70617_f_();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData ientitylivingdata) {
        this.setBirdType(this.func_70681_au().nextInt(5));
        return super.func_110161_a(ientitylivingdata);
    }
}

