/*
 * Decompiled with CFR 0.152.
 */
package net.animalsplus;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.animalsplus.CommonProxy;
import net.animalsplus.PlayerEventHandler;
import net.animalsplus.init.ModBlocks;
import net.animalsplus.init.ModConfiguration;
import net.animalsplus.init.ModCrafting;
import net.animalsplus.init.ModEntities;
import net.animalsplus.init.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="AnimalsPlus", version="1.7", acceptedMinecraftVersions="[1.8.9]")
public class AnimalsPlus {
    public static final String MODID = "AnimalsPlus";
    public static final String VERSION = "1.7";
    @Mod.Instance(value="AnimalsPlus")
    public static AnimalsPlus instance;
    @SidedProxy(clientSide="net.animalsplus.client.ClientProxy", serverSide="net.animalsplus.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    private boolean isOutdated = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModConfiguration.init(event.getSuggestedConfigurationFile());
        proxy.registerEntityRenderers();
        ModBlocks.init();
        ModEntities.init();
        ModItems.init();
        ModCrafting.init();
        this.checkForUpdates();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler(this));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    protected void onPlayerLoggedIn(EntityPlayer player) {
        if (FMLCommonHandler.instance().getSide().isClient() && this.isOutdated) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("animals.outdated", new Object[0]));
            String updateUrl = "http://animalsplus.net/";
            ChatComponentText url = new ChatComponentText(updateUrl);
            url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, updateUrl));
            url.func_150256_b().func_150228_d(Boolean.valueOf(true));
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("animals.download", new Object[]{url}));
        }
    }

    private void checkForUpdates() {
        new Thread("Animals Plus Version Check"){

            @Override
            public void run() {
                try {
                    URL url = new URL("http://animalsplus.net/dl/promotions.json");
                    InputStream input = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)input));
                    input.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    String latest = (String)promos.get("1.8.9-latest");
                    DefaultArtifactVersion current = new DefaultArtifactVersion(AnimalsPlus.VERSION);
                    if (latest != null) {
                        AnimalsPlus.this.isOutdated = current.compareTo((Object)new DefaultArtifactVersion(latest)) < 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }
}

