/*
 * Decompiled with CFR 0.152.
 */
package net.animalsplus.entity.ai;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;

public class EntityAIEatBreadcrumbs
extends EntityAIBase {
    private EntityLiving theEntity;
    private Item itemToPickup;
    private double searchRadius;
    private float movementSpeed;
    private List<EntityItem> targetList;
    private EntityItem bestTarget;

    public EntityAIEatBreadcrumbs(EntityLiving theEntityIn, Item item, double searchRadiusIn, float movementSpeedIn) {
        this.func_75248_a(3);
        this.theEntity = theEntityIn;
        this.itemToPickup = item;
        this.searchRadius = searchRadiusIn;
        this.movementSpeed = movementSpeedIn;
    }

    public boolean func_75250_a() {
        EntityItem closestItem = this.findClosestItem();
        return closestItem != null;
    }

    private EntityItem findClosestItem() {
        AxisAlignedBB aabb = this.theEntity.func_174813_aQ().func_72314_b(this.searchRadius, this.searchRadius, this.searchRadius);
        this.targetList = this.theEntity.func_130014_f_().func_175647_a(EntityItem.class, aabb, (Predicate)new Predicate<EntityItem>(){

            public boolean apply(EntityItem entityitem) {
                return entityitem.func_92059_d().func_77973_b().equals(EntityAIEatBreadcrumbs.this.itemToPickup);
            }
        });
        if (!this.targetList.isEmpty()) {
            this.bestTarget = this.targetList.get(0);
        }
        this.bestTarget = null;
        double closest = 0.0;
        for (int i = 0; i < this.targetList.size(); ++i) {
            EntityItem item = this.targetList.get(i);
            double dist = this.theEntity.func_70068_e((Entity)item);
            if (!(dist < closest) && closest != 0.0) continue;
            closest = dist;
            this.bestTarget = item;
        }
        return this.bestTarget;
    }

    public boolean func_75253_b() {
        return !this.theEntity.func_70661_as().func_75500_f() && this.bestTarget != null && this.bestTarget.func_70089_S();
    }

    public void func_75251_c() {
        this.bestTarget = null;
    }

    public void func_75246_d() {
        this.theEntity.func_70671_ap().func_75651_a((Entity)this.bestTarget, 30.0f, 30.0f);
        this.theEntity.func_70661_as().func_75497_a((Entity)this.bestTarget, (double)this.movementSpeed);
        double d0 = this.theEntity.field_70130_N * 2.0f * this.theEntity.field_70130_N * 2.0f;
        double dist = this.theEntity.func_70068_e((Entity)this.bestTarget);
        if (dist < d0) {
            this.bestTarget.func_70106_y();
            this.targetList.remove(this.bestTarget);
        }
    }
}

