/*
 * Decompiled with CFR 0.152.
 */
package net.animalsplus.init;

import com.google.common.collect.Maps;
import java.util.Map;
import net.animalsplus.AnimalsPlus;
import net.animalsplus.entity.ambient.EntityButterfly;
import net.animalsplus.entity.ambient.EntityCentipede;
import net.animalsplus.entity.ambient.EntityCricket;
import net.animalsplus.entity.ambient.EntityDragonfly;
import net.animalsplus.entity.ambient.EntityMoth;
import net.animalsplus.entity.passive.EntityBird;
import net.animalsplus.entity.passive.EntityCamel;
import net.animalsplus.entity.passive.EntityChameleon;
import net.animalsplus.entity.passive.EntityCrab;
import net.animalsplus.entity.passive.EntityCrocodile;
import net.animalsplus.entity.passive.EntityDuck;
import net.animalsplus.entity.passive.EntityKiwi;
import net.animalsplus.entity.passive.EntityKomodoDragon;
import net.animalsplus.entity.passive.EntityLizard;
import net.animalsplus.entity.passive.EntityLyrebird;
import net.animalsplus.entity.passive.EntityMouse;
import net.animalsplus.entity.passive.EntityPenguin;
import net.animalsplus.entity.passive.EntitySnake;
import net.animalsplus.entity.passive.EntityTortoise;
import net.animalsplus.entity.water.EntityAngler;
import net.animalsplus.entity.water.EntityFish;
import net.animalsplus.entity.water.EntityMantaRay;
import net.animalsplus.entity.water.EntityOctopus;
import net.animalsplus.entity.water.EntityPiranha;
import net.animalsplus.entity.water.EntityShark;
import net.animalsplus.entity.water.EntityTropicalFish;
import net.animalsplus.entity.water.EntityWhale;
import net.animalsplus.init.ModConfiguration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ModEntities {
    public static final Map<Integer, EntityModEggInfo> entityEggs = Maps.newLinkedHashMap();
    public static final Map<Integer, String> idToModEntityName = Maps.newLinkedHashMap();

    public static void init() {
        ModEntities.registerModEntityWithEgg(EntityCentipede.class, "Centipede", 0, 80, 3, true, 15708256, 5848090);
        ModEntities.registerModEntityWithEgg(EntityCricket.class, "Cricket", 1, 80, 3, true, 8343842, 0x200C0C);
        ModEntities.registerModEntityWithEgg(EntityButterfly.class, "Butterfly", 2, 80, 3, false, 15493137, 721666);
        ModEntities.registerModEntityWithEgg(EntityMoth.class, "Moth", 3, 80, 3, true, 13614758, 6704950);
        ModEntities.registerModEntityWithEgg(EntityDragonfly.class, "Dragonfly", 4, 80, 3, false, 0x454944, 14863822);
        ModEntities.registerModEntityWithEgg(EntityFish.class, "Fish", 5, 64, 3, true, 6928807, 6057867);
        ModEntities.registerModEntityWithEgg(EntityTropicalFish.class, "TropicalFish", 6, 64, 3, true, 15887623, 15725300);
        ModEntities.registerModEntityWithEgg(EntityPiranha.class, "Piranha", 7, 80, 3, true, 2829109, 14634030);
        ModEntities.registerModEntityWithEgg(EntityAngler.class, "Angler", 8, 64, 3, true, 5397296, 15392616);
        ModEntities.registerModEntityWithEgg(EntityMantaRay.class, "MantaRay", 9, 80, 3, true, 1052965, 0xDCDCDC);
        ModEntities.registerModEntityWithEgg(EntityWhale.class, "Whale", 10, 144, 3, true, 9415875, 7243159);
        ModEntities.registerModEntityWithEgg(EntityOctopus.class, "Octopus", 11, 80, 3, true, 8474253, 16091641);
        ModEntities.registerModEntityWithEgg(EntityShark.class, "Shark", 12, 80, 3, true, 0xA8A8A8, 0x747474);
        ModEntities.registerModEntityWithEgg(EntityCrab.class, "Crab", 13, 80, 3, true, 14252298, 16235636);
        ModEntities.registerModEntityWithEgg(EntitySnake.class, "Snake", 14, 80, 3, true, 7096116, 14531977);
        ModEntities.registerModEntityWithEgg(EntityLizard.class, "Lizard", 15, 80, 3, true, 6640957, 10325365);
        ModEntities.registerModEntityWithEgg(EntityChameleon.class, "Chameleon", 16, 80, 3, true, 6073690, 5541444);
        ModEntities.registerModEntityWithEgg(EntityMouse.class, "Mouse", 17, 80, 3, true, 5986381, 15902877);
        ModEntities.registerModEntityWithEgg(EntityBird.class, "Bird", 18, 80, 3, true, 4934535, 15910160);
        ModEntities.registerModEntityWithEgg(EntityDuck.class, "Duck", 19, 80, 3, true, 4413191, 13155998);
        ModEntities.registerModEntityWithEgg(EntityPenguin.class, "Penguin", 20, 80, 3, true, 1066089, 0xD4D4D4);
        ModEntities.registerModEntityWithEgg(EntityLyrebird.class, "Lyrebird", 21, 80, 3, true, 6705992, 8497348);
        ModEntities.registerModEntityWithEgg(EntityTortoise.class, "Tortoise", 22, 80, 3, true, 6850090, 7164960);
        ModEntities.registerModEntityWithEgg(EntityCrocodile.class, "Crocodile", 23, 80, 3, true, 2306333, 8420949);
        ModEntities.registerModEntityWithEgg(EntityKomodoDragon.class, "KomodoDragon", 24, 80, 3, true, 0x4F422F, 12077098);
        ModEntities.registerModEntityWithEgg(EntityCamel.class, "Camel", 25, 80, 3, true, 14192438, 15382652);
        ModEntities.registerModEntityWithEgg(EntityKiwi.class, "Kiwi", 26, 80, 3, true, 6245698, 16509163);
        if (ModConfiguration.spawnBird) {
            EntityRegistry.addSpawn(EntityBird.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            EntityRegistry.addSpawn(EntityBird.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            EntityRegistry.addSpawn(EntityBird.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            EntityRegistry.addSpawn(EntityBird.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            EntityRegistry.addSpawn(EntityBird.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        }
        if (ModConfiguration.spawnDuck) {
            EntityRegistry.addSpawn(EntityDuck.class, (int)10, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            EntityRegistry.addSpawn(EntityDuck.class, (int)10, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        }
        if (ModConfiguration.spawnPenguin) {
            EntityRegistry.addSpawn(EntityPenguin.class, (int)6, (int)2, (int)6, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
        }
        if (ModConfiguration.spawnSnake) {
            EntityRegistry.addSpawn(EntitySnake.class, (int)12, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
            EntityRegistry.addSpawn(EntitySnake.class, (int)12, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
            EntityRegistry.addSpawn(EntitySnake.class, (int)12, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HOT));
        }
        if (ModConfiguration.spawnLizard) {
            EntityRegistry.addSpawn(EntityLizard.class, (int)12, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
            EntityRegistry.addSpawn(EntityLizard.class, (int)12, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
            EntityRegistry.addSpawn(EntityLizard.class, (int)12, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HOT));
        }
        if (ModConfiguration.spawnCrab) {
            EntityRegistry.addSpawn(EntityCrab.class, (int)8, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        }
        if (ModConfiguration.spawnTortoise) {
            EntityRegistry.addSpawn(EntityTortoise.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            EntityRegistry.addSpawn(EntityTortoise.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        }
        if (ModConfiguration.spawnChameleon) {
            EntityRegistry.addSpawn(EntityChameleon.class, (int)8, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        }
        if (ModConfiguration.spawnLyrebird) {
            EntityRegistry.addSpawn(EntityLyrebird.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        }
        if (ModConfiguration.spawnFish) {
            EntityRegistry.addSpawn(EntityFish.class, (int)16, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            EntityRegistry.addSpawn(EntityFish.class, (int)16, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        }
        if (ModConfiguration.spawnTropicalFish) {
            EntityRegistry.addSpawn(EntityTropicalFish.class, (int)14, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
            EntityRegistry.addSpawn(EntityTropicalFish.class, (int)12, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            EntityRegistry.addSpawn(EntityTropicalFish.class, (int)8, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
            EntityRegistry.addSpawn(EntityTropicalFish.class, (int)6, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        }
        if (ModConfiguration.spawnAngler) {
            EntityRegistry.addSpawn(EntityAngler.class, (int)8, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        }
        if (ModConfiguration.spawnMantaRay) {
            EntityRegistry.addSpawn(EntityMantaRay.class, (int)6, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        }
        if (ModConfiguration.spawnWhale) {
            EntityRegistry.addSpawn(EntityWhale.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (ModConfiguration.spawnPiranha) {
            EntityRegistry.addSpawn(EntityPiranha.class, (int)8, (int)6, (int)10, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            EntityRegistry.addSpawn(EntityPiranha.class, (int)10, (int)6, (int)10, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
            EntityRegistry.addSpawn(EntityPiranha.class, (int)10, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        }
        if (ModConfiguration.spawnShark) {
            EntityRegistry.addSpawn(EntityShark.class, (int)4, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        }
        if (ModConfiguration.spawnCentipede) {
            EntityRegistry.addSpawn(EntityCentipede.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            EntityRegistry.addSpawn(EntityCentipede.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        }
        if (ModConfiguration.spawnCricket) {
            EntityRegistry.addSpawn(EntityCricket.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            EntityRegistry.addSpawn(EntityCricket.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            EntityRegistry.addSpawn(EntityCricket.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            EntityRegistry.addSpawn(EntityCricket.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        }
        if (ModConfiguration.spawnButterfly) {
            EntityRegistry.addSpawn(EntityButterfly.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            EntityRegistry.addSpawn(EntityButterfly.class, (int)2, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            EntityRegistry.addSpawn(EntityButterfly.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            EntityRegistry.addSpawn(EntityButterfly.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            EntityRegistry.addSpawn(EntityButterfly.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        }
        if (ModConfiguration.spawnMoth) {
            EntityRegistry.addSpawn(EntityMoth.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            EntityRegistry.addSpawn(EntityMoth.class, (int)4, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        }
        if (ModConfiguration.spawnMouse) {
            EntityRegistry.addSpawn(EntityMouse.class, (int)4, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        }
        if (ModConfiguration.spawnDragonfly) {
            EntityRegistry.addSpawn(EntityDragonfly.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            EntityRegistry.addSpawn(EntityDragonfly.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        }
        if (ModConfiguration.spawnCrocodile) {
            EntityRegistry.addSpawn(EntityCrocodile.class, (int)6, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            EntityRegistry.addSpawn(EntityCrocodile.class, (int)6, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        }
        if (ModConfiguration.spawnKomodoDragon) {
            EntityRegistry.addSpawn(EntityKomodoDragon.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            EntityRegistry.addSpawn(EntityKomodoDragon.class, (int)6, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
            EntityRegistry.addSpawn(EntityKomodoDragon.class, (int)6, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            EntityRegistry.addSpawn(EntityKomodoDragon.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
            EntityRegistry.addSpawn(EntityKomodoDragon.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        }
        if (ModConfiguration.spawnCamel) {
            EntityRegistry.addSpawn(EntityCamel.class, (int)4, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76769_d});
        }
        if (ModConfiguration.spawnKiwi) {
            EntityRegistry.addSpawn(EntityLyrebird.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            EntityRegistry.addSpawn(EntityLyrebird.class, (int)4, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            EntityRegistry.addSpawn(EntityLyrebird.class, (int)6, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        }
        EntitySpawnPlacementRegistry.setPlacementType(EntityCentipede.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityCricket.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityButterfly.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMoth.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityFish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityTropicalFish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityAngler.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMantaRay.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityWhale.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityOctopus.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntitySnake.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityLizard.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityChameleon.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMouse.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityBird.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityDuck.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityPenguin.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityPiranha.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityShark.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityCrab.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityTortoise.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityDragonfly.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityLyrebird.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityCrocodile.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityKomodoDragon.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityCamel.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityKiwi.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
    }

    public static void registerModEntity(Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)AnimalsPlus.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        idToModEntityName.put(id, "AnimalsPlus." + entityName);
    }

    public static void registerModEntityWithEgg(Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        ModEntities.registerModEntity(entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        entityEggs.put(id, new EntityModEggInfo(id, eggPrimary, eggSecondary));
    }

    public static Entity createEntityByID(int modEntityId, World worldIn) {
        Entity entity = null;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)AnimalsPlus.instance);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, modEntityId);
        if (er != null) {
            Class clazz = er.getEntityClass();
            try {
                if (clazz != null) {
                    entity = (Entity)clazz.getConstructor(World.class).newInstance(worldIn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entity == null) {
            AnimalsPlus.logger.warn("Skipping Animals Plus Entity with id " + modEntityId);
        }
        return entity;
    }

    public static class EntityModEggInfo {
        public final int spawnedID;
        public final int primaryColor;
        public final int secondaryColor;

        public EntityModEggInfo(int id, int primary, int secondary) {
            this.spawnedID = id;
            this.primaryColor = primary;
            this.secondaryColor = secondary;
        }
    }
}

