/*
 * Decompiled with CFR 0.152.
 */
package clickme.animalsplus;

import clickme.animalsplus.CommonProxy;
import clickme.animalsplus.PlayerEventHandler;
import clickme.animalsplus.init.ModBlocks;
import clickme.animalsplus.init.ModConfiguration;
import clickme.animalsplus.init.ModCrafting;
import clickme.animalsplus.init.ModEntities;
import clickme.animalsplus.init.ModItems;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="AnimalsPlus", version="1.6", acceptedMinecraftVersions="[1.8]")
public class AnimalsPlus {
    public static final String MODID = "AnimalsPlus";
    public static final String VERSION = "1.6";
    @Mod.Instance(value="AnimalsPlus")
    public static AnimalsPlus instance;
    @SidedProxy(clientSide="clickme.animalsplus.client.ClientProxy", serverSide="clickme.animalsplus.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    private boolean isOutdated = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModConfiguration.init(event.getSuggestedConfigurationFile());
        ModBlocks.init();
        ModEntities.init();
        ModItems.init();
        ModCrafting.init();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.checkForUpdates();
            FMLCommonHandler.instance().bus().register((Object)new PlayerEventHandler());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    protected void onPlayerLoggedIn(EntityPlayer player) {
        if (this.isOutdated) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("animals.outdated", new Object[0]));
            String updateUrl = "http://clickme.cu.cc/animals.php";
            ChatComponentText url = new ChatComponentText(updateUrl);
            url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, updateUrl));
            url.func_150256_b().func_150228_d(Boolean.valueOf(true));
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("animals.download", new Object[]{url}));
        }
    }

    private void checkForUpdates() {
        new Thread("Animals Plus Version Check"){

            @Override
            public void run() {
                try {
                    URL url = new URL("http://clickme.cu.cc/dl/an/promotions.json");
                    InputStream input = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)input));
                    input.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    String latest = (String)promos.get("1.8-latest");
                    DefaultArtifactVersion current = new DefaultArtifactVersion(AnimalsPlus.VERSION);
                    if (latest != null) {
                        AnimalsPlus.this.isOutdated = current.compareTo((Object)new DefaultArtifactVersion(latest)) < 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }
}

