/*
 * Decompiled with CFR 0.152.
 */
package clickme.animalsplus.client.renderer.entity;

import clickme.animalsplus.client.model.ModelBird;
import clickme.animalsplus.entity.passive.EntityBird;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBird
extends RenderLiving {
    private static final ResourceLocation jayTextures = new ResourceLocation("animalsplus", "textures/entity/bird/jay.png");
    private static final ResourceLocation cardinalTextures = new ResourceLocation("animalsplus", "textures/entity/bird/cardinal.png");
    private static final ResourceLocation sparrowTextures = new ResourceLocation("animalsplus", "textures/entity/bird/sparrow.png");
    private static final ResourceLocation parrotTextures = new ResourceLocation("animalsplus", "textures/entity/bird/parrot.png");
    private static final ResourceLocation chickadeeTextures = new ResourceLocation("animalsplus", "textures/entity/bird/chickadee.png");
    private static final ResourceLocation crowTextures = new ResourceLocation("animalsplus", "textures/entity/bird/crow.png");

    public RenderBird(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelBird(), 0.3f);
    }

    protected ResourceLocation getEntityTextures(EntityBird bird) {
        switch (bird.getBirdType()) {
            default: {
                return jayTextures;
            }
            case 1: {
                return cardinalTextures;
            }
            case 2: {
                return sparrowTextures;
            }
            case 3: {
                return parrotTextures;
            }
            case 4: {
                return chickadeeTextures;
            }
            case 5: 
        }
        return crowTextures;
    }

    protected float handleRotationFloat(EntityBird bird, float f) {
        float f1 = bird.prevWingRotation + (bird.wingRotation - bird.prevWingRotation) * f;
        float f2 = bird.prevFlapSpeed + (bird.flapSpeed - bird.prevFlapSpeed) * f;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected float func_77044_a(EntityLivingBase livingBase, float f) {
        return this.handleRotationFloat((EntityBird)livingBase, f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getEntityTextures((EntityBird)entity);
    }
}

