/*
 * Decompiled with CFR 0.152.
 */
package clickme.animalsplus.entity.water;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySwimming
extends EntityWaterMob {
    private double swimTargetX;
    private double swimTargetY;
    private double swimTargetZ;
    private Entity targetEntity;
    private boolean isAttacking;
    protected float swimRange = 4.0f;
    protected float swimRangeHeight = 4.0f;
    protected boolean isAgressive = false;
    protected int attackInterval = 50;
    protected float attackSpeed = 1.2f;
    protected float swimSpeed = 0.5f;
    protected boolean jumpOnLand = true;

    public EntitySwimming(World world) {
        super(world);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70090_H() {
        double d0 = this.field_70163_u + (double)this.field_70131_O + 0.2;
        IBlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d0, this.field_70161_v));
        return blockState.func_177230_c().func_149688_o() == Material.field_151586_h;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            this.field_70181_x *= 0.1;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70090_H()) {
            double d0;
            IBlockState blockState;
            double dx = this.swimTargetX - this.field_70165_t;
            double dy = this.swimTargetY - this.field_70163_u;
            double dz = this.swimTargetZ - this.field_70161_v;
            double dist = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            if (dist < 1.0 || dist > 1000.0 || this.field_70146_Z.nextInt(100) == 0) {
                this.swimTargetX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRange);
                this.swimTargetY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRangeHeight);
                this.swimTargetZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRange);
                this.isAttacking = false;
            }
            if ((blockState = this.field_70170_p.func_180495_p(new BlockPos(this.swimTargetX, d0 = this.swimTargetY, this.swimTargetZ))).func_177230_c().func_149688_o() == Material.field_151586_h) {
                this.field_70159_w += dx / dist * 0.05 * (double)this.swimSpeed;
                this.field_70181_x += dy / dist * 0.2 * (double)this.swimSpeed;
                this.field_70179_y += dz / dist * 0.05 * (double)this.swimSpeed;
            } else {
                this.swimTargetX = this.field_70165_t;
                this.swimTargetY = this.field_70163_u + (double)0.2f;
                this.swimTargetZ = this.field_70161_v;
            }
            if (this.isAttacking) {
                this.field_70159_w *= (double)this.attackSpeed;
                this.field_70181_x *= (double)this.attackSpeed;
                this.field_70179_y *= (double)this.attackSpeed;
            }
            if (this.isAgressive && this.field_70146_Z.nextInt(this.attackInterval) == 0) {
                this.targetEntity = this.findEntityToAttack();
                if (this.targetEntity != null && this.targetEntity.func_70090_H()) {
                    this.swimTargetX = this.targetEntity.field_70165_t;
                    this.swimTargetY = this.targetEntity.field_70163_u + (double)0.4f;
                    this.swimTargetZ = this.targetEntity.field_70161_v;
                    this.isAttacking = true;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                float f = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                this.field_70177_z += MathHelper.func_76142_g((float)(f - this.field_70177_z));
                float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70125_A = (float)Math.atan2(this.field_70181_x, f1) * 180.0f / (float)Math.PI * 2.0f;
            }
        } else if (this.jumpOnLand && this.field_70122_E && this.field_70146_Z.nextInt(30) == 0) {
            this.field_70181_x = 0.3f;
            this.field_70159_w = -0.2f + this.field_70146_Z.nextFloat() * 0.4f;
            this.field_70179_y = -0.2f + this.field_70146_Z.nextFloat() * 0.4f;
        }
    }

    protected Entity findEntityToAttack() {
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 16.0);
        return player != null && this.func_70685_l((Entity)player) ? player : null;
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.isAgressive && this.targetEntity == entity) {
            this.func_70652_k(entity);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isAgressive) {
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        }
        return super.func_70652_k(entity);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }
}

