﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using EKETEAM.Data;
using EKETEAM.FrameWork;
using EKETEAM.UserControl;
using LitJson;

namespace eFrameWork.AppWebAPI
{
    public partial class Model : System.Web.UI.Page
    {
        public string AppItem = eParameters.Request("AppItem");
        public string ModelID = eParameters.Request("modelid");     
        protected void Page_Load(object sender, EventArgs e)
        {
            eUser user;
            eModel model;
            if (Request.Headers["auth"] == null)
            {
                eJson ErrJson = new eJson();
                ErrJson.Add("errcode", "1");
                ErrJson.Add("message", "未携带eToKen");
                eBase.WriteJson(ErrJson);
            }
            string auth = Request.Headers["auth"].ToString();

            DataRow[] appRows = eBase.a_eke_sysApplicationItems.Select("ApplicationItemID='" + AppItem + "'");
            if (appRows.Length == 0)
            {
                eJson ErrJson = new eJson();
                ErrJson.Add("errcode", "1");
                ErrJson.Add("message", "参数错误!");
                eBase.WriteJson(ErrJson);
            }
            if(ModelID.Length==0) ModelID = appRows[0]["ModelID"].ToString();

            if (auth == "anonymous")
            {
                user = new eUser("", "00000000-0000-0000-0000-000000000000");
                model = new eModel(AppItem, ModelID, user);
                if (model.Power.Table.Columns.Contains("add")) model.Power["add"] = model.AnonymousAdd.ToString().ToLower();
                if (model.Power.Table.Columns.Contains("list")) model.Power["list"] = model.AnonymousList.ToString().ToLower();
                if (model.Power.Table.Columns.Contains("view")) model.Power["view"] = model.AnonymousView.ToString().ToLower();
                if (model.Power.Table.Columns.Contains("del")) model.Power["del"] = model.AnonymousDelete.ToString().ToLower();
                if (model.Power.Table.Columns.Contains("edit")) model.Power["edit"] = model.AnonymousEdit.ToString().ToLower();             
            }
            else
            {
                eToken token = new eToken(auth);
                user = new eUser(token);
                model = new eModel(AppItem, ModelID, user);
            }

          
            //string auth = "480f1e61fa4aa800e0ec1f7f79384f95249cbfd41acb612605c81ec1355bfc9bc627f662ecc90a555ad4093db961cc68848be3045f12e7f073d3d83079fa02eaef193247b61df106569e3789458166788266d1643c45ba6bb9c86f6327bfb27b6712ab73f7625182082e4af322c6abc1f840027be3ca06f4fe56b5aa23f24c64b97f379e1cf5b2c6e71cde15a6882d8169d06161b5bbf9cbf3b49d705228fc1803aa0c9cb175d0ce";
            
            model.Ajax = true;
            model.Mode = "WebAPI";
            if (Request.ContentType.ToLower().IndexOf("/json") > -1)
            {
                model.WebAPISave();
            }
            else
            {
                switch (model.Action.Value)
                {
                    case "":
                        model.WebAPIList();
                        break;
                    case "apiedit":
                        model.WebAPIEdit();
                        break;
                    case "apiview":
                        model.WebAPIView();
                        break;
                    case "apisave":
                        model.WebAPISave();
                        break;
                    case "apidel":
                        model.WebAPIDelete();
                        break;
                }
                eBase.End();
            }
        }
    }
}