﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using EKETEAM.Data;
using EKETEAM.FrameWork;

namespace eFrameWork.Application
{
    public partial class Custom : System.Web.UI.Page
    {
        public string UserArea = "Application";
        public eModel model;
        public bool Ajax = false;
        protected void Page_Load(object sender, EventArgs e)
        {
            //System.Web.UI.HtmlControls.HtmlInputHidden

            eUser user = new eUser(UserArea);
            user.Check();

            eModelInfo customModel = new eModelInfo(user);
            model = customModel.Model;

            string path = model.ModelInfo["AspxFile"].ToString();
            eBase.ExecutePage(path, LitBody);           
        }
        protected void Page_PreInit(object sender, EventArgs e)
        {
            if (Request.QueryString["ajax"] != null) Ajax = Convert.ToBoolean(Request.QueryString["ajax"]);
            if (!Ajax)
            {
                MasterPageFile = "Main.Master";
            }
            else
            {
                MasterPageFile = "MainNone.Master";
            }
        }
        protected void Page_PreRender(object sender, EventArgs e)
        {
            Literal lit = (Literal)Master.FindControl("LitTitle");
            if (lit != null)
            {
                lit.Text = model.ModelInfo["mc"].ToString() + " - " + eConfig.systemName();
            }
            lit = (Literal)Master.FindControl("LitJavascript");
            if (lit != null && model.Javasctipt.Length > 0)
            {
                lit.Text = model.Javasctipt;
            }
        }
    }
}