﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using EKETEAM.Data;
using EKETEAM.FrameWork;
using EKETEAM.UserControl;

namespace eFrameWork.Applicationhui
{
    public partial class Model : System.Web.UI.Page
    {
        public string UserArea = "ApplicationHUI";
        public string ModelID = eParameters.Request("ModelID");
        public string AppItem = eParameters.Request("AppItem");
        public eModel model;
        
        public bool Ajax = false;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["ajax"] != null) Ajax = Convert.ToBoolean(Request.QueryString["ajax"]);
            eUser user = new eUser(UserArea);
            //model = new eModel(ModelID, user);
            if (AppItem.Length > 0)
            {
                DataRow[] appRows = eBase.a_eke_sysApplicationItems.Select("ApplicationItemID='" + AppItem + "'");
                if (appRows.Length == 0) Response.End();
                ModelID = appRows[0]["ModelID"].ToString();
                model = new eModel(AppItem, ModelID, user);
            }
            else
            {
                model = new eModel(ModelID, user);
            }



            model.Ajax = true; //默认为false
            switch (model.Action.Value)
            {
                case "building":
                    LitBody.Text = "<div style=\"padding:50px; height:100%; text-align:center; \"><img src=\"../images/Building.jpg\" style=\"width:390px;\" /></div>";
                    break;
                   
                case "":
                    if (model.ModelInfo["type"].ToString() == "4")//报表
                    {
                        LitBody.Text = model.getReportList();
                    }
                    else
                    {
                        LitBody.Text = model.getListHTML();
                    }
                    break;
                case "add":
                    LitBody.Text = model.getAddHTML();
                    break;
                case "edit":
                    LitBody.Text = model.getEditHTML();
                    break;
                case "copy":
                    LitBody.Text = model.getEditHTML();
                    break;
                case "view":
                    LitBody.Text = model.getViewHTML();
                    break;
                case "print":
                    eBase.Write(model.getPrintHTML());
                    eBase.End();  
                    break;
                case "save":
                    model.Save();
                    break;
                case "del":
                    model.Delete();
                    break;
                case "addsub":
                    eBase.Write(model.getAddHTML());
                    eBase.End();
                    break;
                case "viewsub":
                    eBase.Write(model.getViewHTML());
                    eBase.End();
                    break;
                case "export":
                    model.ExportExcel();
                    break;
                case "getrole":
                    string roleid = eParameters.QueryString("roleid");
                    DataTable rolePower = eBase.getUserPowerDefault(roleid, "", "");
                    eJson json = new eJson(rolePower);
                    json.Convert = true;
                    eBase.Write(json.ToString());
                    Response.End();
                    break;
            }
        }
        protected void Page_PreRender(object sender, EventArgs e)
        {
            Literal lit = (Literal)Master.FindControl("LitTitle");
            if (lit != null)
            {
                lit.Text = model.ModelInfo["mc"].ToString() + " - " + eConfig.systemName();
            }
            lit = (Literal)Master.FindControl("LitJavascript");
            if (lit != null && model.Javasctipt.Length > 0)
            {
                lit.Text = model.Javasctipt;
            }
        }
    }
}