package deadbeef.Filters;

/**
 * Triangle filter
 */
final class TriangleFilter implements Filter {
	public float getRadius() {
		return 1.0f;
	}

	public final float value(float value) {
		if (value < 0.0f) 
			value = -value;		
		if (value < 1.0f) 
			return 1.0f - value;		
		
		return 0.0f;		
	}
}
