# PythonPlugin是python插件的封装类，文件位于JsonRPC下面4
from PythonPlugin import PythonPlugin
from ctypes import windll
from ctypes import create_unicode_buffer
from ctypes import byref
# from ctypes import c_char_p
import os
import platform
import json

# from win32com.shell import shell, shellcon
# import win32api, win32gui, win32ui, win32con
# from PIL import Image
# from time import perf_counter

# from win32api import ShellExecute


class Everything_search(PythonPlugin):

    def Query(self, param: str):
        results = []
        if not param:
            results.append({
                "Title": "使用everything搜索文件",
                "SubTitle": "输入文字开始搜索",
                "IconPath": "",
            })
        else:
            # start = perf_counter()
            results = self.search_files(param)
            # end = perf_counter()
            # results.insert(0, {
            #     "Title": "{}".format(end - start),
            #     "SubTitle": "输入文字开始搜索",
            #     "IconPath": "",
            # })
        return results

    def search_files(self, txt: str):
        if " " in txt.strip():
            if txt.split(" ")[-1].isdigit():  # 空格分开的最后一个是否是数字
                offset = int(txt.split(" ")[-1])
                txt = txt.strip(str(offset)).strip()
            else:
                offset = 0
                txt = txt.strip()
        else:
            offset = 0
            txt = txt.strip()
        try:
            if "64" in self.get_sysbit()[0]:
                Search = windll.LoadLibrary("everything64.dll")
            else:
                Search = windll.LoadLibrary("everything32.dll")
        except (OSError, ImportError):
            return [{
                "Title": "导入Everything64.dll/Everything32.dll失败,请将SDK放在下面目录",
                "SubTitle": "{}".format(os.getcwd()),
                "IconPath": "",
            }]
        strBuff = create_unicode_buffer(255)
        Search.Everything_SetSearchW(txt)
        Search.Everything_SetSort("EVERYTHING_SORT_DATE_CREATED_DESCENDING")  # 设置排序方式
        Search.Everything_SetMax(99)  # 设置最大返回条数
        Search.Everything_SetOffset(offset)  # 设置返回第一条的偏移量
        Search.Everything_QueryW(True)
        search_results = Search.Everything_GetNumResults()
        namelist = []
        if search_results:
            # 判断第一条翻页项怎么显示
            if offset != 0 and search_results == 99:
                offset += 99
                namelist.append({
                    "Title": '此页搜索到“{}”相关的记录{}条'.format(txt, search_results),
                    "SubTitle": "最多显示99条，按创建时间倒序展示，点击此处可查看下一页",
                    "IconPath": "",
                    'Action': {
                        'FuncName': 'Ra_ChangeQuery',
                        'Parameter': "fin {} {}".format(txt, offset),
                        'HideWindow': False
                    }
                })
            elif offset == 0 and search_results == 99:
                offset = 99
                namelist.append({
                    "Title": '此页共搜索到“{}”相关的记录{}条'.format(txt, search_results),
                    "SubTitle": "最多显示99条，按创建时间倒序展示，点击此处可查看下一页",
                    "IconPath": "",
                    'Action': {
                        'FuncName': 'Ra_ChangeQuery',
                        'Parameter': "fin {} {}".format(txt, offset),
                        'HideWindow': False
                    }
                })
            else:
                namelist.append({
                    "Title": '此页搜索到“{}”相关的记录{}条'.format(txt, search_results),
                    "SubTitle": "最多显示99条，按创建时间倒序展示，似乎是最后一页了",
                    "IconPath": ""
                })
            # 创建数据列表
            for index in range(search_results):
                Search.Everything_GetResultFullPathNameW(index, byref(strBuff), len(strBuff))
                path = strBuff.value
                if Search.Everything_IsFileResult(index):
                    namelist.append({
                        "Title": os.path.basename(path),
                        "ExtraData": os.path.dirname(path),
                        "SubTitle": path,
                        # "IconPath": "{}".format(self.get_ico(path)),
                        "IconPath": "Ra_NativeIcon",
                        'Action': {
                            'FuncName': 'Ra_Open',
                            'Parameter': path,
                            'HideWindow': True
                        }
                    })
                else:
                    namelist.append({
                        "Title": os.path.basename(path),
                        "SubTitle": path,
                        "IconPath": "Ra_NativeIcon",
                        "ExtraData": os.path.dirname(path),
                        'Action': {
                            'FuncName': 'Ra_Open',
                            'Parameter': path,
                            'HideWindow': True
                        }
                    })

            # list = Search.Everything_GetResultFileNameW(index)
            # cFileName = Search.Everything_GetResultFileNameW(index)
            # print(c_char_p(cFileName).value)

        else:
            namelist.append({
                "Title": "该页没有找到“{}”相关的记录".format(txt),
                "SubTitle": "",
                "IconPath": "",
            })
        del Search
        del strBuff
        return namelist

    def get_sysbit(self):
        '''
        获取系统位数，是32位还是64位
        :return:
        '''
        return platform.architecture()

    def GetContextMenu(self, data):
        '''
        右键菜单列表数据
        :param data:
        :return:
        '''
        data = json.loads(data)
        results = [{
            "Title": "打开所在目录",
            "SubTitle": "{}".format(data['ExtraData']),
            "IconPath": "icon/open.ico",
            "Action": {
                "FuncName": "Ra_OpenFileFolder",
                "Parameter": "{}".format(data['SubTitle'])
            }
        }, {
            "Title": "移到回收站",
            "SubTitle": "{}".format(data['SubTitle']),
            "IconPath": "icon/delete.ico",
            "Action": {
                "FuncName": "Ra_Recycle",
                "Parameter": "{}".format(data['SubTitle'])
            }
        }, {
            "Title": "复制完整路径",
            "SubTitle": "{}".format(data['SubTitle']),
            "IconPath": "icon/copy.ico",
            "Action": {
                "FuncName": "Ra_CopyPath",
                "Parameter": "{}".format(data['SubTitle'])
            }
        }, {
            "Title": "复制名称",
            "SubTitle": "{}".format(data['Title']),
            "IconPath": "icon/copy.ico",
            "Action": {
                "FuncName": "Ra_CopyPath",
                "Parameter": "{}".format(data['Title'])
            }
        }, {
            "Title": "复制所在路径",
            "SubTitle": "{}".format(data['ExtraData']),
            "IconPath": "icon/copy.ico",
            "Action": {
                "FuncName": "Ra_CopyPath",
                "Parameter": "{}".format(data['ExtraData'])
            }
        }]
        return results

    # def get_ico(self, file_path):
    #     '''
    #     根据可执行文件路径保存图标并返回图标的保存位置（相对位置）
    #     :param exePath:
    #     :param sub_title:
    #     :return:  返回图标的保存位置
    #     '''
    #     default_ico = ''
    #     if win32api.GetFileAttributes(file_path) == win32con.FILE_ATTRIBUTE_DIRECTORY:
    #         icon_name = 'dir'
    #     else:
    #         file_name = os.path.split(file_path)[-1]
    #         icon_name = file_name.split(".")[-1]  # 没有后缀的以文件名为图片名
    #         if icon_name in ['lnk', 'exe']:  # 连接和程序。不同连接不同程序图标不一样，只能通过文件名保存
    #             icon_name = file_name[:len(file_name) - len(icon_name) - 1]
    #     save_path = "icons/{}.png".format(icon_name)
    #     if os.path.exists(save_path):
    #         return save_path
    #     hicon = shell.SHGetFileInfo(file_path, 0,
    #                                 shellcon.SHGFI_SYSICONINDEX | shellcon.SHGFI_ICON | shellcon.SHGFI_DISPLAYNAME)[1][0]
    #     if not hicon:
    #         return default_ico
    #     hdc = win32ui.CreateDCFromHandle(win32gui.GetDC(0))
    #     hbmp = win32ui.CreateBitmap()
    #     hbmp.CreateCompatibleBitmap(hdc, 32, 32)
    #     hdc = hdc.CreateCompatibleDC()
    #     hdc.SelectObject(hbmp)
    #     hdc.DrawIcon((0, 0), int(hicon))
    #     try:
    #         win32gui.DestroyIcon(hicon)  # 使用完销毁大图标
    #     except:
    #         pass  # 如果不同线程会报无法销毁
    #     # hbmp.SaveBitmapFile(hdc, f"icons/{hwnd}.bmp")  # 这是保存为bmp格式，背景是黑色的
    #     # 这里使用pillow库中的image保存为透明背景的png格式
    #     bmpstr = hbmp.GetBitmapBits(True)
    #     img = Image.frombuffer('RGBA', (32, 32), bmpstr, 'raw', 'BGRA', 0, 1)
    #     img.save(save_path)  # 保存为png格式，背景透明， 保存目录一定要存在
    #     return save_path
    #     # except:
    #     #     return defult_ico


if __name__ == "__main__":
    # print(Everything_search().Query('main - 基于python接口实现的.js'))
    Everything_search()
