# encoding=utf8
import webbrowser
from PythonPlugin import PythonPlugin, PythonPluginAPI
from data_handle import data_handle
import json
from time import perf_counter

class BSearcher(PythonPlugin):

    # 必须有一个query方法，用户执行查询的时候会自动调用query方法
    def Query(self, query):
        results = []
        # start = perf_counter()
        q = query.strip()
        if not q:
            results.append({
            "Title": "书签搜索",
            "SubTitle": "搜索浏览器书签",
            "IconPath":"Images/default.png"
            })
            return results
        results.extend(data_handle().get_bookmarks(q))  # 因为返回的就是列表，应扩展列表，不是添加元素
        # end = perf_counter()
        # results.insert(0, {
        #     "Title": "{}".format(end - start),
        #     "SubTitle": "搜索浏览器书签",
        #     "IconPath":"Images/default.png"
        #     })
        return results

    # 右键功能，data是自动传入的参数，
    # {"ExtraData":"","ID":"FBA16410629F4F5DA28D904F8625F33A",
    # "SubTitle":"http://192.168.18.39:8078/admin/index/index","Title":"电视节管理平台"}
    def GetContextMenu(self, data):
        data = json.loads(data)
        results = [{
            "Title": "复制“{}”的网址".format(data['Title']),
            "SubTitle": "{}".format(data['SubTitle']),
            "IconPath":"Images/default.png",
            "Action": {
                "FuncName": "Ra_CopyPath",
                "Parameter": "{}".format(data['SubTitle'])
            }
        }, {
            "Title": "该书签所在位置（点击复制路径）",
            "SubTitle": "{}".format(data['ExtraData']),
            "IconPath":"Images/default.png",
            "Action": {
                "FuncName": "Ra_CopyPath",
                "Parameter": "{}".format(data['ExtraData'])
            }
        }]
        return results


    def openUrl(self, url):
        # open the browser
        webbrowser.open(url)


if __name__ == "__main__":
    BSearcher()
