import time
import json
import traceback
import logging
import clipboard
import sys

from PythonPlugin import PythonPlugin,PythonPluginAPI

LOG_FILE = "./logs/log_tips.log"

logging.basicConfig(level=logging.INFO,
                    format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                    datefmt='%a, %d %b %Y %H:%M:%S',
                    filename=LOG_FILE,
                    filemode='a')

class Main(PythonPlugin):
    TIPS_FILE = "./DB/tips.json"

    def Query(self, key):

        if key == "":
            return self.list_tips()
        if key in "delete":
            return self.list_delete_tips()

        results = []
        results.append({
            "Title": 'store tip : "%s"' % key,
            "SubTitle": 'tips : "%s"' % key,
            "IconPath": "Images/pic.png",
            "Action": {
                "FuncName": "store_tip",
                "Parameter": key,
                "HideWindow": False
            }
        })

        return results

    def store_tip(self, info):
        try:
            times = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
            tip = {"tip": info, "updated_time": times}
            with open(self.TIPS_FILE, "a") as f:
                f.write(json.dumps(tip) + "\n")
            PythonPluginAPI.ChangeQuery("tip")
        except:
            logging.error(traceback.format_exc())

    def get_tips(self):
        try:
            results = []
            with open(self.TIPS_FILE, "r") as f:
                for line in f:
                    line = line.strip()
                    if line:
                        tip = json.loads(line.strip())
                        results.append({"tip": tip['tip'], "updated_time": tip['updated_time']})
            return reversed(results)
        except:
            logging.error(traceback.format_exc())

    def list_delete_tips(self):
        tips = self.get_tips()
        results = []
        for tip in tips:
            results.append({
                "Title": "delete %s" % tip['tip'],
                "SubTitle": tip['updated_time'],
                "IconPath": "Images/pic.png",
                "Action": {
                    "FuncName": "delete_tip",
                    "Parameter": tip['updated_time'],
                    "HideWindow": False
                }
            })
        return results

    def delete_tip(self, times):
        try:
            tips = []
            with open(self.TIPS_FILE, "r") as f:
                for line in f:
                    tips.append(json.loads(line.strip()))
            for tip in tips:
                if times == tip["updated_time"]:
                    tips.remove(tip)
                    break
            with open(self.TIPS_FILE, "w") as f:
                for tip in tips:
                    f.write(json.dumps(tip) + "\n")
            PythonPluginAPI.ChangeQuery("tip")
        except:
            logging.error(traceback.format_exc())

    def list_tips(self):
        tips = self.get_tips()
        results = []
        for tip in tips:
            results.append({
                "Title": tip['tip'],
                "SubTitle": tip['updated_time'],
                "IconPath": "Images/pic.png",
                "Action": {
                    "FuncName": "copy_to_clip",
                    "Parameter": tip['tip'],
                    "HideWindow": False
                }
            })
        return results

    def copy_to_clip(self, text):
        clipboard.copy(text)


if __name__ == "__main__":
    Main()
