# -*- coding": "utf-8 -*-
import requests, json
import sys
import os

if len(sys.argv) > 1:
    sys.path.append(os.path.join(os.path.split(
        os.path.realpath(__file__))[0], '../../JsonRPC/'))
    from PythonPlugin import PythonPlugin, PythonPluginAPI
else:
    PythonPlugin = object

class YQAssist (PythonPlugin):

    def Query (self, query) :
        results = []
        q = query.strip()
        if not q:
            results.append({
            "Title": "疫情小助手",
            "SubTitle": "查询城市疫情信息",
            "IconPath":"Images/app.png"
            })
            return results
        
        headers = {
            'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36'}
            
        res = requests.get("https://api.inews.qq.com/newsqa/v1/query/inner/publish/modules/list?modules=statisGradeCityDetail,diseaseh5Shelf",  headers=headers)
        if not res.ok:
            results.append({
            "Title": "疫情小助手",
            "SubTitle": "访问疫情接口失败",
            "IconPath":"Images/app.png"
            })
            return results
            
        json_data = json.loads(res.content.decode())
        ret = json_data['ret']
        if ret:
            results.append({
            "Title": "疫情小助手",
            "SubTitle": "获取数据失败",
            "IconPath":"Images/app.png"
            })
            return results
        
        data = json_data['data']
        
        msgbuf = ''
        
        if q == "中国":
            msgbuf = msgbuf + "更新时间: " +  data['diseaseh5Shelf']['lastUpdateTime'] + "\n"
            msgbuf = msgbuf + "新增确诊人数: " +  str(data['diseaseh5Shelf']['chinaAdd']['nowConfirm']) + "\n"
            msgbuf = msgbuf + "新增无症状: " +  str(data['diseaseh5Shelf']['chinaAdd']['noInfect']) + "\n"
            msgbuf = msgbuf + "新增死亡人数: " +  str(data['diseaseh5Shelf']['chinaAdd']['dead']) + "\n"
            msgbuf = msgbuf + "现存确诊人数: " +  str(data['diseaseh5Shelf']['chinaTotal']['nowConfirm']) + "\n"
            msgbuf = msgbuf + "现存无症状人数: " +  str(data['diseaseh5Shelf']['chinaTotal']['noInfect']) + "\n"
            msgbuf = msgbuf + "累计确诊人数: " +  str(data['diseaseh5Shelf']['chinaTotal']['confirm']) + "\n"
            msgbuf = msgbuf + "累计治愈人数: " +  str(data['diseaseh5Shelf']['chinaTotal']['heal']) + "\n"
            msgbuf = msgbuf + "累计死亡人数: " +  str(data['diseaseh5Shelf']['chinaTotal']['dead']) + "\n"
        else:
            area_list = data['diseaseh5Shelf']['areaTree'][0]['children']
            for area in area_list:
                if area['name'] == q:
                    msgbuf = msgbuf + "更新时间: " +  str(area['total']['mtime']) + "\n"
                    msgbuf = msgbuf + "新增确诊人数: " +  str(area['today']['confirm']) + "\n"
                    msgbuf = msgbuf + "新增无症状人数: " +  str(area['today']['wzz_add']) + "\n"
                    msgbuf = msgbuf + "现存确诊人数: " +  str(area['total']['nowConfirm']) + "\n"
                    msgbuf = msgbuf + "本土无症状人数: " +  str(area['total']['wzz']) + "\n"
                    if 'suspect' in area['total']:
                        msgbuf = msgbuf + "现有疑似人数: " +  str(area['total']['suspect']) + "\n"
                    msgbuf = msgbuf + "累计确诊人数: " +  str(area['total']['confirm']) + "\n"
                    msgbuf = msgbuf + "累计治愈人数: " +  str(area['total']['heal']) + "\n"
                    msgbuf = msgbuf + "累计死亡人数: " +  str(area['total']['dead']) + "\n"
                    break
                else:
                    area_child_list = area['children']
                    for area_child in area_child_list:
                        if area_child['name'] == q:
                            msgbuf = msgbuf + "更新时间: " +  str(area_child['total']['mtime']) + "\n"
                            msgbuf = msgbuf + "新增确诊人数: " +  str(area_child['today']['confirm']) + "\n"
                            msgbuf = msgbuf + "新增无症状人数: " +  str(area_child['today']['wzz_add']) + "\n"
                            msgbuf = msgbuf + "现存确诊人数: " +  str(area_child['total']['nowConfirm']) + "\n"
                            msgbuf = msgbuf + "本土无症状人数: " +  str(area_child['total']['wzz']) + "\n"
                            if 'suspect' in area_child['total']:
                                msgbuf = msgbuf + "现有疑似人数: " +  str(area_child['total']['suspect']) + "\n"
                            msgbuf = msgbuf + "累计确诊人数: " +  str(area_child['total']['confirm']) + "\n"
                            msgbuf = msgbuf + "累计治愈人数: " +  str(area_child['total']['heal']) + "\n"
                            msgbuf = msgbuf + "累计死亡人数: " +  str(area_child['total']['dead']) + "\n"
                            break
                    
        results.append({
            "ShowType": 1, 
            "Title": "疫情小助手",
            "SubTitle": msgbuf,
            "IconPath":"Images/app.png"
            })
            
        return results

if __name__ == "__main__" :
    YQAssist()