#include "stdafx.h"
#include "MemoryDC.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CMemoryDC::CMemoryDC( CDC* pDC, CRect rect /*= CRect(0,0,0,0)*/, BOOL bCopyFirst /*= FALSE*/ ): CDC(), m_oldBitmap(NULL), m_pDC(pDC)
{
	ASSERT(m_pDC != NULL);			// ԲΪ

	m_bMemDC = !pDC->IsPrinting();

	if (m_bMemDC)
	{
		//һڴDC
		CreateCompatibleDC(pDC);
		if ( rect == CRect(0,0,0,0) )
		{
			pDC->GetClipBox(&m_rect);
		}
		else
		{
			m_rect = rect;
		}
		//λͼ
		m_bitmap.CreateCompatibleBitmap(pDC, m_rect.Width(), m_rect.Height());
		//λͼ
		m_oldBitmap = SelectObject(&m_bitmap);
		//ƶԭ
		SetWindowOrg(m_rect.left, m_rect.top);
		//θ
		if(bCopyFirst)
		{
			this->BitBlt(m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(),m_pDC, m_rect.left, m_rect.top, SRCCOPY);
		}
	} 
	else
	{
		//һǰDCйصĸ
		m_bPrinting = pDC->m_bPrinting;
		m_hDC = pDC->m_hDC;
		m_hAttribDC = pDC->m_hAttribDC;
	}
}

CMemoryDC::~CMemoryDC()
{
	if (m_bMemDC) 
	{
		//ĻλͼĻ
		m_pDC->BitBlt(m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(),	this, m_rect.left, m_rect.top, SRCCOPY);
		//ԭλͼ
		SelectObject(m_oldBitmap);
	} 
	else
	{
		m_hDC = m_hAttribDC = NULL;
	}
}

CMemoryDC* CMemoryDC::operator->()
{
	return this;
}

CMemoryDC::operator CMemoryDC*()
{
	return this;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

