#include "StdAfx.h"
#include "SkinUIMenu.h"

//////////////////////////////////////////////////////////////////////////////////
//

//϶
#define SPACE_LEFT					8									//϶С
#define SPACE_RIGHT					5									//϶С

//С
#define MENU_BAR_CX					24									//߶
#define MENU_ITEM_CY				24									//߶
#define SEPARATOR_CY				3									//ָ߶
#define MENU_BORDER					6									//˵߿

//////////////////////////////////////////////////////////////////////////////////

//˵
CMenuStringArray					CSkinUIMenu::m_MenuItemString;		//ַ
CMenuSeparatorArray					CSkinUIMenu::m_MenuItemSeparator;		//
HHOOK								CSkinUIMenu::m_hMenuHook = NULL;

WNDPROC OldWndProc = NULL; 
LRESULT lResult=0;
//////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam) 
{ 
	switch(message) 
	{ 
	case WM_CREATE: 
		{ 
			DWORD dwStyle = ::GetWindowLong(hWnd ,GWL_STYLE); 
			DWORD dwNewStyle =   (dwStyle & ~WS_BORDER); 
			::SetWindowLong(hWnd ,GWL_STYLE ,dwNewStyle); 
			DWORD dwExStyle = ::GetWindowLong(hWnd ,GWL_EXSTYLE); 
			DWORD dwNewExStyle = (dwExStyle & ~(WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE)); 
			::SetWindowLong(hWnd ,GWL_EXSTYLE, dwNewExStyle); 
			
			break;
		}
 	case WM_PRINT:   
		{
			return CallWindowProc(OldWndProc,hWnd,WM_PRINTCLIENT,wParam,lParam); 
		}
	case WM_ERASEBKGND:
		return TRUE;
 	case WM_WINDOWPOSCHANGING: 
 		{ 
 			LPWINDOWPOS lpPos = (LPWINDOWPOS)lParam; 
 
  			lpPos->cx -= MENU_BORDER; 
  			lpPos->cy -= MENU_BORDER; 

 			break;
 		}
	}

	return CallWindowProc(OldWndProc,hWnd,message,wParam,lParam); 
} 

//////////////////////////////////////////////////////////////////////////

//캯
CSkinUIMenu::CSkinUIMenu()
{
	m_pMenuBar = NULL;
	m_pMenuBack = NULL;
	m_pMenuHoven = NULL;
	m_pSeparator = NULL;
	m_pCheck = NULL;
	m_pArrow = NULL;
	m_colFrameNormal = RGB(112,123,136);
	m_nItemHeight = MENU_ITEM_CY;
}

//
CSkinUIMenu::~CSkinUIMenu()
{
	DestroyMenu();
}

//滭
VOID CSkinUIMenu::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	//Ч
	ASSERT(lpDrawItemStruct->CtlType==ODT_MENU);
	if (lpDrawItemStruct->CtlType!=ODT_MENU) return;

	//
	CRect rcItem=lpDrawItemStruct->rcItem;
	CDC * pDC=CDC::FromHandle(lpDrawItemStruct->hDC);
	CSkinMenuItem * pSkinMenuItem=(CSkinMenuItem *)lpDrawItemStruct->itemData;

	CMemoryDC BufferDC(pDC,rcItem);

	//״̬
	bool bChecked=((lpDrawItemStruct->itemState&ODS_CHECKED)!=0);
	bool bSelected=((lpDrawItemStruct->itemState&ODS_SELECTED)!=0);
	bool bGrayed=((lpDrawItemStruct->itemState&ODS_DISABLED)||(lpDrawItemStruct->itemState&ODS_GRAYED));

	//滭
	COLORREF crMenuBar=RGB(255,255,255);
	COLORREF crBorder=RGB(213,233,242);
	COLORREF crNormalBack=RGB(255,255,255);

	//˵
	if ( m_pMenuBar != NULL && m_pMenuBar->IsNull() == false )
		m_pMenuBar->Draw(&BufferDC,CRect(rcItem.left,rcItem.top,MENU_BAR_CX,rcItem.bottom));
	else
		BufferDC.FillSolidRect(rcItem.left,rcItem.top,MENU_BAR_CX,rcItem.Height(),crMenuBar);
	
	//˵ڵı
 	if ( m_pMenuBack != NULL && m_pMenuBack->IsNull() == false )
 		m_pMenuBack->Draw(&BufferDC,CRect(rcItem.left+MENU_BAR_CX,rcItem.top,rcItem.Width(),rcItem.bottom));
 	else
		BufferDC.FillSolidRect(rcItem.left+MENU_BAR_CX,rcItem.top,rcItem.Width()-MENU_BAR_CX,rcItem.Height(),crNormalBack);

	//߿
	if ((bSelected==true)&&(bGrayed==false)&&(pSkinMenuItem!=NULL)&&(pSkinMenuItem->m_MenuItemType!=MenuItemType_Separator))
	{
		if ( m_pMenuHoven != NULL && m_pMenuHoven->IsNull() == false )
		{
			CRect rcSelItem(rcItem);
			rcSelItem.left += 1;
			rcSelItem.top += 1;
			rcSelItem.bottom -= 1;
			m_pMenuHoven->Draw(&BufferDC,CRect(rcSelItem.left+1,rcSelItem.top+1,rcSelItem.Width()-1,rcSelItem.top+rcSelItem.Height()-1));
		}
		else
			BufferDC.FillSolidRect(rcItem.left+2,rcItem.top+2,rcItem.Width()-4,rcItem.Height()-4,crBorder);
	}

	//Ƽͷ
	if ( pSkinMenuItem->m_hSubMenu != NULL )
	{
		if ( m_pArrow != NULL && m_pArrow->IsNull() == false )
		{
			CRect rcArrow(rcItem.right-5-m_pArrow->GetWidth(),rcItem.top+(rcItem.Height()-m_pArrow->GetHeight())/2,rcItem.right-5,rcItem.top+(rcItem.Height()+m_pArrow->GetHeight())/2);
			m_pArrow->DrawImage(&BufferDC,rcArrow.left,rcArrow.top);
		}
	}


	//ѡ־
	if (bChecked)
	{	
		if ( m_pCheck != NULL && m_pCheck->IsNull() == false )
		{
			CRect rcIcon(rcItem.left,rcItem.top,MENU_BAR_CX,rcItem.bottom);
			m_pCheck->DrawImage(&BufferDC,(rcIcon.Width()-m_pCheck->GetWidth())/2,rcIcon.top+(rcIcon.Height()-m_pCheck->GetHeight())/2);
		}
	}

	//˵
	if (pSkinMenuItem==NULL)
	{
		//ȡϢ
		MENUITEMINFO MenuItemInfo;
		MenuItemInfo.cbSize=sizeof(MenuItemInfo);
		MenuItemInfo.fMask=MIIM_FTYPE|MIIM_BITMAP;
		GetMenuItemInfo(lpDrawItemStruct->itemID,&MenuItemInfo);

		return;
	}

	//˵
	switch (pSkinMenuItem->m_MenuItemType)
	{
	case MenuItemType_String:		//ַ˵
		{
			//
			CSkinMenuString * pSkinMenuString=(CSkinMenuString *)pSkinMenuItem;

			CRect rcIcon(rcItem.left,rcItem.top,MENU_BAR_CX,rcItem.bottom);

			if ( bSelected )
			{
				if ( pSkinMenuString->m_pImageH != NULL && pSkinMenuString->m_pImageH->IsNull() == false )
					pSkinMenuString->m_pImageH->DrawImage(&BufferDC,(rcIcon.Width()-pSkinMenuString->m_pImageH->GetWidth())/2,rcIcon.top+(rcIcon.Height()-pSkinMenuString->m_pImageH->GetHeight())/2);
				else if ( pSkinMenuString->m_pImageN != NULL && pSkinMenuString->m_pImageN->IsNull() == false )
					pSkinMenuString->m_pImageN->DrawImage(&BufferDC,(rcIcon.Width()-pSkinMenuString->m_pImageN->GetWidth())/2,rcIcon.top+(rcIcon.Height()-pSkinMenuString->m_pImageN->GetHeight())/2);
			}
			else
			{
				if ( pSkinMenuString->m_pImageN != NULL && pSkinMenuString->m_pImageN->IsNull() == false )
					pSkinMenuString->m_pImageN->DrawImage(&BufferDC,(rcIcon.Width()-pSkinMenuString->m_pImageN->GetWidth())/2,rcIcon.top+(rcIcon.Height()-pSkinMenuString->m_pImageN->GetHeight())/2);
			}

			//ɫ
			BufferDC.SetBkMode(TRANSPARENT);
			BufferDC.SelectObject(GetCtrlFont());

			//ɫ
			if (bGrayed==true) BufferDC.SetTextColor(m_colDisableText);
			else if (bSelected==true) BufferDC.SetTextColor(m_colSelectText);
			else BufferDC.SetTextColor(m_colNormalText);

			//滭ַ
			CRect rcString;
			rcString.top=rcItem.top;
			rcString.bottom=rcItem.bottom;
			rcString.right=rcItem.right-SPACE_RIGHT;
			rcString.left=rcItem.left+MENU_BAR_CX+SPACE_LEFT;
			BufferDC.DrawText(pSkinMenuString->m_strString,pSkinMenuString->m_strString.GetLength(),&rcString,DT_SINGLELINE|DT_VCENTER|DT_NOCLIP);

			break;
		}
	case MenuItemType_Separator:	//ֲ˵
		{
			//滭
			if ( m_pSeparator != NULL && m_pSeparator->IsNull() == false )
				m_pSeparator->Draw(&BufferDC,CRect(rcItem.left+MENU_BAR_CX+SPACE_LEFT,rcItem.top+1,rcItem.right-SPACE_RIGHT,rcItem.Height()-2));
			else
				BufferDC.FillSolidRect(rcItem.left+MENU_BAR_CX+SPACE_LEFT,rcItem.top+1,rcItem.Width()-MENU_BAR_CX-SPACE_LEFT-SPACE_RIGHT,rcItem.Height()-2,m_crSeparator);

			//ָı߿ɫ
			UIRenderEngine->DrawLine(BufferDC.GetSafeHdc(),CRect(rcItem.left,rcItem.top,rcItem.left+1,rcItem.top+rcItem.Height()+1),1,m_colFrameNormal);
			UIRenderEngine->DrawLine(BufferDC.GetSafeHdc(),CRect(rcItem.right-1,rcItem.top,rcItem.right,rcItem.top+rcItem.Height()+1),1,m_colFrameNormal);

			break;
		}
	}

	//Ʊ߿ɫ
	int nSeparatorCount = GetSeparatorCount();

	CRect rcClient(0,0,rcItem.right,0);
	rcClient.bottom = rcItem.Height()*(GetMenuItemCount()-nSeparatorCount)+SEPARATOR_CY*nSeparatorCount;

	UIRenderEngine->DrawRect(BufferDC.GetSafeHdc(),rcClient,1,m_colFrameNormal);

	//滭
	pDC->BitBlt(rcItem.left,rcItem.top,rcItem.Width(),rcItem.Height(),&BufferDC,rcItem.left,rcItem.top,SRCCOPY);

	//ٵӽڵ򣬴ӶϵͳƵĵ
	if ( (pSkinMenuItem->m_hSubMenu != NULL) &&  (m_pArrow != NULL && m_pArrow->IsNull() == false))
		pDC->ExcludeClipRect(rcItem.left, rcItem.top, rcItem.right, rcItem.bottom);

	return;
}

//λ
VOID CSkinUIMenu::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct)
{
	//Ч
	ASSERT(lpMeasureItemStruct->CtlType==ODT_MENU);
	if (lpMeasureItemStruct->CtlType!=ODT_MENU) return;

	//ȡ
	CSkinMenuItem * pSkinMenuItem=(CSkinMenuItem *)lpMeasureItemStruct->itemData;
	if (pSkinMenuItem==NULL)
	{
		//ȡϢ
		MENUITEMINFO MenuItemInfo;
		MenuItemInfo.cbSize=sizeof(MenuItemInfo);
		MenuItemInfo.fMask=MIIM_FTYPE|MIIM_STRING;
		GetMenuItemInfo(lpMeasureItemStruct->itemID,&MenuItemInfo);

		return;
	}

	//˵
	switch (pSkinMenuItem->m_MenuItemType)
	{
	case MenuItemType_String:		//ַ˵
		{
			//
			CSkinMenuString * pSkinMenuString=(CSkinMenuString *)pSkinMenuItem;

			// DC
			HDC hDC=GetDC(NULL);
			SelectObject(hDC,GetCtrlFont());

			//㳤
			CSize SizeString;
			GetTextExtentPoint32(hDC,pSkinMenuString->m_strString,pSkinMenuString->m_strString.GetLength(),&SizeString);

			//λ
			lpMeasureItemStruct->itemHeight=m_nItemHeight;
			lpMeasureItemStruct->itemWidth=SizeString.cx+MENU_BAR_CX+SPACE_LEFT+SPACE_RIGHT;

			//ͷԴ
			ReleaseDC(NULL,hDC);

			break;
		}
	case MenuItemType_Separator:	//ֲ˵
		{
			lpMeasureItemStruct->itemWidth=0;
			lpMeasureItemStruct->itemHeight=SEPARATOR_CY;

			break;
		}
	}

	return;
}

//˵
bool CSkinUIMenu::CreatePopupMenu()
{
	m_hMenuHook = ::SetWindowsHookEx(WH_CALLWNDPROC,CSkinUIMenu::WindowsHook,GetModuleHandle(AfxGetAppName()),::GetCurrentThreadId()); 

	return CMenu::CreatePopupMenu()?true:false;
}

//ٲ˵
BOOL CSkinUIMenu::DestroyMenu()
{
	//ٲ˵
	BOOL bRes = CMenu::DestroyMenu();
	
	//ͷ
	for (INT_PTR i=0;i<m_MenuItemActive.GetCount();i++)
	{
		FreeMenuItem(m_MenuItemActive[i]);
	}
	m_MenuItemActive.RemoveAll();

 	//ͷ
 	for (INT_PTR i=0;i<m_MenuItemString.GetCount();i++)
 	{
		UIRenderEngine->RemoveImage(m_MenuItemString.GetAt(i)->m_pImageN);
		UIRenderEngine->RemoveImage(m_MenuItemString.GetAt(i)->m_pImageH);
 		SafeDelete(m_MenuItemString.GetAt(i));
 	}
	m_MenuItemString.RemoveAll();

 	//ͷ
 	for (INT_PTR i=0;i<m_MenuItemSeparator.GetCount();i++)
 	{
 		SafeDelete(m_MenuItemSeparator.GetAt(i));
 	}
	m_MenuItemSeparator.RemoveAll();

	//жع
	UnhookWindowsHookEx(m_hMenuHook);

	UIRenderEngine->RemoveImage(m_pMenuBar);
	UIRenderEngine->RemoveImage(m_pMenuBack);
	UIRenderEngine->RemoveImage(m_pMenuHoven);
	UIRenderEngine->RemoveImage(m_pSeparator);
	UIRenderEngine->RemoveImage(m_pCheck);
	UIRenderEngine->RemoveImage(m_pArrow);

	return bRes;
}

//˵
bool CSkinUIMenu::TrackPopupMenu(CWnd * pWnd)
{
	//ȡ
	CPoint MousePoint;
	GetCursorPos(&MousePoint);

	//˵
	CMenu::TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_RIGHTBUTTON,MousePoint.x,MousePoint.y,pWnd);

	return true;
}

//˵
bool CSkinUIMenu::TrackPopupMenu(INT nXPos, INT nYPos, CWnd * pWnd)
{
	//˵
	CMenu::TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_RIGHTBUTTON,nXPos,nYPos,pWnd,NULL)?true:false;

	return true;
}

//
bool CSkinUIMenu::AppendSeparator()
{
	//ȡ
	CSkinMenuSeparator * pSkinMenuItem=(CSkinMenuSeparator *)AcitveMenuItem(MenuItemType_Separator);

	//˵
	if (pSkinMenuItem!=NULL)
	{
		CMenu::AppendMenu(MF_OWNERDRAW,0,(LPCTSTR)(pSkinMenuItem));
		return true;
	}

	return false;
}

//ַ
bool CSkinUIMenu::AppendMenu(UINT nMenuID, LPCTSTR pszString, LPCTSTR lpszIconN, LPCTSTR lpszIconH, UINT nFlags)
{
	//ж
	ASSERT((nFlags&MF_SEPARATOR)==0);
	if ((nFlags&MF_SEPARATOR)!=0) return false;

	//ȡ
	CSkinMenuString * pSkinMenuItem=(CSkinMenuString *)AcitveMenuItem(MenuItemType_String);

	//˵
	if (pSkinMenuItem!=NULL)
	{
		UIRenderEngine->RemoveImage(pSkinMenuItem->m_pImageN);
		UIRenderEngine->RemoveImage(pSkinMenuItem->m_pImageH);

		pSkinMenuItem->m_pImageN = UIRenderEngine->GetImage(lpszIconN);
		pSkinMenuItem->m_pImageH = UIRenderEngine->GetImage(lpszIconH);

		pSkinMenuItem->m_strString=pszString;
		CMenu::AppendMenu(MF_OWNERDRAW|nFlags,nMenuID,(LPCTSTR)(pSkinMenuItem));
		return true;
	}

	return false;
}

//
bool CSkinUIMenu::InsertSeparator(UINT nPosition)
{
	//ȡ
	CSkinMenuSeparator * pSkinMenuItem=(CSkinMenuSeparator *)AcitveMenuItem(MenuItemType_Separator);

	//˵
	if (pSkinMenuItem!=NULL)
	{
		CMenu::InsertMenu(nPosition,MF_OWNERDRAW,0,(LPCTSTR)(pSkinMenuItem));
		return true;
	}

	return false;
}

//ַ
bool CSkinUIMenu::InsertMenu(UINT nMenuID, LPCTSTR pszString, UINT nPosition, LPCTSTR lpszIconN, LPCTSTR lpszIconH, UINT nFlags)
{
	//ж
	ASSERT((nFlags&MF_SEPARATOR)==0);
	if ((nFlags&MF_SEPARATOR)!=0) return false;

	//ȡ
	CSkinMenuString * pSkinMenuItem=(CSkinMenuString *)AcitveMenuItem(MenuItemType_String);

	//˵
	if (pSkinMenuItem!=NULL)
	{
		UIRenderEngine->RemoveImage(pSkinMenuItem->m_pImageN);
		UIRenderEngine->RemoveImage(pSkinMenuItem->m_pImageH);

		pSkinMenuItem->m_pImageN = UIRenderEngine->GetImage(lpszIconN);
		pSkinMenuItem->m_pImageH = UIRenderEngine->GetImage(lpszIconH);

		pSkinMenuItem->m_strString=pszString;
		pSkinMenuItem->m_hSubMenu = (HMENU)nMenuID;

		CMenu::InsertMenu(nPosition,MF_OWNERDRAW|nFlags,nMenuID,(LPCTSTR)(pSkinMenuItem));
		return true;
	}

	return false;
}

//ɾ˵
bool CSkinUIMenu::RemoveMenu(UINT nPosition, UINT nFlags)
{
	return CMenu::RemoveMenu(nPosition,nFlags)?true:false;
}

//޸Ĳ˵
bool CSkinUIMenu::ModifyMenu(UINT nMenuID, LPCTSTR pszString, UINT nPosition, LPCTSTR lpszIconN, LPCTSTR lpszIconH, UINT nFlags)
{
	return 0;
}

//ͷ
VOID CSkinUIMenu::FreeMenuItem(CSkinMenuItem * pSkinMenuItem)
{
	//Ч
	ASSERT(pSkinMenuItem!=NULL);
	if (pSkinMenuItem==NULL) return;

	//
	switch (pSkinMenuItem->m_MenuItemType)
	{
	case MenuItemType_String:		//ַ
		{
			//
			CSkinMenuString * pSkinMenuString=(CSkinMenuString *)pSkinMenuItem;

			//ñ
			pSkinMenuString->m_strString.Empty();
			m_MenuItemString.Add(pSkinMenuString);

			break;
		}
	case MenuItemType_Separator:	//
		{
			//
			CSkinMenuSeparator * pSkinMenuSeparator=(CSkinMenuSeparator *)pSkinMenuItem;

			//ñ
			m_MenuItemSeparator.Add(pSkinMenuSeparator);

			break;
		}
	}

	return;
}

//ȡ
CSkinMenuItem * CSkinUIMenu::AcitveMenuItem(enMenuItemType MenuItemType)
{
	//
	CSkinMenuItem * pSkinMenuItem=NULL;

	//
	switch (MenuItemType)
	{
	case MenuItemType_String:		//ַ
		{
			if (m_MenuItemString.GetCount()>0)
			{
				INT_PTR nItemCount=m_MenuItemString.GetCount();
				pSkinMenuItem=m_MenuItemString[nItemCount-1];
				m_MenuItemString.RemoveAt(nItemCount-1);
			}
			else
			{
				pSkinMenuItem=new CSkinMenuString;
				if (pSkinMenuItem==NULL) return NULL;
			}

			break;
		}
	case MenuItemType_Separator:	//
		{
			if (m_MenuItemSeparator.GetCount()>0)
			{
				INT_PTR nItemCount=m_MenuItemSeparator.GetCount();
				pSkinMenuItem=m_MenuItemSeparator[nItemCount-1];
				m_MenuItemSeparator.RemoveAt(nItemCount-1);
			}
			else
			{
				pSkinMenuItem=new CSkinMenuSeparator;
				if (pSkinMenuItem==NULL) return NULL;
			}

			break;
		}
	default:
		{
			ASSERT(FALSE);
			return NULL;
		}
	}

	//
	m_MenuItemActive.Add(pSkinMenuItem);

	return pSkinMenuItem;
}

LRESULT CALLBACK CSkinUIMenu::WindowsHook( int code,WPARAM wParam,LPARAM lParam )
{
	PCWPSTRUCT lpCwp = (PCWPSTRUCT)lParam;

	while(code == HC_ACTION && lpCwp->message==WM_CREATE) 
	{ 
		TCHAR sClassName[10]; 
		int Count =::GetClassName(lpCwp->hwnd,sClassName,CountArray(sClassName)); 

		//Ƿ˵ 
		if( Count == 6 && _tcscmp(sClassName,TEXT("#32768"))==0) 
		{ 
			WNDPROC lastWndProc =  (WNDPROC)GetWindowLong(lpCwp->hwnd,GWL_WNDPROC); 
			if(lastWndProc != WndProc) 
			{ 
#pragma warning(disable:4311)
				SetWindowLong(lpCwp->hwnd,GWL_WNDPROC, (LONG)WndProc); 
				OldWndProc = lastWndProc; 
				break;
			} 
		} 
		break; 
	} 
	return CallNextHookEx(m_hMenuHook,code,wParam,lParam); 
}

BOOL CSkinUIMenu::SetMenuBarImage( LPCTSTR lpszFileName,CONST LPRECT lprcNinePart/*=NULL*/ )
{
	UIRenderEngine->RemoveImage(m_pMenuBar);

	m_pMenuBar = UIRenderEngine->GetImage(lpszFileName);

	if (NULL == m_pMenuBar)
		return FALSE;
	else
	{
		m_pMenuBar->SetNinePart(lprcNinePart);
		return TRUE;
	}
}

BOOL CSkinUIMenu::SetMenuBackImage( LPCTSTR lpszFileName,CONST LPRECT lprcNinePart/*=NULL*/ )
{
	UIRenderEngine->RemoveImage(m_pMenuBack);

	m_pMenuBack = UIRenderEngine->GetImage(lpszFileName);

	if (NULL == m_pMenuBack)
		return FALSE;
	else
	{
		m_pMenuBack->SetNinePart(lprcNinePart);
		return TRUE;
	}
}

BOOL CSkinUIMenu::SetMenuHovenImage( LPCTSTR lpszFileName,CONST LPRECT lprcNinePart/*=NULL*/ )
{
	UIRenderEngine->RemoveImage(m_pMenuHoven);

	m_pMenuHoven = UIRenderEngine->GetImage(lpszFileName);

	if (NULL == m_pMenuHoven)
		return FALSE;
	else
	{
		m_pMenuHoven->SetNinePart(lprcNinePart);
		return TRUE;
	}
}

BOOL CSkinUIMenu::SetSeparatorImage( LPCTSTR lpszFileName,CONST LPRECT lprcNinePart/*=NULL*/ )
{
	UIRenderEngine->RemoveImage(m_pSeparator);

	m_pSeparator = UIRenderEngine->GetImage(lpszFileName);

	if (NULL == m_pSeparator)
		return FALSE;
	else
	{
		m_pSeparator->SetNinePart(lprcNinePart);
		return TRUE;
	}
}

BOOL CSkinUIMenu::SetCheckImage( LPCTSTR lpszFileName )
{
	UIRenderEngine->RemoveImage(m_pCheck);

	m_pCheck = UIRenderEngine->GetImage(lpszFileName);

	if (NULL == m_pCheck)
		return FALSE;
	else
	{
		return TRUE;
	}
}
BOOL CSkinUIMenu::SetArrowImage( LPCTSTR lpszFileName )
{
	UIRenderEngine->RemoveImage(m_pArrow);

	m_pArrow = UIRenderEngine->GetImage(lpszFileName);

	if (NULL == m_pArrow)
		return FALSE;
	else
	{
		return TRUE;
	}
}

int CSkinUIMenu::GetSeparatorCount()
{
	int nSeparatorCount = 0;

	for (int i=0;i<m_MenuItemActive.GetCount();i++)
	{
		if ( m_MenuItemActive.GetAt(i)->m_MenuItemType == MenuItemType_Separator )
		{
			nSeparatorCount++;
		}
	}

	return nSeparatorCount;
}




//////////////////////////////////////////////////////////////////////////////////
