/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JRootPane;
import sun.awt.DebugHelper;
import sun.awt.GlobalCursorManager;

public class Container
extends Component {
    int ncomponents;
    Component[] component = new Component[4];
    LayoutManager layoutMgr;
    private LightweightDispatcher dispatcher;
    private Dimension maxSize;
    private transient Vector printingThreads = new Vector();
    private transient boolean printing = false;
    transient ContainerListener containerListener;
    transient int listeningChildren;
    transient int listeningBoundsChildren;
    private static final long serialVersionUID = 4613797578919906343L;
    private static final DebugHelper dbg = DebugHelper.create((Class)(class$java$awt$Container == null ? (class$java$awt$Container = Container.class$("java.awt.Container")) : class$java$awt$Container));
    private int containerSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$java$awt$event$ContainerListener;

    private static native void initIDs();

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0 || n >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException("No such child: " + n);
            }
            Component component = this.component[n];
            return component;
        }
    }

    public Component[] getComponents() {
        return this.getComponents_NoClientCode();
    }

    final Component[] getComponents_NoClientCode() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = new Component[this.ncomponents];
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            Component[] componentArray2 = componentArray;
            return componentArray2;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer != null && this.peer instanceof ContainerPeer) {
            ContainerPeer containerPeer = (ContainerPeer)this.peer;
            return (Insets)containerPeer.insets().clone();
        }
        return new Insets(0, 0, 0, 0);
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object object3;
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (n > this.ncomponents || n < 0 && n != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (component instanceof Container) {
                object3 = this;
                while (object3 != null) {
                    if (object3 == component) {
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                    object3 = object3.parent;
                }
                if (component instanceof Window) {
                    throw new IllegalArgumentException("adding a window to a container");
                }
            }
            if (graphicsConfiguration != null) {
                component.checkGD(graphicsConfiguration.getDevice().getIDstring());
            }
            if (component.parent != null) {
                component.parent.remove(component);
            }
            if (this.ncomponents == this.component.length) {
                object3 = new Component[this.ncomponents * 2];
                System.arraycopy(this.component, 0, object3, 0, this.ncomponents);
                this.component = object3;
            }
            if (n == -1 || n == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                this.component[n] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                object3 = new ContainerEvent((Component)this, 300, component);
                this.dispatchEvent((AWTEvent)object3);
            }
            component.createHierarchyEvents(1400, component, (Container)this, 1L);
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                GlobalCursorManager.updateCursorImmediately();
            }
        }
    }

    void checkGD(String string) {
        int n = 0;
        while (n < this.component.length) {
            Component component = this.component[n];
            if (component != null) {
                component.checkGD(string);
            }
            ++n;
        }
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.component[n];
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            this.adjustListeningChildren(32768L, -component.numListening(32768L));
            this.adjustListeningChildren(65536L, -component.numListening(65536L));
            component.parent = null;
            System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L);
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                GlobalCursorManager.updateCursorImmediately();
            }
        }
    }

    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent == this) {
                Component[] componentArray = this.component;
                int n = this.ncomponents;
                while (--n >= 0) {
                    if (componentArray[n] != component) continue;
                    this.remove(n);
                }
            }
        }
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.adjustListeningChildren(32768L, -this.listeningChildren);
            this.adjustListeningChildren(65536L, -this.listeningBoundsChildren);
            while (this.ncomponents > 0) {
                Component component = this.component[--this.ncomponents];
                this.component[this.ncomponents] = null;
                if (this.peer != null) {
                    component.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.dispatchEvent(containerEvent);
                }
                component.createHierarchyEvents(1400, component, this, 1L);
            }
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                GlobalCursorManager.updateCursorImmediately();
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    int numListening(long l) {
        int n = super.numListening(l);
        if (l == 32768L) {
            return this.listeningChildren + n;
        }
        if (l == 65536L) {
            return this.listeningBoundsChildren + n;
        }
        return n;
    }

    void adjustListeningChildren(long l, int n) {
        if (n == 0) {
            return;
        }
        if ((l & 0x8000L) != 0L) {
            this.listeningChildren += n;
        }
        if ((l & 0x10000L) != 0L) {
            this.listeningBoundsChildren += n;
        }
        if (this.parent != null) {
            this.parent.adjustListeningChildren(l, n);
        }
    }

    int createHierarchyEvents(int n, Component component, Container container, long l) {
        int n2 = 0;
        switch (n) {
            case 1400: {
                n2 = this.listeningChildren;
                break;
            }
            case 1401: 
            case 1402: {
                n2 = this.listeningBoundsChildren;
                break;
            }
        }
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0) {
            n3 -= this.component[n4].createHierarchyEvents(n, component, container, l);
            ++n4;
        }
        return n2 + super.createHierarchyEvents(n, component, container, l);
    }

    void createChildHierarchyEvents(int n, long l) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            switch (n) {
                case 1400: {
                    n2 = this.listeningChildren;
                    break;
                }
                case 1401: 
                case 1402: {
                    n2 = this.listeningBoundsChildren;
                    break;
                }
            }
            int n3 = n2;
            int n4 = 0;
            while (n3 > 0) {
                n3 -= this.component[n4].createHierarchyEvents(n, this, this.parent, l);
                ++n4;
            }
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        if (this.valid) {
            this.invalidate();
        }
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        }
    }

    public void invalidate() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
        super.invalidate();
    }

    public void validate() {
        if (!this.valid) {
            boolean bl = false;
            Object object = this.getTreeLock();
            synchronized (object) {
                if (!this.valid && this.peer != null) {
                    ContainerPeer containerPeer = null;
                    if (this.peer instanceof ContainerPeer) {
                        containerPeer = (ContainerPeer)this.peer;
                    }
                    if (containerPeer != null) {
                        containerPeer.beginValidate();
                    }
                    this.validateTree();
                    this.valid = true;
                    if (containerPeer != null) {
                        containerPeer.endValidate();
                        bl = this.isVisible();
                    }
                }
            }
            if (bl) {
                GlobalCursorManager.updateCursorImmediately();
            }
        }
    }

    protected void validateTree() {
        if (!this.valid) {
            this.doLayout();
            Component[] componentArray = this.component;
            int n = 0;
            while (n < this.ncomponents) {
                Component component = componentArray[n];
                if (component instanceof Container && !(component instanceof Window) && !component.valid) {
                    ((Container)component).validateTree();
                } else {
                    component.validate();
                }
                ++n;
            }
        }
        this.valid = true;
    }

    void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            while (n < this.ncomponents) {
                Component component = this.component[n];
                if (component instanceof Container) {
                    ((Container)component).invalidateTree();
                } else if (component.valid) {
                    component.invalidate();
                }
                ++n;
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    public void setFont(Font font) {
        boolean bl = false;
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (!(font3 == font2 || font2 != null && font2.equals(font3))) {
            this.invalidateTree();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.prefSize = this.layoutMgr != null ? this.layoutMgr.preferredLayoutSize(this) : super.preferredSize();
            return dimension2;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.minSize = this.layoutMgr != null ? this.layoutMgr.minimumLayoutSize(this) : super.minimumSize();
            return dimension2;
        }
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                this.maxSize = layoutManager2.maximumLayoutSize(this);
            }
        } else {
            this.maxSize = super.getMaximumSize();
        }
        return this.maxSize;
    }

    public float getAlignmentX() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentX(this);
            }
        } else {
            f = super.getAlignmentX();
        }
        return f;
    }

    public float getAlignmentY() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentY(this);
            }
        } else {
            f = super.getAlignmentY();
        }
        return f;
    }

    public void paint(Graphics graphics) {
        if (!(!this.isShowing() || this.printing && this.printingThreads.contains(Thread.currentThread()))) {
            GraphicsCallback.PaintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            if (!(this.peer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.width, this.height);
            }
            this.paint(graphics);
        }
    }

    public void print(Graphics graphics) {
        if (this.isShowing()) {
            Thread thread = Thread.currentThread();
            try {
                this.printingThreads.addElement(thread);
                this.printing = true;
                super.print(graphics);
                Object var4_3 = null;
                this.printingThreads.removeElement(thread);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.printingThreads.removeElement(thread);
                this.printing = !this.printingThreads.isEmpty();
                throw throwable;
            }
            this.printing = !this.printingThreads.isEmpty();
            GraphicsCallback.PrintCallback.getInstance().runComponents(this.component, graphics, 2);
        }
    }

    public void paintComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void lightweightPaint(Graphics graphics) {
        super.lightweightPaint(graphics);
        this.paintHeavyweightComponents(graphics);
    }

    void paintHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    public void printComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintAllCallback.getInstance().runComponents(this.component, graphics, 4);
        }
    }

    void lightweightPrint(Graphics graphics) {
        super.lightweightPrint(graphics);
        this.printHeavyweightComponents(graphics);
    }

    void printHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(this.component, graphics, 3);
        }
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public EventListener[] getListeners(Class clazz) {
        ContainerListener containerListener = null;
        if (clazz != (class$java$awt$event$ContainerListener == null ? (class$java$awt$event$ContainerListener = Container.class$("java.awt.event.ContainerListener")) : class$java$awt$event$ContainerListener)) {
            return super.getListeners(clazz);
        }
        containerListener = this.containerListener;
        return AWTEventMulticaster.getListeners(containerListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (n == 300 || n == 301) {
            return (this.eventMask & 2L) != 0L || this.containerListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    this.containerListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    this.containerListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.dispatcher != null && this.dispatcher.dispatchEvent(aWTEvent)) {
            aWTEvent.consume();
            if (this.peer != null) {
                this.peer.handleEvent(aWTEvent);
            }
            return;
        }
        super.dispatchEventImpl(aWTEvent);
        switch (aWTEvent.getID()) {
            case 101: {
                this.createChildHierarchyEvents(1402, 0L);
                break;
            }
            case 100: {
                this.createChildHierarchyEvents(1401, 0L);
                break;
            }
        }
    }

    void dispatchEventToSelf(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
    }

    Component getMouseEventTarget(int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null && component.contains(n - component.x, n2 - component.y) && component.peer instanceof LightweightPeer && component.visible) {
                if (component instanceof Container) {
                    Container container = (Container)component;
                    Component component2 = container.getMouseEventTarget(n - container.x, n2 - container.y, bl);
                    if (component2 != null) {
                        return component2;
                    }
                } else if (component.mouseListener != null || (component.eventMask & 0x10L) != 0L || component.mouseMotionListener != null || (component.eventMask & 0x20L) != 0L) {
                    return component;
                }
            }
            ++n4;
        }
        boolean bl3 = this.peer instanceof LightweightPeer || bl;
        boolean bl4 = this.contains(n, n2);
        boolean bl5 = this.mouseListener != null || (this.eventMask & 0x10L) != 0L;
        boolean bl6 = bl2 = this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L;
        if (bl4 && bl3 && (bl5 || bl2)) {
            return this;
        }
        return null;
    }

    void proxyEnableEvents(long l) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                this.parent.proxyEnableEvents(l);
            }
        } else if (this.dispatcher != null) {
            this.dispatcher.enableEvents(l);
        }
    }

    Window getWindow() {
        Container container = this;
        while (!(container instanceof Window)) {
            container = container.getParent();
        }
        return (Window)container;
    }

    void proxyRequestFocus(Component component) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                this.parent.proxyRequestFocus(component);
            }
        } else if (this.dispatcher != null && this.dispatcher.setFocusRequest(component)) {
            Container container = this;
            while (!(container instanceof Window) && container != null) {
                container = container.getParent();
            }
            if (container != null && ((Window)container).isActive()) {
                this.peer.requestFocus();
            }
            Toolkit.getEventQueue().changeKeyEventFocus(this);
        }
    }

    public void deliverEvent(Event event) {
        Component component = this.getComponentAt(event.x, event.y);
        if (component != null && component != this) {
            event.translate(-component.x, -component.y);
            component.deliverEvent(event);
        } else {
            this.postEvent(event);
        }
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Component locate(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3 = 0;
            while (n3 < this.ncomponents) {
                Component component = this.component[n3];
                if (component != null && !(component.peer instanceof LightweightPeer) && component.contains(n - component.x, n2 - component.y)) {
                    Component component2 = component;
                    return component2;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.ncomponents) {
                Component component = this.component[n4];
                if (component != null && component.peer instanceof LightweightPeer && component.contains(n - component.x, n2 - component.y)) {
                    Component component3 = component;
                    return component3;
                }
                ++n4;
            }
        }
        return this;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public Component findComponentAt(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.findComponentAt(n, n2, true, false);
            return component;
        }
    }

    final Component findComponentAt(int n, int n2, boolean bl, boolean bl2) {
        if (!this.contains(n, n2) || !this.visible || !bl && !this.enabled) {
            return null;
        }
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        Component component = null;
        if (bl2 && this instanceof JRootPane) {
            component = ((JRootPane)this).getGlassPane();
        }
        int n4 = 0;
        while (n4 < n3) {
            Component component2 = componentArray[n4];
            if (component2 != null && component2 != component && !(component2.peer instanceof LightweightPeer) && (component2 = component2 instanceof Container ? ((Container)component2).findComponentAt(n - component2.x, n2 - component2.y, bl, bl2) : component2.locate(n - component2.x, n2 - component2.y)) != null && component2.visible && (bl || component2.enabled)) {
                return component2;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            Component component3 = componentArray[n5];
            if (component3 != null && component3 != component && component3.peer instanceof LightweightPeer && (component3 = component3 instanceof Container ? ((Container)component3).findComponentAt(n - component3.x, n2 - component3.y, bl, bl2) : component3.locate(n - component3.x, n2 - component3.y)) != null && component3.visible && (bl || component3.enabled)) {
                return component3;
            }
            ++n5;
        }
        return this;
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (!(this.peer instanceof LightweightPeer)) {
                this.dispatcher = new LightweightDispatcher(this);
            }
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            int n2 = 0;
            while (n2 < n) {
                componentArray[n2].addNotify();
                ++n2;
            }
        }
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            int n2 = 0;
            while (n2 < n) {
                componentArray[n2].removeNotify();
                ++n2;
            }
            if (this.dispatcher != null) {
                this.dispatcher.dispose();
            }
            super.removeNotify();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAncestorOf(Component var1_1) {
        if (var1_1 != null && (var2_2 = var1_1.getParent()) != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (var2_2 == this) {
                return true;
            }
            var2_2 = var2_2.getParent();
lbl6:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    protected String paramString() {
        String string = super.paramString();
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            string = string + ",layout=" + layoutManager.getClass().getName();
        }
        return string;
    }

    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        int n2 = this.ncomponents;
        Component[] componentArray = this.component;
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray[n3];
            if (component != null) {
                component.list(printStream, n + 1);
            }
            ++n3;
        }
    }

    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        int n2 = this.ncomponents;
        Component[] componentArray = this.component;
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray[n3];
            if (component != null) {
                component.list(printWriter, n + 1);
            }
            ++n3;
        }
    }

    void setFocusOwner(Component component) {
        Container container = this.parent;
        if (container != null) {
            container.setFocusOwner(component);
        }
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.preProcessKeyEvent(keyEvent);
        }
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.postProcessKeyEvent(keyEvent);
        }
    }

    void transferFocus(Component component) {
        this.nextFocus(component);
    }

    boolean postsOldMouseEvents() {
        return true;
    }

    void nextFocus(Component component) {
        Container container = this.parent;
        if (container != null) {
            container.transferFocus(component);
        }
    }

    void applyOrientation(ComponentOrientation componentOrientation) {
        this.setComponentOrientation(componentOrientation);
        int n = 0;
        while (n < this.ncomponents) {
            Component component = this.component[n];
            if (component instanceof Container) {
                ((Container)component).applyOrientation(componentOrientation);
            } else {
                component.setComponentOrientation(componentOrientation);
            }
            ++n;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        Component[] componentArray = this.component;
        int n = 0;
        while (n < this.ncomponents) {
            componentArray[n].parent = this;
            this.adjustListeningChildren(32768L, componentArray[n].numListening(32768L));
            this.adjustListeningChildren(65536L, componentArray[n].numListening(65536L));
            ++n;
        }
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("containerL" == string) {
                this.addContainerListener((ContainerListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    Accessible getAccessibleAt(Point point) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this instanceof Accessible) {
                Object object2;
                Accessible accessible = (Accessible)((Object)this);
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext != null) {
                    int n = accessibleContext.getAccessibleChildrenCount();
                    int n2 = 0;
                    while (n2 < n) {
                        accessible = accessibleContext.getAccessibleChild(n2);
                        if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null && (object2 = accessibleContext.getAccessibleComponent()) != null && object2.isShowing()) {
                            Point point2 = object2.getLocation();
                            Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                            if (object2.contains(point3)) {
                                Accessible accessible2 = accessible;
                                return accessible2;
                            }
                        }
                        ++n2;
                    }
                }
                object2 = (Accessible)((Object)this);
                return object2;
            }
            Component component = this;
            if (!this.contains(point.x, point.y)) {
                component = null;
            } else {
                int n = this.getComponentCount();
                int n3 = 0;
                while (n3 < n) {
                    Component component2 = this.getComponent(n3);
                    if (component2 != null && component2.isShowing()) {
                        Point point4 = component2.getLocation();
                        if (component2.contains(point.x - point4.x, point.y - point4.y)) {
                            component = component2;
                        }
                    }
                    ++n3;
                }
            }
            if (component instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)component);
                return accessible;
            }
            component = null;
            return component;
        }
    }

    int getAccessibleChildrenCount() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Accessible) {
                    ++n;
                }
                ++n2;
            }
            int n3 = n;
            return n3;
        }
    }

    Accessible getAccessibleChild(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    if (n2 == n) {
                        Accessible accessible = (Accessible)((Object)componentArray[n3]);
                        return accessible;
                    }
                    ++n2;
                }
                ++n3;
            }
            Accessible accessible = null;
            return accessible;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Toolkit.loadLibraries();
        Container.initIDs();
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        protected ContainerListener accessibleContainerHandler = null;

        protected AccessibleAWTContainer() {
        }

        public int getAccessibleChildrenCount() {
            return Container.this.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n) {
            return Container.this.getAccessibleChild(n);
        }

        public Accessible getAccessibleAt(Point point) {
            return Container.this.getAccessibleAt(point);
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }
    }
}

