/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextLine;
import java.text.AttributedCharacterIterator;
import sun.awt.font.Bidi;
import sun.awt.font.TextLabelFactory;
import sun.awt.font.TextLineComponent;

public final class TextMeasurer {
    private FontRenderContext fFrc;
    private int fStart;
    private char[] fChars;
    private Bidi fBidi;
    private byte[] fLevels;
    private TextLineComponent[] fComponents;
    private boolean fIsDirectionLTR;
    private byte fBaseline;
    private float[] fBaselineOffsets;
    private float fJustifyRatio = 1.0f;

    public TextMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this.fFrc = fontRenderContext;
        this.initAll(attributedCharacterIterator);
    }

    private void initAll(AttributedCharacterIterator attributedCharacterIterator) {
        this.fStart = attributedCharacterIterator.getBeginIndex();
        this.fChars = new char[attributedCharacterIterator.getEndIndex() - this.fStart];
        int n = 0;
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            this.fChars[n++] = c;
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        try {
            Float f = (Float)attributedCharacterIterator.getAttribute(TextAttribute.JUSTIFICATION);
            if (f != null) {
                this.fJustifyRatio = f.floatValue();
                if (this.fJustifyRatio < 0.0f) {
                    this.fJustifyRatio = 0.0f;
                } else if (this.fJustifyRatio > 1.0f) {
                    this.fJustifyRatio = 1.0f;
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.fBidi = TextLine.createBidiOnParagraph(attributedCharacterIterator, this.fChars);
        this.generateComponents(attributedCharacterIterator);
    }

    private void generateComponents(AttributedCharacterIterator attributedCharacterIterator) {
        TextLine.ACIFontSource aCIFontSource = new TextLine.ACIFontSource(attributedCharacterIterator);
        TextLabelFactory textLabelFactory = new TextLabelFactory(this.fFrc, this.fChars, this.fBidi);
        int[] nArray = null;
        if (this.fBidi != null) {
            nArray = this.fBidi.getLogicalToVisualMap();
            this.fLevels = this.fBidi.getLevels();
            this.fIsDirectionLTR = this.fBidi.isDirectionLTR();
        } else {
            this.fLevels = null;
            this.fIsDirectionLTR = true;
        }
        this.fComponents = TextLine.getComponents(aCIFontSource, this.fChars, 0, this.fChars.length, nArray, this.fLevels, textLabelFactory);
        Font font = ((TextLine.FontSource)aCIFontSource).fontAt(0);
        if (font == null) {
            font = ((TextLine.FontSource)aCIFontSource).getBestFontAt(0);
        }
        LineMetrics lineMetrics = font.getLineMetrics(this.fChars, 0, 1, this.fFrc);
        this.fBaselineOffsets = lineMetrics.getBaselineOffsets();
    }

    private int calcLineBreak(int n, float f) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) break;
            n2 = n4;
            ++n3;
        }
        while (n3 < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[n3];
            int n5 = textLineComponent.getNumCharacters();
            int n6 = textLineComponent.getLineBreakIndex(n - n2, f);
            if (n6 == n5) {
                f -= textLineComponent.getAdvanceBetween(n - n2, n6);
            } else {
                return n2 + n6;
            }
            n = n2 += n5;
            ++n3;
        }
        return this.fChars.length;
    }

    private int trailingCdWhitespaceStart(int n, int n2) {
        int n3 = n2;
        if (this.fLevels != null) {
            int n4 = this.fIsDirectionLTR ? 0 : 1;
            n3 = n2 - 1;
            while (n3 >= n) {
                if (this.fLevels[n3] % 2 == n4 || Bidi.getDirectionCode((char)this.fChars[n3]) != 9) {
                    ++n3;
                    break;
                }
                --n3;
            }
        }
        return n3;
    }

    private TextLineComponent[] makeComponentsOnRange(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.trailingCdWhitespaceStart(n, n2);
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.fComponents.length) {
            n4 = n6 + this.fComponents[n7].getNumCharacters();
            if (n4 > n) break;
            n6 = n4;
            ++n7;
        }
        boolean bl = false;
        int n8 = n6;
        int n9 = n7;
        int n10 = 1;
        while (n10 != 0) {
            n3 = n8 + this.fComponents[n9].getNumCharacters();
            if (n5 > Math.max(n8, n) && n5 < Math.min(n3, n2)) {
                bl = true;
            }
            if (n3 >= n2) {
                n10 = 0;
            } else {
                n8 = n3;
            }
            ++n9;
        }
        n4 = n9 - n7;
        if (bl) {
            ++n4;
        }
        TextLineComponent[] textLineComponentArray = new TextLineComponent[n4];
        n8 = 0;
        n9 = n;
        n10 = n5;
        if (n10 == n) {
            n3 = this.fIsDirectionLTR ? 0 : 1;
            n10 = n2;
        } else {
            n3 = 2;
        }
        while (n9 < n2) {
            int n11 = this.fComponents[n7].getNumCharacters();
            int n12 = n6 + n11;
            int n13 = Math.max(n9, n6);
            int n14 = Math.min(n10, n12);
            textLineComponentArray[n8++] = this.fComponents[n7].getSubset(n13 - n6, n14 - n6, n3);
            if ((n9 += n14 - n13) == n10) {
                n10 = n2;
                int n15 = n3 = this.fIsDirectionLTR ? 0 : 1;
            }
            if (n9 != n12) continue;
            ++n7;
            n6 = n12;
        }
        return textLineComponentArray;
    }

    private TextLine makeTextLineOnRange(int n, int n2) {
        Bidi bidi;
        int[] nArray = null;
        byte[] byArray = null;
        if (this.fBidi != null) {
            bidi = this.fBidi.createLineBidi(n, n2);
            nArray = bidi.getLogicalToVisualMap();
            byArray = bidi.getLevels();
        }
        bidi = this.makeComponentsOnRange(n, n2);
        return new TextLine((TextLineComponent[])bidi, this.fBaselineOffsets, this.fChars, n, n2, nArray, byArray, this.fIsDirectionLTR);
    }

    public int getLineBreakIndex(int n, float f) {
        return this.calcLineBreak(n - this.fStart, f) + this.fStart;
    }

    public float getAdvanceBetween(int n, int n2) {
        TextLine textLine = this.makeTextLineOnRange(n - this.fStart, n2 - this.fStart);
        return textLine.getMetrics().advance;
    }

    public TextLayout getLayout(int n, int n2) {
        TextLine textLine = this.makeTextLineOnRange(n - this.fStart, n2 - this.fStart);
        return new TextLayout(textLine, this.fBaseline, this.fBaselineOffsets, this.fJustifyRatio);
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        char c;
        this.fStart = attributedCharacterIterator.getBeginIndex();
        int n2 = attributedCharacterIterator.getEndIndex();
        if (n2 - this.fStart != this.fChars.length + 1) {
            this.initAll(attributedCharacterIterator);
        }
        char[] cArray = new char[n2 - this.fStart];
        int n3 = n - this.fStart;
        System.arraycopy(this.fChars, 0, cArray, 0, n3);
        cArray[n3] = c = attributedCharacterIterator.setIndex(n);
        System.arraycopy(this.fChars, n3, cArray, n3 + 1, n2 - n - 1);
        this.fChars = cArray;
        if (this.fBidi != null || Bidi.requiresBidi((char)c) || attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING) != null) {
            this.fBidi = TextLine.createBidiOnParagraph(attributedCharacterIterator, this.fChars);
        }
        this.generateComponents(attributedCharacterIterator);
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.fStart = attributedCharacterIterator.getBeginIndex();
        int n2 = attributedCharacterIterator.getEndIndex();
        if (n2 - this.fStart != this.fChars.length - 1) {
            this.initAll(attributedCharacterIterator);
        }
        char[] cArray = new char[n2 - this.fStart];
        int n3 = n - this.fStart;
        System.arraycopy(this.fChars, 0, cArray, 0, n - this.fStart);
        System.arraycopy(this.fChars, n3 + 1, cArray, n3, n2 - n);
        this.fChars = cArray;
        if (this.fBidi != null) {
            this.fBidi = TextLine.createBidiOnParagraph(attributedCharacterIterator, this.fChars);
        }
        this.generateComponents(attributedCharacterIterator);
    }

    char[] getChars() {
        return this.fChars;
    }
}

