/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveEntry;
import sun.net.www.http.KeepAliveKey;
import sun.security.action.GetIntegerAction;

public class KeepAliveCache
extends Hashtable
implements Runnable {
    static int result = -1;
    static final int LIFETIME = 5000;

    static int getMaxConnections() {
        if (result == -1 && (result = ((Integer)AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 2))).intValue()) <= 0) {
            return 2;
        }
        return result;
    }

    public synchronized void put(URL uRL, HttpClient httpClient) {
        ClientVector clientVector;
        Object object;
        if (this.size() == 0) {
            object = this;
            AccessController.doPrivileged(new PrivilegedAction((KeepAliveCache)object){
                private final /* synthetic */ KeepAliveCache val$cache;
                {
                    this.val$cache = keepAliveCache2;
                }

                public Object run() {
                    Thread thread = null;
                    thread = new Thread(this.val$cache, "Keep-Alive-Timer:");
                    thread.setDaemon(true);
                    thread.setPriority(8);
                    thread.start();
                    return null;
                }
            });
        }
        if ((clientVector = (ClientVector)super.get(object = new KeepAliveKey(uRL))) == null) {
            int n = httpClient.getKeepAliveTimeout();
            clientVector = new ClientVector(n > 0 ? n * 1000 : 5000);
            clientVector.put(httpClient);
            super.put(object, clientVector);
        } else {
            clientVector.put(httpClient);
        }
    }

    synchronized void removeVector(KeepAliveKey keepAliveKey) {
        super.remove(keepAliveKey);
    }

    public Object get(URL uRL) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            return null;
        }
        return clientVector.get();
    }

    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                long l = System.currentTimeMillis();
                Iterator iterator = this.entrySet().iterator();
                ArrayList arrayList = new ArrayList();
                while (iterator.hasNext()) {
                    ClientVector clientVector;
                    Map.Entry entry = (Map.Entry)iterator.next();
                    KeepAliveKey keepAliveKey = (KeepAliveKey)entry.getKey();
                    ClientVector clientVector2 = clientVector = (ClientVector)entry.getValue();
                    synchronized (clientVector2) {
                        int n = 0;
                        while (n < clientVector.size()) {
                            KeepAliveEntry keepAliveEntry = (KeepAliveEntry)clientVector.elementAt(n);
                            if (l - keepAliveEntry.idleStartTime <= (long)clientVector.nap) break;
                            HttpClient httpClient = keepAliveEntry.hc;
                            httpClient.closeServer();
                            ++n;
                        }
                        clientVector.subList(0, n).clear();
                        if (clientVector.size() == 0) {
                            arrayList.add(keepAliveKey);
                        }
                    }
                }
            }
        } while (this.size() > 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

