# Change Log

## [7.4.0](https://github.com/eclipse/che/tree/7.4.0) (2019-11-07)
[Full Changelog](https://github.com/eclipse/che/compare/7.3.1...7.4.0)

**Merged pull requests:**

- Increate test timeouts for ServersCheckerTest [\#15032](https://github.com/eclipse/che/pull/15032) ([sleshchenko](https://github.com/sleshchenko))
- RELEASE: Set next development version [\#15141](https://github.com/eclipse/che/pull/15141) ([vparfonov](https://github.com/vparfonov))
- Improve docs and devfile on workspace loader development flow [\#15125](https://github.com/eclipse/che/pull/15125) ([mmorhun](https://github.com/mmorhun))
- Fix UD build [\#15112](https://github.com/eclipse/che/pull/15112) ([akurinnoy](https://github.com/akurinnoy))
- Fixing Vert.x test [\#15083](https://github.com/eclipse/che/pull/15083) ([Katka92](https://github.com/Katka92))
-  Fix TypeScript DTO generator [\#15078](https://github.com/eclipse/che/pull/15078) ([evidolob](https://github.com/evidolob))
- \[Selenium\] Adapt selenium tests from ocpoauth package [\#15058](https://github.com/eclipse/che/pull/15058) ([SkorikSergey](https://github.com/SkorikSergey))
- Fixed MeteredExecutorServiceWrapperTest that is failing some Linux system [\#15034](https://github.com/eclipse/che/pull/15034) ([skabashnyuk](https://github.com/skabashnyuk))
- Fix branding for UD [\#14984](https://github.com/eclipse/che/pull/14984) ([akurinnoy](https://github.com/akurinnoy))
- \[Selenium\] Adapt selenium tests from dashboard package [\#14980](https://github.com/eclipse/che/pull/14980) ([SkorikSergey](https://github.com/SkorikSergey))
- Do not use spy in ServerCheckerTest [\#14975](https://github.com/eclipse/che/pull/14975) ([skabashnyuk](https://github.com/skabashnyuk))
- RELEASE: Update CHANGELOG [\#14972](https://github.com/eclipse/che/pull/14972) ([vparfonov](https://github.com/vparfonov))
- Don't override entrypoint for remote binary. [\#14969](https://github.com/eclipse/che/pull/14969) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Fix bug where broker container name can exceed 63 characters [\#14964](https://github.com/eclipse/che/pull/14964) ([amisevsk](https://github.com/amisevsk))
- Remove deprecated docker infrastructure [\#14951](https://github.com/eclipse/che/pull/14951) ([skabashnyuk](https://github.com/skabashnyuk))
- Mount each private key into single kubernetes secret [\#14950](https://github.com/eclipse/che/pull/14950) ([vzhukovskii](https://github.com/vzhukovskii))
- Remove outaded agent auth filter and unused models; [\#14940](https://github.com/eclipse/che/pull/14940) ([mshaposhnik](https://github.com/mshaposhnik))
- Add support endpoints for VSCode extensions and Theia plugins. [\#14937](https://github.com/eclipse/che/pull/14937) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Change version of maven artifacts after updating the happy-path project [\#14936](https://github.com/eclipse/che/pull/14936) ([musienko-maxim](https://github.com/musienko-maxim))
- Stabilize DirectUrlFactoryWithSpecificBranchTest [\#14929](https://github.com/eclipse/che/pull/14929) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix typo in plugin broker error messages [\#14928](https://github.com/eclipse/che/pull/14928) ([amisevsk](https://github.com/amisevsk))
- Fix of Vert.x E2E test \(\#14924\) [\#14925](https://github.com/eclipse/che/pull/14925) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Upgrade metrics and tracing dependencies [\#14923](https://github.com/eclipse/che/pull/14923) ([skabashnyuk](https://github.com/skabashnyuk))
- Use newer version of Jgroups and EclipseLink to prevent PKIX errors on OCP 4.x [\#14920](https://github.com/eclipse/che/pull/14920) ([mshaposhnik](https://github.com/mshaposhnik))
- Remove old dependencies [\#14919](https://github.com/eclipse/che/pull/14919) ([vparfonov](https://github.com/vparfonov))
- Disable autosave on Devfile editor page [\#14913](https://github.com/eclipse/che/pull/14913) ([akurinnoy](https://github.com/akurinnoy))
- Use che.infrastructure.kubernetes.namespace.default during workspace namespace resolution [\#14828](https://github.com/eclipse/che/pull/14828) ([metlos](https://github.com/metlos))
- Monitoring & Tracing capability for multiple Thread pools of Che Server  [\#14727](https://github.com/eclipse/che/pull/14727) ([skabashnyuk](https://github.com/skabashnyuk))

## [7.3.1](https://github.com/eclipse/che/tree/7.3.1) (2019-10-29)
[Full Changelog](https://github.com/eclipse/che/compare/7.3.0...7.3.1)

**Merged pull requests:**

- Get rid of non-working workaround to flakiness when Java LS server initialization failed [\#14945](https://github.com/eclipse/che/pull/14945) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Disable cors on master. Cleanup cors configuration on ws-agent [\#14921](https://github.com/eclipse/che/pull/14921) ([skabashnyuk](https://github.com/skabashnyuk))
- Preview url on server [\#14713](https://github.com/eclipse/che/pull/14713) ([sparkoo](https://github.com/sparkoo))


## [7.3.0](https://github.com/eclipse/che/tree/7.3.0) (2019-10-18)
[Full Changelog](https://github.com/eclipse/che/compare/7.2.0...7.3.0)

**Merged pull requests:**

- Remove old dependencies [\#14919](https://github.com/eclipse/che/pull/14919) ([vparfonov](https://github.com/vparfonov))
- check devfile apiVersion against all supported versions [\#14869](https://github.com/eclipse/che/pull/14869) ([sparkoo](https://github.com/sparkoo))
- Add sparseCheckoutDir parameter into devfile spec [\#14823](https://github.com/eclipse/che/pull/14823) ([mmorhun](https://github.com/mmorhun))
- Added missing setnev.sh after moving from che-lib [\#14818](https://github.com/eclipse/che/pull/14818) ([skabashnyuk](https://github.com/skabashnyuk))
- Generate a new SSH key if no keys are registered while ssh mount [\#14767](https://github.com/eclipse/che/pull/14767) ([vinokurig](https://github.com/vinokurig))
- RELEASE: Set next development version [\#14690](https://github.com/eclipse/che/pull/14690) ([vparfonov](https://github.com/vparfonov))
- Migrate code from che-lib [\#14592](https://github.com/eclipse/che/pull/14592) ([skabashnyuk](https://github.com/skabashnyuk))
- RELEASE: Set next development version [\#14904](https://github.com/eclipse/che/pull/14904) ([vparfonov](https://github.com/vparfonov))
- Extend the size of the pool that is handling workspace related operations [\#14884](https://github.com/eclipse/che/pull/14884) ([skabashnyuk](https://github.com/skabashnyuk))
- Remove namespace in command prefix in Happy path tests [\#14875](https://github.com/eclipse/che/pull/14875) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: Enable java selenium E2E test to test suite [\#14870](https://github.com/eclipse/che/pull/14870) ([artaleks9](https://github.com/artaleks9))
- Selenium: Disable java selenium e2e test from test suite [\#14841](https://github.com/eclipse/che/pull/14841) ([artaleks9](https://github.com/artaleks9))
- Fix load-factory redirection in case of policies.create='peruser' [\#14836](https://github.com/eclipse/che/pull/14836) ([olexii4](https://github.com/olexii4))
- load devfile schema for validation by it's apiVersion [\#14834](https://github.com/eclipse/che/pull/14834) ([sparkoo](https://github.com/sparkoo))
- Use newer che-plugin-broker with che-theia remote runtime injection [\#14832](https://github.com/eclipse/che/pull/14832) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Validation of devfiles on workspace update [\#14826](https://github.com/eclipse/che/pull/14826) ([mshaposhnik](https://github.com/mshaposhnik))
- Add workaround for handling unexpected pop ups during redirection maven build to editor [\#14814](https://github.com/eclipse/che/pull/14814) ([musienko-maxim](https://github.com/musienko-maxim))
- Revert "Devfile validation via message entity provider" [\#14812](https://github.com/eclipse/che/pull/14812) ([mshaposhnik](https://github.com/mshaposhnik))
- E2E: Modify e2e test 'InstallCheByOperatorHub' to use with both Che and Crw [\#14798](https://github.com/eclipse/che/pull/14798) ([artaleks9](https://github.com/artaleks9))
- Serialize/deseialize list of DTO using same mechanism as single DTO object [\#14792](https://github.com/eclipse/che/pull/14792) ([mshaposhnik](https://github.com/mshaposhnik))
- Set 600 file permissions to mounted SSH keys [\#14791](https://github.com/eclipse/che/pull/14791) ([vinokurig](https://github.com/vinokurig))
- \[TS\_SELENIUM\] Create image for the "Happy Path" tests based on the "quay.io/eclipse/che-java11-maven" image [\#14779](https://github.com/eclipse/che/pull/14779) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[Selenium\] Adapt selenium test from hotupdate.recreate package [\#14777](https://github.com/eclipse/che/pull/14777) ([SkorikSergey](https://github.com/SkorikSergey))
- Increase test workspace editor memory; grab Happy path tests logs and configs [\#14774](https://github.com/eclipse/che/pull/14774) ([dmytro-ndp](https://github.com/dmytro-ndp))
- \[regression\] Fix provisioning volume for ephemeral-mode workspaces. [\#14768](https://github.com/eclipse/che/pull/14768) ([amisevsk](https://github.com/amisevsk))
- \[Selenium\] Adapt selenium tests from hotupdate.rolling package [\#14765](https://github.com/eclipse/che/pull/14765) ([SkorikSergey](https://github.com/SkorikSergey))
- chore\(github\): Fix template label for bugs [\#14757](https://github.com/eclipse/che/pull/14757) ([benoitf](https://github.com/benoitf))
- Changed default idle timeout and limit of running workspaces per user [\#14747](https://github.com/eclipse/che/pull/14747) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: Enable selenium java tests related to Github OAuth authorization [\#14744](https://github.com/eclipse/che/pull/14744) ([artaleks9](https://github.com/artaleks9))
- Devfile validation via message entity provider [\#14740](https://github.com/eclipse/che/pull/14740) ([mshaposhnik](https://github.com/mshaposhnik))
- \[TS\_SELENIUM\] Add VNC server to the "eclipse/che-e2e" docker image [\#14730](https://github.com/eclipse/che/pull/14730) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- prevent workspace restarting if user intentionally stopped it [\#14728](https://github.com/eclipse/che/pull/14728) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: Disable selenium tests related to GitHub OAuth [\#14719](https://github.com/eclipse/che/pull/14719) ([artaleks9](https://github.com/artaleks9))
- \[Selenium\] Adapt selenium tests from workspaces package [\#14716](https://github.com/eclipse/che/pull/14716) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix editor components alias attribute format to match plugins attribute format [\#14715](https://github.com/eclipse/che/pull/14715) ([mshaposhnik](https://github.com/mshaposhnik))
- Show the warning message in the case with deprecated plugins [\#14707](https://github.com/eclipse/che/pull/14707) ([olexii4](https://github.com/olexii4))
- RELEASE: Update CHANGELOG [\#14701](https://github.com/eclipse/che/pull/14701) ([vparfonov](https://github.com/vparfonov))
- Update Deployments yamls in helm charts to be compatible with k8s v1.16 [\#14700](https://github.com/eclipse/che/pull/14700) ([l0rd](https://github.com/l0rd))
- Reduce the chances that successfulCheckTest will fail [\#14688](https://github.com/eclipse/che/pull/14688) ([skabashnyuk](https://github.com/skabashnyuk))
- Change grafana configuration to match hosted che configuration [\#14684](https://github.com/eclipse/che/pull/14684) ([tomgeorge](https://github.com/tomgeorge))
- Set Y axis unit to none [\#14682](https://github.com/eclipse/che/pull/14682) ([tomgeorge](https://github.com/tomgeorge))
- Change 'Docker Registries' to 'Container Registries' [\#14675](https://github.com/eclipse/che/pull/14675) ([tomgeorge](https://github.com/tomgeorge))
- Add an ability to list available k8s namespaces [\#14541](https://github.com/eclipse/che/pull/14541) ([sleshchenko](https://github.com/sleshchenko))
- refactor: remove unused code [\#14480](https://github.com/eclipse/che/pull/14480) ([vitaliy-guliy](https://github.com/vitaliy-guliy))


## [7.2.0](https://github.com/eclipse/che/tree/7.2.0) (2019-09-27)
[Full Changelog](https://github.com/eclipse/che/compare/6.19.6...7.2.0)

**Merged pull requests:**

- Fix security vulnerability and Dashboard's workspace detail page [\#14644](https://github.com/eclipse/che/pull/14644) ([akurinnoy](https://github.com/akurinnoy))
- Change grafana dashboards for number of workspaces/users to be graphs with axes [\#14588](https://github.com/eclipse/che/pull/14588) ([tomgeorge](https://github.com/tomgeorge))
- Remove installer registry service [\#14193](https://github.com/eclipse/che/pull/14193) ([mkuznyetsov](https://github.com/mkuznyetsov))
- RELEASE: Set next development version [\#14690](https://github.com/eclipse/che/pull/14690) ([vparfonov](https://github.com/vparfonov))
- \[TS\_SELENIUM\] Increase logging of tests steps  [\#14686](https://github.com/eclipse/che/pull/14686) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[TS\_SELENIUM\] Implement workaround for issue \#14660 \(Unexpected list of suggestions when use Java languageserver\) in the "HappyPath" test. [\#14672](https://github.com/eclipse/che/pull/14672) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix a UD-branding link [\#14643](https://github.com/eclipse/che/pull/14643) ([olexii4](https://github.com/olexii4))
- \[TS\_SELENIUM\] Increase logging of tests steps [\#14642](https://github.com/eclipse/che/pull/14642) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Minor fixes to new Che workspace Grafana panels [\#14626](https://github.com/eclipse/che/pull/14626) ([mkuznyetsov](https://github.com/mkuznyetsov))
- \[Selenium\] Adapt selenium tests from ocpoauth package [\#14619](https://github.com/eclipse/che/pull/14619) ([SkorikSergey](https://github.com/SkorikSergey))
- Add component alias into runtime machine if present in origin devfile [\#14610](https://github.com/eclipse/che/pull/14610) ([mshaposhnik](https://github.com/mshaposhnik))
- \[Selenium\] Adapt selenium tests to work with workspaces from Che7 stacks [\#14594](https://github.com/eclipse/che/pull/14594) ([SkorikSergey](https://github.com/SkorikSergey))
- Add new Tomcat metrics dashboard in Grafana [\#14578](https://github.com/eclipse/che/pull/14578) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Makes sure the workspace activity checker reconciles the workspaces with their true statuses. [\#14574](https://github.com/eclipse/che/pull/14574) ([metlos](https://github.com/metlos))
- replace sed delimiters to be able to use / in docker image buildscript [\#14572](https://github.com/eclipse/che/pull/14572) ([sparkoo](https://github.com/sparkoo))
- \[Selenium\] Fix unstable selenium tests from dashboard package [\#14571](https://github.com/eclipse/che/pull/14571) ([SkorikSergey](https://github.com/SkorikSergey))
- Implement workaround for Go to Definition feature HappyPath scenario [\#14570](https://github.com/eclipse/che/pull/14570) ([musienko-maxim](https://github.com/musienko-maxim))
- Cleanup of temporary workspaces by schreduler instead of startup [\#14561](https://github.com/eclipse/che/pull/14561) ([mshaposhnik](https://github.com/mshaposhnik))
- Add Ssh Api methods to list of allowed requests signed with machine token [\#14557](https://github.com/eclipse/che/pull/14557) ([vinokurig](https://github.com/vinokurig))
- Plugin ephemeral volume feature for CheContainers [\#14539](https://github.com/eclipse/che/pull/14539) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- chore \(CONTRIBUTING.md\): update list of repos/components with links t… [\#14537](https://github.com/eclipse/che/pull/14537) ([sunix](https://github.com/sunix))
- Provide an ability to create workspaces from factories per user [\#14535](https://github.com/eclipse/che/pull/14535) ([olexii4](https://github.com/olexii4))
- Add workspaces started under 60 seconds ratio panel [\#14533](https://github.com/eclipse/che/pull/14533) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Remove WsAgent specific classes from che-core-workspace-api [\#14528](https://github.com/eclipse/che/pull/14528) ([sleshchenko](https://github.com/sleshchenko))
- workspace namespace/project placeholders [\#14524](https://github.com/eclipse/che/pull/14524) ([sparkoo](https://github.com/sparkoo))
- Adapt test after updating Monaco editor [\#14523](https://github.com/eclipse/che/pull/14523) ([musienko-maxim](https://github.com/musienko-maxim))
- Refresh keycloak token [\#14521](https://github.com/eclipse/che/pull/14521) ([akurinnoy](https://github.com/akurinnoy))
- Fail build if checksum of the downloaded artifact is not matched [\#14518](https://github.com/eclipse/che/pull/14518) ([skabashnyuk](https://github.com/skabashnyuk))
- Fix the editors list for UD [\#14515](https://github.com/eclipse/che/pull/14515) ([olexii4](https://github.com/olexii4))
- Provision name and email from user profile if preferences are empty [\#14508](https://github.com/eclipse/che/pull/14508) ([vzhukovskii](https://github.com/vzhukovskii))
- \[E2E\] Parametrize docker to set test suite [\#14507](https://github.com/eclipse/che/pull/14507) ([Katka92](https://github.com/Katka92))
- chore\(README\): fix link to other repositories [\#14501](https://github.com/eclipse/che/pull/14501) ([sunix](https://github.com/sunix))
- Add step for selecting output parser into  test [\#14493](https://github.com/eclipse/che/pull/14493) ([musienko-maxim](https://github.com/musienko-maxim))
- Add missing registration for git preferences provisioner [\#14488](https://github.com/eclipse/che/pull/14488) ([vzhukovskii](https://github.com/vzhukovskii))
- Add ability override container root command. [\#14453](https://github.com/eclipse/che/pull/14453) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Do not apply proxy settings for JWTProxy container; [\#14448](https://github.com/eclipse/che/pull/14448) ([mshaposhnik](https://github.com/mshaposhnik))
- Reconfigure Gson to parse more complex theia preference object [\#14442](https://github.com/eclipse/che/pull/14442) ([vzhukovskii](https://github.com/vzhukovskii))
- RELEASE: Update CHANGELOG for 7.1.0 [\#14441](https://github.com/eclipse/che/pull/14441) ([ibuziuk](https://github.com/ibuziuk))
- \[E2E\] Fixing bug in opening file. [\#14435](https://github.com/eclipse/che/pull/14435) ([Katka92](https://github.com/Katka92))
- RELEASE: Set next '7.2.0-SNAPSHOT' development version [\#14430](https://github.com/eclipse/che/pull/14430) ([ibuziuk](https://github.com/ibuziuk))
- \[Happy Path\] Resolve problem with debug step of the "Happy-Path" scenario [\#14420](https://github.com/eclipse/che/pull/14420) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add Host Key checking policy attribute to the ssh config [\#14418](https://github.com/eclipse/che/pull/14418) ([vinokurig](https://github.com/vinokurig))
- Correct Che image tag in Helm Chart values file [\#14396](https://github.com/eclipse/che/pull/14396) ([SamCHogg](https://github.com/SamCHogg))
- Fix PR check Jenkinsfile to use 'che-e2e' image [\#14387](https://github.com/eclipse/che/pull/14387) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Remove outdated Che6 concept. Devfile should be used instead [\#14383](https://github.com/eclipse/che/pull/14383) ([skabashnyuk](https://github.com/skabashnyuk))
- Support single-host mode on the multi-user server [\#14335](https://github.com/eclipse/che/pull/14335) ([metlos](https://github.com/metlos))
- Fix potential security vulnerabilities [\#14313](https://github.com/eclipse/che/pull/14313) ([akurinnoy](https://github.com/akurinnoy))
- Fix devfile component preferences deserialization through GSON [\#14306](https://github.com/eclipse/che/pull/14306) ([mkuznyetsov](https://github.com/mkuznyetsov))
- \[Happy-Path\] Update chromedriver to version 76.0.0 [\#14144](https://github.com/eclipse/che/pull/14144) ([Ohrimenko1988](https://github.com/Ohrimenko1988))

## [6.19.6](https://github.com/eclipse/che/tree/6.19.6) (2019-09-19)
[Full Changelog](https://github.com/eclipse/che/compare/7.1.0...6.19.6)

**Merged pull requests:**

- \[E2E\] Add test for Java Vertx workspace. [\#14558](https://github.com/eclipse/che/pull/14558) ([Katka92](https://github.com/Katka92))
- Add Grafana panels with workspace traces metrics [\#14500](https://github.com/eclipse/che/pull/14500) ([mkuznyetsov](https://github.com/mkuznyetsov))


## [7.1.0](https://github.com/eclipse/che/tree/7.1.0) (2019-09-05)
[Full Changelog](https://github.com/eclipse/che/compare/7.0.0...7.1.0)

**Merged pull requests:**

- \[E2E\] Fixing bug in opening file. [\#14435](https://github.com/eclipse/che/pull/14435) ([Katka92](https://github.com/Katka92))
- RELEASE: Set next '7.2.0-SNAPSHOT' development version [\#14430](https://github.com/eclipse/che/pull/14430) ([ibuziuk](https://github.com/ibuziuk))
- Update default plugin brokers to v0.20 - support relative paths [\#14329](https://github.com/eclipse/che/pull/14329) ([amisevsk](https://github.com/amisevsk))
- Fix handling of error status of a workspace  [\#13804](https://github.com/eclipse/che/pull/13804) ([akurinnoy](https://github.com/akurinnoy))
- \[e2e\] Added multiuser support. [\#14417](https://github.com/eclipse/che/pull/14417) ([rhopp](https://github.com/rhopp))
- Fix PR check Jenkinsfile [\#14410](https://github.com/eclipse/che/pull/14410) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Provision git configuration into each container [\#14402](https://github.com/eclipse/che/pull/14402) ([vzhukovskii](https://github.com/vzhukovskii))
- Add init containers in the che plugin model [\#14397](https://github.com/eclipse/che/pull/14397) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Update screencatcher in the e2e folder for avoiding errors [\#14394](https://github.com/eclipse/che/pull/14394) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[Happy Path\] Fix checking application readiness in HappyPath test [\#14381](https://github.com/eclipse/che/pull/14381) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix converting URL for UD [\#14377](https://github.com/eclipse/che/pull/14377) ([olexii4](https://github.com/olexii4))
- Update existed "che-e2e" image for using on CI  [\#14351](https://github.com/eclipse/che/pull/14351) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add small fixes for UD [\#14347](https://github.com/eclipse/che/pull/14347) ([olexii4](https://github.com/olexii4))
- Don't blow up on missing path transform configuration [\#14339](https://github.com/eclipse/che/pull/14339) ([metlos](https://github.com/metlos))
- \[Selenium\] Fix Java selenium tests to run against Che with next version for default plugins [\#14337](https://github.com/eclipse/che/pull/14337) ([SkorikSergey](https://github.com/SkorikSergey))
- Exclude failing java selenium tests from default execution [\#14327](https://github.com/eclipse/che/pull/14327) ([dmytro-ndp](https://github.com/dmytro-ndp))
- \[Selenium\] Delete Che7PreviewStackStartTest selenium test [\#14323](https://github.com/eclipse/che/pull/14323) ([SkorikSergey](https://github.com/SkorikSergey))
- Avoid using DtoImpls directly [\#14320](https://github.com/eclipse/che/pull/14320) ([sleshchenko](https://github.com/sleshchenko))
- factory will always use devfile generateName [\#14311](https://github.com/eclipse/che/pull/14311) ([sparkoo](https://github.com/sparkoo))
- Fix ability to scroll for UD [\#14307](https://github.com/eclipse/che/pull/14307) ([olexii4](https://github.com/olexii4))
- \[e2e\] - Add source maps. Fixes \#14298 [\#14299](https://github.com/eclipse/che/pull/14299) ([rhopp](https://github.com/rhopp))
- Fix a build errors for UD [\#14293](https://github.com/eclipse/che/pull/14293) ([olexii4](https://github.com/olexii4))
- Add trailing 0 to Happy path tests screencast png's [\#14292](https://github.com/eclipse/che/pull/14292) ([dmytro-ndp](https://github.com/dmytro-ndp))
- use the latest nightly image [\#14285](https://github.com/eclipse/che/pull/14285) ([vparfonov](https://github.com/vparfonov))
- \[HappyPath\] Make checking running application more stable [\#14284](https://github.com/eclipse/che/pull/14284) ([SkorikSergey](https://github.com/SkorikSergey))
- \[E2E\] Adding script for generating index.ts file. [\#14281](https://github.com/eclipse/che/pull/14281) ([Katka92](https://github.com/Katka92))
- Set che-plugin-registry image version to 7.0.0 [\#14278](https://github.com/eclipse/che/pull/14278) ([vparfonov](https://github.com/vparfonov))
- Add the jwt-proxy memory as a part of stack's globalMemoryLimit [\#14270](https://github.com/eclipse/che/pull/14270) ([olexii4](https://github.com/olexii4))
- Update default plugin/devfile registries to use prod-preview [\#14267](https://github.com/eclipse/che/pull/14267) ([amisevsk](https://github.com/amisevsk))
- Set all image version to the 7.0.0 to align it with CheTheia version [\#14264](https://github.com/eclipse/che/pull/14264) ([vparfonov](https://github.com/vparfonov))
- set plugin registry image to nightly [\#14259](https://github.com/eclipse/che/pull/14259) ([vparfonov](https://github.com/vparfonov))
- Revert "Use next version for default plugins" [\#14249](https://github.com/eclipse/che/pull/14249) ([vparfonov](https://github.com/vparfonov))
- Use next version for default plugins [\#14247](https://github.com/eclipse/che/pull/14247) ([vparfonov](https://github.com/vparfonov))
- \[E2E\] Stop and remove workspace on failed test [\#14246](https://github.com/eclipse/che/pull/14246) ([Katka92](https://github.com/Katka92))
- watch PVC `WaitForFirstConsumer` event to avoid deadlock [\#14239](https://github.com/eclipse/che/pull/14239) ([sparkoo](https://github.com/sparkoo))
- RELEASE: Set next development version [\#14238](https://github.com/eclipse/che/pull/14238) ([vparfonov](https://github.com/vparfonov))
- Add workspace-loader flow [\#14222](https://github.com/eclipse/che/pull/14222) ([olexii4](https://github.com/olexii4))
- Simplify build of che artifacts by PR check pipeline job [\#14214](https://github.com/eclipse/che/pull/14214) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add possibility to build images from "dockerfiles" folder with '--no-cache' option [\#14213](https://github.com/eclipse/che/pull/14213) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Make code & test independent from environment and time of execution [\#14207](https://github.com/eclipse/che/pull/14207) ([skabashnyuk](https://github.com/skabashnyuk))
- Add docs how to build Che server in Che workspace [\#14181](https://github.com/eclipse/che/pull/14181) ([mmorhun](https://github.com/mmorhun))
- Allow chePlugin preferences to be string, int or boolean type [\#14174](https://github.com/eclipse/che/pull/14174) ([mshaposhnik](https://github.com/mshaposhnik))
- add `generateName` to devfile metadata [\#14157](https://github.com/eclipse/che/pull/14157) ([sparkoo](https://github.com/sparkoo))
- Generalize the ingress configuration to support single-host in single-user mode on kubernetes [\#14134](https://github.com/eclipse/che/pull/14134) ([metlos](https://github.com/metlos))
- Remove Project Template API [\#14109](https://github.com/eclipse/che/pull/14109) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Remove Stack service [\#14078](https://github.com/eclipse/che/pull/14078) ([mkuznyetsov](https://github.com/mkuznyetsov))
- compose plugin id [\#14063](https://github.com/eclipse/che/pull/14063) ([sparkoo](https://github.com/sparkoo))
- Fix the list of workspaces in organization [\#14058](https://github.com/eclipse/che/pull/14058) ([ashumilova](https://github.com/ashumilova))
- Add target="\_blank" to the link for "Make a wish" button. [\#14037](https://github.com/eclipse/che/pull/14037) ([monaka](https://github.com/monaka))
- Make plugins/editors show one entry for each plugin with a drop down for version [\#13942](https://github.com/eclipse/che/pull/13942) ([JPinkney](https://github.com/JPinkney))
- fix \#13660 - Replace mentions of 'oAuth', by more accurate 'OAuth'. \(See https://oauth.net/\) [\#13664](https://github.com/eclipse/che/pull/13664) ([themr0c](https://github.com/themr0c))


## [7.0.0-rc-4.0](https://github.com/eclipse/che/tree/7.0.0-rc-4.0) (2019-07-25)
[Full Changelog](https://github.com/eclipse/che/compare/7.0.0-rc-3.0...7.0.0-rc-4.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#14026](https://github.com/eclipse/che/pull/14026) ([vparfonov](https://github.com/vparfonov))
- \[TS\_SELENIUM\] Resolve problem with notifications interaction \(bug \#13864\) [\#14019](https://github.com/eclipse/che/pull/14019) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Avoid using unsupported project's properties [\#13998](https://github.com/eclipse/che/pull/13998) ([ashumilova](https://github.com/ashumilova))
- \[TS SELENIUM\] Fix the \#13865 issue \(Happy Path test is sometimes failing on "Error highlighting" step\) [\#13987](https://github.com/eclipse/che/pull/13987) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add missing reference and referenceContent for action in DtoConverter [\#13957](https://github.com/eclipse/che/pull/13957) ([sleshchenko](https://github.com/sleshchenko))
- Remove the "npm" dependency vulnerability [\#13948](https://github.com/eclipse/che/pull/13948) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Store github token in session storage, remove on logout [\#13947](https://github.com/eclipse/che/pull/13947) ([ashumilova](https://github.com/ashumilova))
- Fix project clonePath is not considered on workspace creation [\#13923](https://github.com/eclipse/che/pull/13923) ([ashumilova](https://github.com/ashumilova))
- Set wildcard '\*' host name if key name start from 'default-' according to the the https://github.com/eclipse/che/issues/13494\#issuecomment-512761661 [\#13901](https://github.com/eclipse/che/pull/13901) ([vparfonov](https://github.com/vparfonov))
-  Add custom image with all required packages for init containers [\#13900](https://github.com/eclipse/che/pull/13900) ([mshaposhnik](https://github.com/mshaposhnik))
- Helm chart deploy registries [\#13890](https://github.com/eclipse/che/pull/13890) ([sparkoo](https://github.com/sparkoo))
- Adapt Java selenium e2e tests to Openshift OAuth v4 [\#13887](https://github.com/eclipse/che/pull/13887) ([dmytro-ndp](https://github.com/dmytro-ndp))
- \[TS-SELENIUM\] Adapt WorkspaceCreationAndLsInitialization test according workspace creation from Dashboard changes [\#13885](https://github.com/eclipse/che/pull/13885) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Correct the e2e selenium tests related to changes on dashboard [\#13884](https://github.com/eclipse/che/pull/13884) ([artaleks9](https://github.com/artaleks9))
- Mount the SSH keys as secrets in all workspace containers: OpenShift Env [\#13883](https://github.com/eclipse/che/pull/13883) ([vparfonov](https://github.com/vparfonov))
- Set default version of Che Theia image [\#13879](https://github.com/eclipse/che/pull/13879) ([vparfonov](https://github.com/vparfonov))
- Make name for SSH Key Config Map unique [\#13877](https://github.com/eclipse/che/pull/13877) ([vparfonov](https://github.com/vparfonov))
- Deprecate /api/devfile REST API [\#13868](https://github.com/eclipse/che/pull/13868) ([skabashnyuk](https://github.com/skabashnyuk))
- Store the container-machine mapping predictably [\#13858](https://github.com/eclipse/che/pull/13858) ([metlos](https://github.com/metlos))
- \[TS-SELENIUM\] Fix HappyPath Java language server validation [\#13851](https://github.com/eclipse/che/pull/13851) ([SkorikSergey](https://github.com/SkorikSergey))
- Stabilize part for waiting Dashboard in WorkspaceCreationAndLsInitialization test  [\#13850](https://github.com/eclipse/che/pull/13850) ([musienko-maxim](https://github.com/musienko-maxim))
- \[TS-SELENIUM\] Fix containers-happy-path.yaml reference url [\#13831](https://github.com/eclipse/che/pull/13831) ([SkorikSergey](https://github.com/SkorikSergey))
- Adapt project selector widget to manage projects from devfile [\#13825](https://github.com/eclipse/che/pull/13825) ([ashumilova](https://github.com/ashumilova))
- Remove Diagnostics widget on UD [\#13815](https://github.com/eclipse/che/pull/13815) ([akurinnoy](https://github.com/akurinnoy))
- fix\(helm\): Keep helm labels sync with che-operator so chectl is able to deploy multiuser without errors [\#13812](https://github.com/eclipse/che/pull/13812) ([benoitf](https://github.com/benoitf))
- Mount the SSH keys as secrets in all workspace containers [\#13809](https://github.com/eclipse/che/pull/13809) ([vparfonov](https://github.com/vparfonov))
- Update the use of Machines in Che [\#13808](https://github.com/eclipse/che/pull/13808) ([skabashnyuk](https://github.com/skabashnyuk))
- \[TS-SELENIUM\] Update HappyPath test according to fixed bug [\#13802](https://github.com/eclipse/che/pull/13802) ([SkorikSergey](https://github.com/SkorikSergey))
- Add `securityContext.fsGroup`. [\#13798](https://github.com/eclipse/che/pull/13798) ([monaka](https://github.com/monaka))
- \[keycloak\] Rename environment variables. [\#13791](https://github.com/eclipse/che/pull/13791) ([monaka](https://github.com/monaka))
- Initial cleanup of che6 legacy code [\#13788](https://github.com/eclipse/che/pull/13788) ([skabashnyuk](https://github.com/skabashnyuk))
- Update CODEOWNERS for the endgame [\#13786](https://github.com/eclipse/che/pull/13786) ([l0rd](https://github.com/l0rd))
- fix \#13660 - Replace mentions of 'oAuth', by more accurate 'OAuth'. \(See https://oauth.net/\) [\#13664](https://github.com/eclipse/che/pull/13664) ([themr0c](https://github.com/themr0c))

## [7.0.0-rc-3.0](https://github.com/eclipse/che/tree/7.0.0-rc-3.0) (2019-07-05)
[Full Changelog](https://github.com/eclipse/che/compare/7.0.0-RC-1.1...7.0.0-rc-3.0)

**Merged pull requests:**

- chore\(github\): Update issue template to have several choices [\#13777](https://github.com/eclipse/che/pull/13777) ([benoitf](https://github.com/benoitf))
- RELEASE: Set next development version [\#13711](https://github.com/eclipse/che/pull/13711) ([vparfonov](https://github.com/vparfonov))
- Revert "Fix handling of error status of a workspace " [\#13699](https://github.com/eclipse/che/pull/13699) ([akurinnoy](https://github.com/akurinnoy))
- \[E2E\] Change export logic [\#13697](https://github.com/eclipse/che/pull/13697) ([Katka92](https://github.com/Katka92))
- Set default Che Theia vesrsion to 7.0.0-rc-3.0 [\#13696](https://github.com/eclipse/che/pull/13696) ([vparfonov](https://github.com/vparfonov))
- Updating codeowners for Che 7 endgame code reviews [\#13684](https://github.com/eclipse/che/pull/13684) ([l0rd](https://github.com/l0rd))
- \[Selenium\] Adapt selenium tests from ocpoauth package [\#13663](https://github.com/eclipse/che/pull/13663) ([SkorikSergey](https://github.com/SkorikSergey))
- Set version 7.0.0-rc-3.0-SNAPSHOT \(rc in lowercase\) [\#13655](https://github.com/eclipse/che/pull/13655) ([vparfonov](https://github.com/vparfonov))
- Remove Docker CLI and images parts of the CLI [\#13652](https://github.com/eclipse/che/pull/13652) ([benoitf](https://github.com/benoitf))
- Set new version 7.0.0-RC-3.0-SNAPSHOT [\#13651](https://github.com/eclipse/che/pull/13651) ([vparfonov](https://github.com/vparfonov))
- modify url to get index.json [\#13645](https://github.com/eclipse/che/pull/13645) ([tobespc](https://github.com/tobespc))
- Workspace termination time metrics [\#13635](https://github.com/eclipse/che/pull/13635) ([sparkoo](https://github.com/sparkoo))
- \[TS-SELENIUM\] Cover the "Use Java IDE features and the inner loop" step from "Happy path" scenario [\#13615](https://github.com/eclipse/che/pull/13615) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Deploy legacy variable only for che6 workspaces [\#13612](https://github.com/eclipse/che/pull/13612) ([skabashnyuk](https://github.com/skabashnyuk))
- Fix the deployment failure with default `values.yaml`. [\#13598](https://github.com/eclipse/che/pull/13598) ([monaka](https://github.com/monaka))
- Support mountSources for K8S/OS components in devfile [\#13595](https://github.com/eclipse/che/pull/13595) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: Update the E2E selenium tests according to the changes on dashboard [\#13589](https://github.com/eclipse/che/pull/13589) ([artaleks9](https://github.com/artaleks9))
- Deprecate workspaces with Devfile stored as workspace config [\#13588](https://github.com/eclipse/che/pull/13588) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fix editor version in Che Devfile [\#13572](https://github.com/eclipse/che/pull/13572) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Upgrade dashboard dependencies [\#13571](https://github.com/eclipse/che/pull/13571) ([evidolob](https://github.com/evidolob))
- Add dockerfile to execute E2E Che 7 typescript tests. [\#13542](https://github.com/eclipse/che/pull/13542) ([Katka92](https://github.com/Katka92))
- Apply TS formatter and linter to workspace-loader [\#13532](https://github.com/eclipse/che/pull/13532) ([akurinnoy](https://github.com/akurinnoy))

## [7.0.0-RC-1.1](https://github.com/eclipse/che/tree/7.0.0-RC-1.1) (2019-06-19)
[Full Changelog](https://github.com/eclipse/che/compare/7.0.0-RC-2.0...7.0.0-RC-1.1)

**Merged pull requests:**

- Make Che Plugin Broker use self-signed certificate [\#13565](https://github.com/eclipse/che/pull/13565) ([sleshchenko](https://github.com/sleshchenko))
- RELEASE: Set next development version [\#13564](https://github.com/eclipse/che/pull/13564) ([vparfonov](https://github.com/vparfonov))

## [7.0.0-RC-2.0](https://github.com/eclipse/che/tree/7.0.0-RC-2.0) (2019-06-19)
[Full Changelog](https://github.com/eclipse/che/compare/7.0.0-RC-1.0...7.0.0-RC-2.0)

**Merged pull requests:**

- Fix the startup failure on the non-root runtime. [\#13573](https://github.com/eclipse/che/pull/13573) ([monaka](https://github.com/monaka))
- Allow registry passwords longer than 128 chars [\#13569](https://github.com/eclipse/che/pull/13569) ([johnmcollier](https://github.com/johnmcollier))
- Update Openshift v4 provider download URL [\#13567](https://github.com/eclipse/che/pull/13567) ([davidfestal](https://github.com/davidfestal))
- Operator-related fix and openshift v4 support [\#13554](https://github.com/eclipse/che/pull/13554) ([davidfestal](https://github.com/davidfestal))
- \#13547 fix typo gralde [\#13550](https://github.com/eclipse/che/pull/13550) ([nickboldt](https://github.com/nickboldt))
- Change plugin registry to v3 [\#13548](https://github.com/eclipse/che/pull/13548) ([nickboldt](https://github.com/nickboldt))
- Add creation of k8s secrets during deploying of broker [\#13546](https://github.com/eclipse/che/pull/13546) ([sleshchenko](https://github.com/sleshchenko))
- \[E2E\] Update typescript tests according to workspace creation changes [\#13544](https://github.com/eclipse/che/pull/13544) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix handling of error status of a workspace  [\#13535](https://github.com/eclipse/che/pull/13535) ([akurinnoy](https://github.com/akurinnoy))
- Remove non-null constraints from some devfile fields; [\#13516](https://github.com/eclipse/che/pull/13516) ([mshaposhnik](https://github.com/mshaposhnik))
- Do not serialize DTO fields with empty or null objects and arrays [\#13515](https://github.com/eclipse/che/pull/13515) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Use the metadata.name instead of name. [\#13513](https://github.com/eclipse/che/pull/13513) ([metlos](https://github.com/metlos))
- Use memory limit provided by meta.yaml in apache-camel stack [\#13505](https://github.com/eclipse/che/pull/13505) ([svor](https://github.com/svor))
- Polishing of monitoring dashboards [\#13501](https://github.com/eclipse/che/pull/13501) ([skabashnyuk](https://github.com/skabashnyuk))
- \[E2E typescript\] Fix plugins adding [\#13496](https://github.com/eclipse/che/pull/13496) ([Katka92](https://github.com/Katka92))
- K8s-like devfile naming [\#13490](https://github.com/eclipse/che/pull/13490) ([metlos](https://github.com/metlos))
- \[TS-SELENIUM\] Cover the "Start a Workspace from a devfile" step from "Happy path" scenario [\#13479](https://github.com/eclipse/che/pull/13479) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add devfile validation to /workspace/devfile endpoint [\#13472](https://github.com/eclipse/che/pull/13472) ([metlos](https://github.com/metlos))
- Create workspace from devfile [\#13469](https://github.com/eclipse/che/pull/13469) ([ashumilova](https://github.com/ashumilova))
- Selenium: remove selenium tests that check Che 6 compatible factories from CheSuite test suite [\#13468](https://github.com/eclipse/che/pull/13468) ([SkorikSergey](https://github.com/SkorikSergey))
- Initialize the empty binding for allowed environment type upgrades in k8s infrastructure [\#13466](https://github.com/eclipse/che/pull/13466) ([metlos](https://github.com/metlos))
- Rework dynamodule exclusion regexps to match nested WARs as well [\#13464](https://github.com/eclipse/che/pull/13464) ([mkuznyetsov](https://github.com/mkuznyetsov))
- RELEASE: Set next development version [\#13460](https://github.com/eclipse/che/pull/13460) ([vparfonov](https://github.com/vparfonov))
- Adding owners for `e2e` directory. [\#13457](https://github.com/eclipse/che/pull/13457) ([rhopp](https://github.com/rhopp))
- \[E2E tests\] Changes needed to reuse the tests [\#13456](https://github.com/eclipse/che/pull/13456) ([Katka92](https://github.com/Katka92))
- Attempt to create the che project multiple times if it was previously deleted. [\#13443](https://github.com/eclipse/che/pull/13443) ([metlos](https://github.com/metlos))
- Add possibility to specify reference or registry url for chePlugin/cheEditor type components [\#13297](https://github.com/eclipse/che/pull/13297) ([mshaposhnik](https://github.com/mshaposhnik))
- Decoupled monitoring configuration and deployment [\#13152](https://github.com/eclipse/che/pull/13152) ([skabashnyuk](https://github.com/skabashnyuk))

## [7.0.0-RC-1.0](https://github.com/eclipse/che/tree/7.0.0-RC-1.0) (2019-06-03)
[Full Changelog](https://github.com/eclipse/che/compare/6.19.5...7.0.0-RC-1.0)

**Merged pull requests:**

- Make workspace start errors more Che7 friendly [\#13462](https://github.com/eclipse/che/pull/13462) ([skabashnyuk](https://github.com/skabashnyuk))
- Enable to set URLs for custom registries. [\#13455](https://github.com/eclipse/che/pull/13455) ([monaka](https://github.com/monaka))
- Add -Duser.home parameter to maven opts in java-maven stack [\#13453](https://github.com/eclipse/che/pull/13453) ([amisevsk](https://github.com/amisevsk))
- Fix handling no-environment in workspace config, introduced in Che7 [\#13450](https://github.com/eclipse/che/pull/13450) ([ashumilova](https://github.com/ashumilova))
- CHE-12918 add checks for incompatible factories [\#13446](https://github.com/eclipse/che/pull/13446) ([olexii4](https://github.com/olexii4))
- Change version of redhat-java plugin to latest in stacks [\#13440](https://github.com/eclipse/che/pull/13440) ([svor](https://github.com/svor))
- Add PHP and PHP + MySQL Che-7 stacks with samples [\#13434](https://github.com/eclipse/che/pull/13434) ([svor](https://github.com/svor))
- Integrate Che Server with Devfile Registry [\#13430](https://github.com/eclipse/che/pull/13430) ([sleshchenko](https://github.com/sleshchenko))
- Merge api-devfile and api-workspace together [\#13417](https://github.com/eclipse/che/pull/13417) ([metlos](https://github.com/metlos))

## [6.19.5](https://github.com/eclipse/che/tree/6.19.5) (2019-05-29)
[Full Changelog](https://github.com/eclipse/che/compare/6.19.4...6.19.5)

**Merged pull requests:**

- Fix templates for helm 2.14.0 \(validating option is enabled\) [\#13432](https://github.com/eclipse/che/pull/13432) ([benoitf](https://github.com/benoitf))
- Used latest keycloak 6.0.1 [\#13429](https://github.com/eclipse/che/pull/13429) ([skabashnyuk](https://github.com/skabashnyuk))
- \[deploy/helm\] backport changes from chectl for templates [\#13425](https://github.com/eclipse/che/pull/13425) ([benoitf](https://github.com/benoitf))
- switch to RC version scheme [\#13424](https://github.com/eclipse/che/pull/13424) ([riuvshin](https://github.com/riuvshin))
- Fix handling supported versions based on the devfile introduction [\#13418](https://github.com/eclipse/che/pull/13418) ([ashumilova](https://github.com/ashumilova))
- Fix loader animation on factory loading page [\#13415](https://github.com/eclipse/che/pull/13415) ([akurinnoy](https://github.com/akurinnoy))
- Add an ability to disable waiting for PVCs to become bound [\#13409](https://github.com/eclipse/che/pull/13409) ([sleshchenko](https://github.com/sleshchenko))
- Add successful stopped workspaces metric [\#13404](https://github.com/eclipse/che/pull/13404) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Remove dummy workspace config if devfile is present [\#13403](https://github.com/eclipse/che/pull/13403) ([sleshchenko](https://github.com/sleshchenko))
- Add preferences for chePlugin components in Devfile [\#13341](https://github.com/eclipse/che/pull/13341) ([sleshchenko](https://github.com/sleshchenko))

## [6.19.4](https://github.com/eclipse/che/tree/6.19.4) (2019-05-23)
[Full Changelog](https://github.com/eclipse/che/compare/7.0.0-beta-5.0...6.19.4)

**Merged pull requests:**

- RELEASE: Update CHANGELOG [\#13400](https://github.com/eclipse/che/pull/13400) ([riuvshin](https://github.com/riuvshin))
- Restore account linking on newest keycloak versions [\#13398](https://github.com/eclipse/che/pull/13398) ([mshaposhnik](https://github.com/mshaposhnik))
- Fix selenium tests [\#13371](https://github.com/eclipse/che/pull/13371) ([tolusha](https://github.com/tolusha))
