/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.subwords.rcp;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.completion.rcp.tips.AbstractCompletionTipProposal;
import org.eclipse.recommenders.internal.completion.rcp.CompletionRcpPreferences;
import org.eclipse.recommenders.internal.subwords.rcp.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.BrowserUtils;
import org.eclipse.recommenders.rcp.utils.PreferencesHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EnableSubwordsCompletionProposal
extends AbstractCompletionTipProposal {
    private static final List<SessionProcessorDescriptor> NONE = Collections.emptyList();
    private static final String ABOUT_PREFERENCES = "about:preferences";
    private static final String ABOUT_ENABLE = "about:enable";
    private static final String HTTP_MANUAL = "https://www.eclipse.org/recommenders/manual/#completion-engines";
    private static final String PAGE_NAME = PreferencesHelper.createLinkLabelToPreferencePage((String)"org.eclipse.recommenders.subwords.rcp.preferencePages.subwords");
    private static final String INFO = MessageFormat.format(Messages.PROPOSAL_TOOLTIP_ENABLE_SUBWORDS_COMPLETION, PAGE_NAME, "about:preferences", "about:enable", "https://www.eclipse.org/recommenders/manual/#completion-engines");
    private final CompletionRcpPreferences preferences;

    @Inject
    public EnableSubwordsCompletionProposal(SharedImages images, CompletionRcpPreferences completionPreferences) {
        this.preferences = completionPreferences;
        Image image = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LIGHTBULB);
        this.setImage(image);
        StyledString text = new StyledString(Messages.PROPOSAL_LABEL_ENABLE_SUBWORDS_COMPLETION, StyledString.DECORATIONS_STYLER);
        this.setStyledDisplayString(text);
        this.setSortString(text.getString());
    }

    public boolean isApplicable() {
        SessionProcessorDescriptor descriptor = this.preferences.getSessionProcessorDescriptor("org.eclipse.recommenders.subwords.rcp.sessionprocessors.subwords");
        return descriptor != null && !this.preferences.isEnabled(descriptor);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        SessionProcessorDescriptor descriptor = this.preferences.getSessionProcessorDescriptor("org.eclipse.recommenders.subwords.rcp.sessionprocessors.subwords");
        if (descriptor != null) {
            this.preferences.setSessionProcessorEnabled((Collection)ImmutableList.of((Object)descriptor), NONE);
        }
    }

    private void openPreferencePage() {
        PreferencesUtil.createPreferenceDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)"org.eclipse.recommenders.subwords.rcp.preferencePages.subwords", null, null).open();
    }

    protected IInformationControl createInformationControl(Shell parent, String statusLineText) {
        return new ConfigureContentAssistInformationControl(parent, statusLineText);
    }

    private final class ConfigureContentAssistInformationControl
    extends AbstractInformationControl {
        private ConfigureContentAssistInformationControl(Shell parent, String statusLineText) {
            super(parent, statusLineText);
            this.create();
        }

        public boolean hasContents() {
            return true;
        }

        protected void createContent(Composite parent) {
            Link link = new Link(parent, 0);
            Dialog.applyDialogFont((Control)link);
            link.setForeground(parent.getForeground());
            link.setBackground(parent.getBackground());
            link.setText(INFO);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigureContentAssistInformationControl.this.dispose();
                    if (EnableSubwordsCompletionProposal.ABOUT_ENABLE.equals(e.text)) {
                        SessionProcessorDescriptor descriptor = EnableSubwordsCompletionProposal.this.preferences.getSessionProcessorDescriptor("org.eclipse.recommenders.subwords.rcp.sessionprocessors.subwords");
                        if (descriptor != null) {
                            EnableSubwordsCompletionProposal.this.preferences.setSessionProcessorEnabled((Collection)ImmutableList.of((Object)descriptor), (Collection)NONE);
                        }
                    } else if (EnableSubwordsCompletionProposal.ABOUT_PREFERENCES.equals(e.text)) {
                        EnableSubwordsCompletionProposal.this.openPreferencePage();
                    } else if (EnableSubwordsCompletionProposal.HTTP_MANUAL.equals(e.text)) {
                        BrowserUtils.openInExternalBrowser((String)e.text);
                    }
                }
            });
        }
    }
}

