/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.recommenders.internal.models.rcp.Dependencies;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.IProjectCoordinateAdvisorService;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueMethodName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCoordinateProvider
implements IProjectCoordinateProvider,
IRcpService {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectCoordinateProvider.class);
    private final JavaElementResolver javaElementResolver;
    private final IProjectCoordinateAdvisorService pcAdvisorService;
    private final LoadingCache<IPackageFragmentRoot, Optional<DependencyInfo>> dependencyInfoCache;

    @Inject
    public ProjectCoordinateProvider(IProjectCoordinateAdvisorService pcAdvisorService, JavaElementResolver javaElementResolver) {
        this.pcAdvisorService = pcAdvisorService;
        this.javaElementResolver = javaElementResolver;
        this.dependencyInfoCache = this.createCache();
    }

    private LoadingCache<IPackageFragmentRoot, Optional<DependencyInfo>> createCache() {
        return CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<IPackageFragmentRoot, Optional<DependencyInfo>>(){

            public Optional<DependencyInfo> load(IPackageFragmentRoot pfr) {
                return ProjectCoordinateProvider.this.extractDependencyInfo(pfr);
            }
        });
    }

    @Override
    public Optional<ProjectCoordinate> resolve(ITypeBinding binding) {
        if (binding == null) {
            return Optional.absent();
        }
        IType type = (IType)Checks.cast((Object)binding.getJavaElement());
        return this.resolve(type);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IType type) {
        if (type == null) {
            return Optional.absent();
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)Checks.cast((Object)type.getAncestor(3));
        return this.resolve(root);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IMethodBinding binding) {
        if (binding == null) {
            return Optional.absent();
        }
        IMethod method = (IMethod)Checks.cast((Object)binding.getJavaElement());
        return this.resolve(method);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IMethod method) {
        if (method == null) {
            return Optional.absent();
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)Checks.cast((Object)method.getAncestor(3));
        return this.resolve(root);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IPackageFragmentRoot root) {
        try {
            Optional dependencyInfo = (Optional)this.dependencyInfoCache.get((Object)root);
            if (dependencyInfo.isPresent()) {
                return this.resolve((DependencyInfo)dependencyInfo.get());
            }
            return Optional.absent();
        }
        catch (ExecutionException executionException) {
            return Optional.absent();
        }
    }

    private Optional<DependencyInfo> extractDependencyInfo(IPackageFragmentRoot root) {
        if (root == null) {
            return Optional.absent();
        }
        if (!root.isArchive()) {
            return this.extractDependencyInfo(root.getJavaProject());
        }
        File location = (File)JdtUtils.getLocation((IPackageFragmentRoot)root).orNull();
        if (location == null) {
            return Optional.absent();
        }
        IJavaProject javaProject = root.getJavaProject();
        if (ProjectCoordinateProvider.isPartOfJRE(root, javaProject)) {
            return Dependencies.createDependencyInfoForJre(javaProject);
        }
        DependencyInfo request = new DependencyInfo(location, DependencyType.JAR);
        return Optional.of((Object)request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPartOfJRE(IPackageFragmentRoot root, IJavaProject javaProject) {
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().toString().contains("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.findPackageFragmentRoots(entry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n4];
                        if (!packageFragmentRoot.getPath().toFile().getParentFile().getName().equals("ext") && packageFragmentRoot.equals(root)) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOG.error("Failed to traverse project dependencies of {}.", (Throwable)e);
        }
        return false;
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IJavaProject javaProject) {
        return this.resolve((DependencyInfo)this.extractDependencyInfo(javaProject).get());
    }

    private Optional<DependencyInfo> extractDependencyInfo(IJavaProject javaProject) {
        File location = (File)JdtUtils.getLocation((IJavaProject)javaProject).orNull();
        DependencyInfo request = new DependencyInfo(location, DependencyType.PROJECT, (Map)ImmutableMap.of((Object)"PROJECT_NAME", (Object)javaProject.getElementName()));
        return Optional.of((Object)request);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(DependencyInfo info) {
        return this.pcAdvisorService.suggest(info);
    }

    @Override
    public Optional<UniqueTypeName> toUniqueName(IType type) {
        ProjectCoordinate base = (ProjectCoordinate)this.resolve(type).orNull();
        if (base == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new UniqueTypeName(base, this.toName(type)));
    }

    @Override
    public Optional<UniqueMethodName> toUniqueName(IMethod method) {
        ProjectCoordinate base = (ProjectCoordinate)this.resolve(method).orNull();
        if (base == null) {
            return Optional.absent();
        }
        IMethodName name = (IMethodName)this.toName(method).orNull();
        if (name == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new UniqueMethodName(base, name));
    }

    @Override
    public ITypeName toName(IType type) {
        return this.javaElementResolver.toRecType(type);
    }

    @Override
    public Optional<IMethodName> toName(IMethod method) {
        return this.javaElementResolver.toRecMethod(method);
    }
}

